/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jspecify.annotations.Nullable;

public interface Aquifer {
    public static Aquifer a(NoiseChunk chunk, ChunkCoordIntPair chunkPos, NoiseRouter noiseRouter, PositionalRandomFactory positionalRandomFactory, int minY, int height, a globalFluidPicker) {
        return new c(chunk, chunkPos, noiseRouter, positionalRandomFactory, minY, height, globalFluidPicker);
    }

    public static Aquifer a(final a defaultFluid) {
        return new Aquifer(){

            @Override
            public @Nullable IBlockData a(DensityFunction.b context, double substance) {
                return substance > 0.0 ? null : defaultFluid.computeFluid(context.a(), context.b(), context.c()).a(context.b());
            }

            @Override
            public boolean a() {
                return false;
            }
        };
    }

    public @Nullable IBlockData a(DensityFunction.b var1, double var2);

    public boolean a();

    public static class c
    implements Aquifer {
        private static final int a = 10;
        private static final int b = 9;
        private static final int c = 10;
        private static final int d = 6;
        private static final int e = 3;
        private static final int f = 6;
        private static final int g = 16;
        private static final int h = 12;
        private static final int i = 16;
        private static final int j = 4;
        private static final int k = 4;
        private static final int l = 11;
        private static final double m = net.minecraft.world.level.levelgen.Aquifer$c.a(MathHelper.i(10), MathHelper.i(12));
        private static final int n = -5;
        private static final int o = 1;
        private static final int p = -5;
        private static final int q = 0;
        private static final int r = -1;
        private static final int s = 0;
        private static final int t = 1;
        private static final int u = 1;
        private static final int v = 1;
        private final NoiseChunk w;
        private final DensityFunction x;
        private final DensityFunction y;
        private final DensityFunction z;
        private final DensityFunction A;
        private final PositionalRandomFactory B;
        private final @Nullable b[] C;
        private final long[] D;
        private final a E;
        private final DensityFunction F;
        private final DensityFunction G;
        private boolean H;
        private final int I;
        private final int J;
        private final int K;
        private final int L;
        private final int M;
        private final int N;
        private static final int[][] O = new int[][]{{0, 0}, {-2, -1}, {-1, -1}, {0, -1}, {1, -1}, {-3, 0}, {-2, 0}, {-1, 0}, {1, 0}, {-2, 1}, {-1, 1}, {0, 1}, {1, 1}};

        c(NoiseChunk noiseChunk, ChunkCoordIntPair chunkPos, NoiseRouter noiseRouter, PositionalRandomFactory positionalRandomFactory, int minY, int height, a globalFluidPicker) {
            this.w = noiseChunk;
            this.x = noiseRouter.a();
            this.y = noiseRouter.b();
            this.z = noiseRouter.c();
            this.A = noiseRouter.d();
            this.F = noiseRouter.h();
            this.G = noiseRouter.i();
            this.B = positionalRandomFactory;
            this.J = net.minecraft.world.level.levelgen.Aquifer$c.a(chunkPos.e() + -5) + 0;
            this.E = globalFluidPicker;
            int i2 = net.minecraft.world.level.levelgen.Aquifer$c.a(chunkPos.g() + -5) + 1;
            this.M = i2 - this.J + 1;
            this.K = net.minecraft.world.level.levelgen.Aquifer$c.b(minY + 1) + -1;
            int i1 = net.minecraft.world.level.levelgen.Aquifer$c.b(minY + height + 1) + 1;
            int i22 = i1 - this.K + 1;
            this.L = net.minecraft.world.level.levelgen.Aquifer$c.c(chunkPos.f() + -5) + 0;
            int i3 = net.minecraft.world.level.levelgen.Aquifer$c.c(chunkPos.h() + -5) + 1;
            this.N = i3 - this.L + 1;
            int i4 = this.M * i22 * this.N;
            this.C = new b[i4];
            this.D = new long[i4];
            Arrays.fill(this.D, Long.MAX_VALUE);
            int i5 = this.e(noiseChunk.a(net.minecraft.world.level.levelgen.Aquifer$c.b(this.J, 0), net.minecraft.world.level.levelgen.Aquifer$c.d(this.L, 0), net.minecraft.world.level.levelgen.Aquifer$c.b(i2, 9), net.minecraft.world.level.levelgen.Aquifer$c.d(i3, 9)));
            int i6 = net.minecraft.world.level.levelgen.Aquifer$c.b(i5 + 12) - -1;
            this.I = net.minecraft.world.level.levelgen.Aquifer$c.c(i6, 11) - 1;
        }

        private int a(int gridX, int gridY, int gridZ) {
            int i2 = gridX - this.J;
            int i1 = gridY - this.K;
            int i22 = gridZ - this.L;
            return (i1 * this.N + i22) * this.M + i2;
        }

        @Override
        public @Nullable IBlockData a(DensityFunction.b context, double substance) {
            boolean flag2;
            double d4;
            double d3;
            IBlockData blockState1;
            if (substance > 0.0) {
                this.H = false;
                return null;
            }
            int i2 = context.a();
            int i1 = context.b();
            int i22 = context.c();
            b fluidStatus = this.E.computeFluid(i2, i1, i22);
            if (i1 > this.I) {
                this.H = false;
                return fluidStatus.a(i1);
            }
            if (fluidStatus.a(i1).a(Blocks.K)) {
                this.H = false;
                return SharedConstants.ay ? Blocks.a.m() : Blocks.K.m();
            }
            int i3 = net.minecraft.world.level.levelgen.Aquifer$c.a(i2 + -5);
            int i4 = net.minecraft.world.level.levelgen.Aquifer$c.b(i1 + 1);
            int i5 = net.minecraft.world.level.levelgen.Aquifer$c.c(i22 + -5);
            int i6 = Integer.MAX_VALUE;
            int i7 = Integer.MAX_VALUE;
            int i8 = Integer.MAX_VALUE;
            int i9 = Integer.MAX_VALUE;
            int i10 = 0;
            int i11 = 0;
            int i12 = 0;
            int i13 = 0;
            for (int i14 = 0; i14 <= 1; ++i14) {
                for (int i15 = -1; i15 <= 1; ++i15) {
                    for (int i16 = 0; i16 <= 1; ++i16) {
                        long l1;
                        int i17 = i3 + i14;
                        int i18 = i4 + i15;
                        int i19 = i5 + i16;
                        int index = this.a(i17, i18, i19);
                        long l2 = this.D[index];
                        if (l2 != Long.MAX_VALUE) {
                            l1 = l2;
                        } else {
                            RandomSource randomSource = this.B.a(i17, i18, i19);
                            this.D[index] = l1 = BlockPosition.a(net.minecraft.world.level.levelgen.Aquifer$c.b(i17, randomSource.a(10)), net.minecraft.world.level.levelgen.Aquifer$c.c(i18, randomSource.a(9)), net.minecraft.world.level.levelgen.Aquifer$c.d(i19, randomSource.a(10)));
                        }
                        int i20 = BlockPosition.a(l1) - i2;
                        int i21 = BlockPosition.b(l1) - i1;
                        int i222 = BlockPosition.c(l1) - i22;
                        int i23 = i20 * i20 + i21 * i21 + i222 * i222;
                        if (i6 >= i23) {
                            i13 = i12;
                            i12 = i11;
                            i11 = i10;
                            i10 = index;
                            i9 = i8;
                            i8 = i7;
                            i7 = i6;
                            i6 = i23;
                            continue;
                        }
                        if (i7 >= i23) {
                            i13 = i12;
                            i12 = i11;
                            i11 = index;
                            i9 = i8;
                            i8 = i7;
                            i7 = i23;
                            continue;
                        }
                        if (i8 >= i23) {
                            i13 = i12;
                            i12 = index;
                            i9 = i8;
                            i8 = i23;
                            continue;
                        }
                        if (i9 < i23) continue;
                        i13 = index;
                        i9 = i23;
                    }
                }
            }
            b aquiferStatus = this.d(i10);
            double d2 = net.minecraft.world.level.levelgen.Aquifer$c.a(i6, i7);
            IBlockData blockState = aquiferStatus.a(i1);
            IBlockData iBlockData = blockState1 = SharedConstants.ay ? Blocks.a.m() : blockState;
            if (d2 <= 0.0) {
                b aquiferStatus1;
                this.H = d2 >= m ? !aquiferStatus.equals(aquiferStatus1 = this.d(i11)) : false;
                return blockState1;
            }
            if (blockState.a(Blocks.J) && this.E.computeFluid(i2, i1 - 1, i22).a(i1 - 1).a(Blocks.K)) {
                this.H = true;
                return blockState1;
            }
            MutableDouble mutableDouble = new MutableDouble(Double.NaN);
            b aquiferStatus2 = this.d(i11);
            double d1 = d2 * this.a(context, mutableDouble, aquiferStatus, aquiferStatus2);
            if (substance + d1 > 0.0) {
                this.H = false;
                return null;
            }
            b aquiferStatus3 = this.d(i12);
            double d22 = net.minecraft.world.level.levelgen.Aquifer$c.a(i6, i8);
            if (d22 > 0.0 && substance + (d3 = d2 * d22 * this.a(context, mutableDouble, aquiferStatus, aquiferStatus3)) > 0.0) {
                this.H = false;
                return null;
            }
            double d32 = net.minecraft.world.level.levelgen.Aquifer$c.a(i7, i8);
            if (d32 > 0.0 && substance + (d4 = d2 * d32 * this.a(context, mutableDouble, aquiferStatus2, aquiferStatus3)) > 0.0) {
                this.H = false;
                return null;
            }
            boolean flag = !aquiferStatus.equals(aquiferStatus2);
            boolean flag1 = d32 >= m && !aquiferStatus2.equals(aquiferStatus3);
            boolean bl = flag2 = d22 >= m && !aquiferStatus.equals(aquiferStatus3);
            this.H = !flag && !flag1 && !flag2 ? d22 >= m && net.minecraft.world.level.levelgen.Aquifer$c.a(i6, i9) >= m && !aquiferStatus.equals(this.d(i13)) : true;
            return blockState1;
        }

        @Override
        public boolean a() {
            return this.H;
        }

        private static double a(int firstDistance, int secondDistance) {
            double d2 = 25.0;
            return 1.0 - (double)(secondDistance - firstDistance) / 25.0;
        }

        private double a(DensityFunction.b context, MutableDouble substance, b firstFluid, b secondFluid) {
            int i2 = context.b();
            IBlockData blockState = firstFluid.a(i2);
            IBlockData blockState1 = secondFluid.a(i2);
            if (!(blockState.a(Blocks.K) && blockState1.a(Blocks.J) || blockState.a(Blocks.J) && blockState1.a(Blocks.K))) {
                double d12;
                double d10;
                int abs = Math.abs(firstFluid.a - secondFluid.a);
                if (abs == 0) {
                    return 0.0;
                }
                double d2 = 0.5 * (double)(firstFluid.a + secondFluid.a);
                double d1 = (double)i2 + 0.5 - d2;
                double d22 = (double)abs / 2.0;
                double d3 = 0.0;
                double d4 = 2.5;
                double d5 = 1.5;
                double d6 = 3.0;
                double d7 = 10.0;
                double d8 = 3.0;
                double d9 = d22 - Math.abs(d1);
                double d11 = d1 > 0.0 ? ((d10 = 0.0 + d9) > 0.0 ? d10 / 1.5 : d10 / 2.5) : ((d10 = 3.0 + d9) > 0.0 ? d10 / 3.0 : d10 / 10.0);
                double d10x = 2.0;
                if (!(d11 < -2.0) && !(d11 > 2.0)) {
                    double d13 = substance.doubleValue();
                    if (Double.isNaN(d13)) {
                        double d14 = this.x.a(context);
                        substance.setValue(d14);
                        d12 = d14;
                    } else {
                        d12 = d13;
                    }
                } else {
                    d12 = 0.0;
                }
                return 2.0 * (d12 + d11);
            }
            return 2.0;
        }

        private static int a(int x2) {
            return x2 >> 4;
        }

        private static int b(int gridX, int offset) {
            return (gridX << 4) + offset;
        }

        private static int b(int y2) {
            return Math.floorDiv(y2, 12);
        }

        private static int c(int gridY, int offset) {
            return gridY * 12 + offset;
        }

        private static int c(int z2) {
            return z2 >> 4;
        }

        private static int d(int gridZ, int offset) {
            return (gridZ << 4) + offset;
        }

        private b d(int packedPos) {
            b fluidStatus1;
            b fluidStatus = this.C[packedPos];
            if (fluidStatus != null) {
                return fluidStatus;
            }
            long l2 = this.D[packedPos];
            this.C[packedPos] = fluidStatus1 = this.b(BlockPosition.a(l2), BlockPosition.b(l2), BlockPosition.c(l2));
            return fluidStatus1;
        }

        private b b(int x2, int y2, int z2) {
            b fluidStatus = this.E.computeFluid(x2, y2, z2);
            int i2 = Integer.MAX_VALUE;
            int i1 = y2 + 12;
            int i22 = y2 - 12;
            boolean flag = false;
            for (int[] ints : O) {
                b fluidStatus1;
                boolean flag2;
                boolean flag1;
                int i3 = x2 + SectionPosition.c(ints[0]);
                int i4 = z2 + SectionPosition.c(ints[1]);
                int i5 = this.w.a(i3, i4);
                int i6 = this.e(i5);
                boolean bl = flag1 = ints[0] == 0 && ints[1] == 0;
                if (flag1 && i22 > i6) {
                    return fluidStatus;
                }
                boolean bl2 = flag2 = i1 > i6;
                if ((flag2 || flag1) && !(fluidStatus1 = this.E.computeFluid(i3, i6, i4)).a(i6).l()) {
                    if (flag1) {
                        flag = true;
                    }
                    if (flag2) {
                        return fluidStatus1;
                    }
                }
                i2 = Math.min(i2, i5);
            }
            int i7 = this.a(x2, y2, z2, fluidStatus, i2, flag);
            return new b(i7, this.a(x2, y2, z2, fluidStatus, i7));
        }

        private int e(int level) {
            return level + 8;
        }

        private int a(int x2, int y2, int z2, b fluidStatus, int maxSurfaceLevel, boolean fluidPresent) {
            int i2;
            double d1;
            double d2;
            DensityFunction.e singlePointContext = new DensityFunction.e(x2, y2, z2);
            if (OverworldBiomeBuilder.a(this.F, this.G, singlePointContext)) {
                d2 = -1.0;
                d1 = -1.0;
            } else {
                i2 = maxSurfaceLevel + 8 - y2;
                int i1 = 64;
                double d22 = fluidPresent ? MathHelper.a((double)i2, 0.0, 64.0, 1.0, 0.0) : 0.0;
                double d3 = MathHelper.a(this.y.a(singlePointContext), -1.0, 1.0);
                double d4 = MathHelper.b(d22, 1.0, 0.0, -0.3, 0.8);
                double d5 = MathHelper.b(d22, 1.0, 0.0, -0.8, 0.4);
                d2 = d3 - d5;
                d1 = d3 - d4;
            }
            i2 = d1 > 0.0 ? fluidStatus.a : (d2 > 0.0 ? this.a(x2, y2, z2, maxSurfaceLevel) : -32512);
            return i2;
        }

        private int a(int x2, int y2, int z2, int maxSurfaceLevel) {
            int i2 = 16;
            int i1 = 40;
            int i22 = Math.floorDiv(x2, 16);
            int i3 = Math.floorDiv(y2, 40);
            int i4 = Math.floorDiv(z2, 16);
            int i5 = i3 * 40 + 20;
            int i6 = 10;
            double d2 = this.z.a(new DensityFunction.e(i22, i3, i4)) * 10.0;
            int i7 = MathHelper.a(d2, 3);
            int i8 = i5 + i7;
            return Math.min(maxSurfaceLevel, i8);
        }

        private IBlockData a(int x2, int y2, int z2, b fluidStatus, int surfaceLevel) {
            IBlockData blockState = fluidStatus.b;
            if (surfaceLevel <= -10 && surfaceLevel != -32512 && fluidStatus.b != Blocks.K.m()) {
                int i4;
                int i3;
                int i2 = 64;
                int i1 = 40;
                int i22 = Math.floorDiv(x2, 64);
                double d2 = this.A.a(new DensityFunction.e(i22, i3 = Math.floorDiv(y2, 40), i4 = Math.floorDiv(z2, 64)));
                if (Math.abs(d2) > 0.3) {
                    blockState = Blocks.K.m();
                }
            }
            return blockState;
        }
    }

    public static interface a {
        public b computeFluid(int var1, int var2, int var3);
    }

    public record b(int a, IBlockData b) {
        public IBlockData a(int y2) {
            return y2 < this.a ? this.b : Blocks.a.m();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "fluidLevel;fluidType", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "fluidLevel;fluidType", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "fluidLevel;fluidType", "a", "b"}, this, o2);
        }
    }
}

