/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;
import org.jspecify.annotations.Nullable;

public class NoiseChunk
implements DensityFunction.a,
DensityFunction.b {
    final int a;
    final int b;
    final int c;
    private final int d;
    private final int e;
    final int f;
    final int g;
    final List<i> h;
    final List<e> i;
    private final Map<DensityFunction, DensityFunction> j = new HashMap<DensityFunction, DensityFunction>();
    private final Long2IntMap k = new Long2IntOpenHashMap();
    private final Aquifer l;
    private final DensityFunction m;
    private final c n;
    private final Blender o;
    private final g p;
    private final g q;
    private final DensityFunctions.c r;
    private long s = ChunkCoordIntPair.c;
    private Blender.a t = new Blender.a(1.0, 0.0);
    final int u;
    final int v;
    final int w;
    boolean x;
    boolean y;
    private int z;
    int A;
    private int B;
    int C;
    int D;
    int E;
    long F;
    long G;
    int H;
    private final DensityFunction.a I = new DensityFunction.a(){

        @Override
        public DensityFunction.b a(int arrayIndex) {
            NoiseChunk.this.A = (arrayIndex + NoiseChunk.this.c) * NoiseChunk.this.w;
            ++NoiseChunk.this.F;
            NoiseChunk.this.D = 0;
            NoiseChunk.this.H = arrayIndex;
            return NoiseChunk.this;
        }

        @Override
        public void a(double[] values, DensityFunction function) {
            for (int i2 = 0; i2 < NoiseChunk.this.b + 1; ++i2) {
                NoiseChunk.this.A = (i2 + NoiseChunk.this.c) * NoiseChunk.this.w;
                ++NoiseChunk.this.F;
                NoiseChunk.this.D = 0;
                NoiseChunk.this.H = i2;
                values[i2] = function.a(NoiseChunk.this);
            }
        }
    };

    public static NoiseChunk a(IChunkAccess chunk, RandomState state, DensityFunctions.c beardifierOrMarker, GeneratorSettingBase noiseGeneratorSettings, Aquifer.a fluidPicke, Blender blender) {
        NoiseSettings noiseSettings = noiseGeneratorSettings.f().a(chunk);
        ChunkCoordIntPair pos = chunk.f();
        int i2 = 16 / noiseSettings.b();
        return new NoiseChunk(i2, state, pos.e(), pos.f(), noiseSettings, beardifierOrMarker, noiseGeneratorSettings, fluidPicke, blender);
    }

    public NoiseChunk(int cellCountXZ, RandomState random, int firstNoiseX, int firstNoiseZ, NoiseSettings noiseSettings, DensityFunctions.c beardifier, GeneratorSettingBase noiseGeneratorSettings, Aquifer.a fluidPicker, Blender blendifier) {
        int i2;
        int blockPosCoord;
        this.v = noiseSettings.b();
        this.w = noiseSettings.a();
        this.a = cellCountXZ;
        this.b = MathHelper.b(noiseSettings.d(), this.w);
        this.c = MathHelper.b(noiseSettings.c(), this.w);
        this.d = Math.floorDiv(firstNoiseX, this.v);
        this.e = Math.floorDiv(firstNoiseZ, this.v);
        this.h = Lists.newArrayList();
        this.i = Lists.newArrayList();
        this.f = QuartPos.a(firstNoiseX);
        this.g = QuartPos.a(firstNoiseZ);
        this.u = QuartPos.a(cellCountXZ * this.v);
        this.o = blendifier;
        this.r = beardifier;
        this.p = new g(new a(), false);
        this.q = new g(new b(), false);
        if (!blendifier.b()) {
            for (int i3 = 0; i3 <= this.u; ++i3) {
                int i1 = this.f + i3;
                blockPosCoord = QuartPos.c(i1);
                for (i2 = 0; i2 <= this.u; ++i2) {
                    int i32 = this.g + i2;
                    int blockPosCoord1 = QuartPos.c(i32);
                    Blender.a blendingOutput = blendifier.a(blockPosCoord, blockPosCoord1);
                    this.p.f[i3 + i2 * this.p.g] = blendingOutput.a();
                    this.q.f[i3 + i2 * this.q.g] = blendingOutput.b();
                }
            }
        } else {
            Arrays.fill(this.p.f, 1.0);
            Arrays.fill(this.q.f, 0.0);
        }
        NoiseRouter noiseRouter = random.a();
        NoiseRouter noiseRouter1 = noiseRouter.a(this::a);
        this.m = noiseRouter1.k();
        if (!noiseGeneratorSettings.b()) {
            this.l = Aquifer.a(fluidPicker);
        } else {
            blockPosCoord = SectionPosition.a(firstNoiseX);
            i2 = SectionPosition.a(firstNoiseZ);
            this.l = Aquifer.a(this, new ChunkCoordIntPair(blockPosCoord, i2), noiseRouter1, random.d(), noiseSettings.c(), noiseSettings.d(), fluidPicker);
        }
        ArrayList<c> list = new ArrayList<c>();
        DensityFunction densityFunction = DensityFunctions.e(DensityFunctions.a(noiseRouter1.l(), DensityFunctions.b.a)).a(this::a);
        list.add(context -> this.l.a(context, densityFunction.a(context)));
        if (noiseGeneratorSettings.c()) {
            list.add(OreVeinifier.a(noiseRouter1.m(), noiseRouter1.n(), noiseRouter1.o(), random.e()));
        }
        this.n = new MaterialRuleList(list.toArray(new c[0]));
    }

    protected Climate.Sampler a(NoiseRouter noiseRouter, List<Climate.d> points) {
        return new Climate.Sampler(noiseRouter.e().a(this::a), noiseRouter.f().a(this::a), noiseRouter.g().a(this::a), noiseRouter.h().a(this::a), noiseRouter.i().a(this::a), noiseRouter.j().a(this::a), points);
    }

    protected @Nullable IBlockData e() {
        return this.n.calculate(this);
    }

    @Override
    public int a() {
        return this.z + this.C;
    }

    @Override
    public int b() {
        return this.A + this.D;
    }

    @Override
    public int c() {
        return this.B + this.E;
    }

    public int a(int minX, int minZ, int maxX, int maxZ) {
        int i2 = Integer.MIN_VALUE;
        for (int i1 = minZ; i1 <= maxZ; i1 += 4) {
            for (int i22 = minX; i22 <= maxX; i22 += 4) {
                int i3 = this.a(i22, i1);
                if (i3 <= i2) continue;
                i2 = i3;
            }
        }
        return i2;
    }

    public int a(int x2, int z2) {
        int blockPosCoord = QuartPos.c(QuartPos.a(x2));
        int blockPosCoord1 = QuartPos.c(QuartPos.a(z2));
        return this.k.computeIfAbsent(BlockPosition2D.a(blockPosCoord, blockPosCoord1), this::a);
    }

    private int a(long packedChunkPos) {
        int x2 = BlockPosition2D.a(packedChunkPos);
        int z2 = BlockPosition2D.b(packedChunkPos);
        return MathHelper.c(this.m.a(new DensityFunction.e(x2, 0, z2)));
    }

    @Override
    public Blender d() {
        return this.o;
    }

    private void a(boolean isSlice0, int start) {
        this.z = start * this.v;
        this.C = 0;
        for (int i2 = 0; i2 < this.a + 1; ++i2) {
            int i1 = this.e + i2;
            this.B = i1 * this.v;
            this.E = 0;
            ++this.G;
            for (i noiseInterpolator : this.h) {
                double[] doubles = (isSlice0 ? noiseInterpolator.b : noiseInterpolator.f)[i2];
                noiseInterpolator.a(doubles, this.I);
            }
        }
        ++this.G;
    }

    public void f() {
        if (this.x) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.x = true;
        this.F = 0L;
        this.a(true, this.d);
    }

    public void b(int increment) {
        this.a(false, this.d + increment + 1);
        this.z = (this.d + increment) * this.v;
    }

    public NoiseChunk c(int arrayIndex) {
        int i2 = Math.floorMod(arrayIndex, this.v);
        int i1 = Math.floorDiv(arrayIndex, this.v);
        int i22 = Math.floorMod(i1, this.v);
        int i3 = this.w - 1 - Math.floorDiv(i1, this.v);
        this.C = i22;
        this.D = i3;
        this.E = i2;
        this.H = arrayIndex;
        return this;
    }

    @Override
    public void a(double[] values, DensityFunction function) {
        this.H = 0;
        for (int i2 = this.w - 1; i2 >= 0; --i2) {
            this.D = i2;
            for (int i1 = 0; i1 < this.v; ++i1) {
                this.C = i1;
                int i22 = 0;
                while (i22 < this.v) {
                    this.E = i22++;
                    values[this.H++] = function.a(this);
                }
            }
        }
    }

    public void b(int y2, int z2) {
        for (i noiseInterpolator : this.h) {
            noiseInterpolator.b(y2, z2);
        }
        this.y = true;
        this.A = (y2 + this.c) * this.w;
        this.B = (this.e + z2) * this.v;
        ++this.G;
        for (e cacheAllInCell : this.i) {
            cacheAllInCell.b.a(cacheAllInCell.f, this);
        }
        ++this.G;
        this.y = false;
    }

    public void a(int cellEndBlockY, double y2) {
        this.D = cellEndBlockY - this.A;
        for (i noiseInterpolator : this.h) {
            noiseInterpolator.a(y2);
        }
    }

    public void b(int cellEndBlockX, double x2) {
        this.C = cellEndBlockX - this.z;
        for (i noiseInterpolator : this.h) {
            noiseInterpolator.b(x2);
        }
    }

    public void c(int cellEndBlockZ, double z2) {
        this.E = cellEndBlockZ - this.B;
        ++this.F;
        for (i noiseInterpolator : this.h) {
            noiseInterpolator.c(z2);
        }
    }

    public void g() {
        if (!this.x) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.x = false;
    }

    public void h() {
        this.h.forEach(i::m);
    }

    public Aquifer i() {
        return this.l;
    }

    protected int j() {
        return this.v;
    }

    protected int k() {
        return this.w;
    }

    Blender.a c(int chunkX, int chunkZ) {
        Blender.a blendingOutput;
        long packedChunkPos = ChunkCoordIntPair.d(chunkX, chunkZ);
        if (this.s == packedChunkPos) {
            return this.t;
        }
        this.s = packedChunkPos;
        this.t = blendingOutput = this.o.a(chunkX, chunkZ);
        return blendingOutput;
    }

    protected DensityFunction a(DensityFunction densityFunction) {
        return this.j.computeIfAbsent(densityFunction, this::b);
    }

    private DensityFunction b(DensityFunction densityFunction) {
        DensityFunction densityFunction2;
        if (densityFunction instanceof DensityFunctions.m) {
            DensityFunctions.m marker = (DensityFunctions.m)densityFunction;
            return switch (marker.k()) {
                default -> throw new MatchException(null, null);
                case DensityFunctions.m.a.a -> new i(marker.l());
                case DensityFunctions.m.a.b -> new g(marker.l(), true);
                case DensityFunctions.m.a.c -> new d(marker.l());
                case DensityFunctions.m.a.d -> new f(marker.l());
                case DensityFunctions.m.a.e -> new e(marker.l());
            };
        }
        if (this.o != Blender.a()) {
            if (densityFunction == DensityFunctions.d.a) {
                return this.p;
            }
            if (densityFunction == DensityFunctions.f.a) {
                return this.q;
            }
        }
        if (densityFunction == DensityFunctions.b.a) {
            return this.r;
        }
        if (densityFunction instanceof DensityFunctions.k) {
            DensityFunctions.k holderHolder = (DensityFunctions.k)densityFunction;
            densityFunction2 = holderHolder.k().a();
        } else {
            densityFunction2 = densityFunction;
        }
        return densityFunction2;
    }

    class g
    implements DensityFunctions.n,
    h {
        private final DensityFunction b;
        final double[] f;
        final int g;

        g(DensityFunction noiseFiller, boolean computeValues) {
            this.b = noiseFiller;
            this.g = NoiseChunk.this.u + 1;
            this.f = new double[this.g * this.g];
            if (computeValues) {
                for (int i2 = 0; i2 <= NoiseChunk.this.u; ++i2) {
                    int i1 = NoiseChunk.this.f + i2;
                    int blockPosCoord = QuartPos.c(i1);
                    for (int i22 = 0; i22 <= NoiseChunk.this.u; ++i22) {
                        int i3 = NoiseChunk.this.g + i22;
                        int blockPosCoord1 = QuartPos.c(i3);
                        this.f[i2 + i22 * this.g] = noiseFiller.a(new DensityFunction.e(blockPosCoord, 0, blockPosCoord1));
                    }
                }
            }
        }

        @Override
        public double a(DensityFunction.b context) {
            int quartPosX = QuartPos.a(context.a());
            int quartPosZ = QuartPos.a(context.c());
            int i2 = quartPosX - NoiseChunk.this.f;
            int i1 = quartPosZ - NoiseChunk.this.g;
            return i2 >= 0 && i1 >= 0 && i2 < this.g && i1 < this.g ? this.f[i2 + i1 * this.g] : this.b.a(context);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction l() {
            return this.b;
        }

        @Override
        public DensityFunctions.m.a k() {
            return DensityFunctions.m.a.b;
        }
    }

    class a
    implements h {
        a() {
        }

        @Override
        public DensityFunction l() {
            return DensityFunctions.d.a;
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return this.l().a(visitor);
        }

        @Override
        public double a(DensityFunction.b context) {
            return NoiseChunk.this.c(context.a(), context.c()).a();
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public double a() {
            return 0.0;
        }

        @Override
        public double b() {
            return 1.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return DensityFunctions.d.b;
        }
    }

    class b
    implements h {
        b() {
        }

        @Override
        public DensityFunction l() {
            return DensityFunctions.f.a;
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return this.l().a(visitor);
        }

        @Override
        public double a(DensityFunction.b context) {
            return NoiseChunk.this.c(context.a(), context.c()).b();
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public double a() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double b() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return DensityFunctions.f.b;
        }
    }

    @FunctionalInterface
    public static interface c {
        public @Nullable IBlockData calculate(DensityFunction.b var1);
    }

    public class i
    implements DensityFunctions.n,
    h {
        double[][] b;
        double[][] f;
        private final DensityFunction g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;
        private double m;
        private double n;
        private double o;
        private double p;
        private double q;
        private double r;
        private double s;
        private double t;
        private double u;
        private double v;

        i(DensityFunction noiseFiller) {
            this.g = noiseFiller;
            this.b = this.a(NoiseChunk.this.b, NoiseChunk.this.a);
            this.f = this.a(NoiseChunk.this.b, NoiseChunk.this.a);
            NoiseChunk.this.h.add(this);
        }

        private double[][] a(int cellCountY, int cellCountXZ) {
            int i2 = cellCountXZ + 1;
            int i1 = cellCountY + 1;
            double[][] doubles = new double[i2][i1];
            for (int i22 = 0; i22 < i2; ++i22) {
                doubles[i22] = new double[i1];
            }
            return doubles;
        }

        void b(int y2, int z2) {
            this.h = this.b[z2][y2];
            this.i = this.b[z2 + 1][y2];
            this.j = this.f[z2][y2];
            this.k = this.f[z2 + 1][y2];
            this.l = this.b[z2][y2 + 1];
            this.m = this.b[z2 + 1][y2 + 1];
            this.n = this.f[z2][y2 + 1];
            this.o = this.f[z2 + 1][y2 + 1];
        }

        void a(double y2) {
            this.p = MathHelper.d(y2, this.h, this.l);
            this.q = MathHelper.d(y2, this.j, this.n);
            this.r = MathHelper.d(y2, this.i, this.m);
            this.s = MathHelper.d(y2, this.k, this.o);
        }

        void b(double x2) {
            this.t = MathHelper.d(x2, this.p, this.q);
            this.u = MathHelper.d(x2, this.r, this.s);
        }

        void c(double z2) {
            this.v = MathHelper.d(z2, this.t, this.u);
        }

        @Override
        public double a(DensityFunction.b context) {
            if (context != NoiseChunk.this) {
                return this.g.a(context);
            }
            if (!NoiseChunk.this.x) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            return NoiseChunk.this.y ? MathHelper.a((double)NoiseChunk.this.C / (double)NoiseChunk.this.v, (double)NoiseChunk.this.D / (double)NoiseChunk.this.w, (double)NoiseChunk.this.E / (double)NoiseChunk.this.v, this.h, this.j, this.l, this.n, this.i, this.k, this.m, this.o) : this.v;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            if (NoiseChunk.this.y) {
                contextProvider.a(array, this);
            } else {
                this.l().a(array, contextProvider);
            }
        }

        @Override
        public DensityFunction l() {
            return this.g;
        }

        private void m() {
            double[][] doubles = this.b;
            this.b = this.f;
            this.f = doubles;
        }

        @Override
        public DensityFunctions.m.a k() {
            return DensityFunctions.m.a.a;
        }
    }

    class e
    implements DensityFunctions.n,
    h {
        final DensityFunction b;
        final double[] f;

        e(DensityFunction noiseFiller) {
            this.b = noiseFiller;
            this.f = new double[NoiseChunk.this.v * NoiseChunk.this.v * NoiseChunk.this.w];
            NoiseChunk.this.i.add(this);
        }

        @Override
        public double a(DensityFunction.b context) {
            if (context != NoiseChunk.this) {
                return this.b.a(context);
            }
            if (!NoiseChunk.this.x) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            int i2 = NoiseChunk.this.C;
            int i1 = NoiseChunk.this.D;
            int i22 = NoiseChunk.this.E;
            return i2 >= 0 && i1 >= 0 && i22 >= 0 && i2 < NoiseChunk.this.v && i1 < NoiseChunk.this.w && i22 < NoiseChunk.this.v ? this.f[((NoiseChunk.this.w - 1 - i1) * NoiseChunk.this.v + i2) * NoiseChunk.this.v + i22] : this.b.a(context);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction l() {
            return this.b;
        }

        @Override
        public DensityFunctions.m.a k() {
            return DensityFunctions.m.a.e;
        }
    }

    static class d
    implements DensityFunctions.n,
    h {
        private final DensityFunction a;
        private long b = ChunkCoordIntPair.c;
        private double f;

        d(DensityFunction function) {
            this.a = function;
        }

        @Override
        public double a(DensityFunction.b context) {
            double d2;
            int i1;
            int i2 = context.a();
            long packedChunkPos = ChunkCoordIntPair.d(i2, i1 = context.c());
            if (this.b == packedChunkPos) {
                return this.f;
            }
            this.b = packedChunkPos;
            this.f = d2 = this.a.a(context);
            return d2;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.a.a(array, contextProvider);
        }

        @Override
        public DensityFunction l() {
            return this.a;
        }

        @Override
        public DensityFunctions.m.a k() {
            return DensityFunctions.m.a.c;
        }
    }

    class f
    implements DensityFunctions.n,
    h {
        private final DensityFunction b;
        private long f;
        private long g;
        private double h;
        private double @Nullable [] i;

        f(DensityFunction function) {
            this.b = function;
        }

        @Override
        public double a(DensityFunction.b context) {
            double d2;
            if (context != NoiseChunk.this) {
                return this.b.a(context);
            }
            if (this.i != null && this.g == NoiseChunk.this.G) {
                return this.i[NoiseChunk.this.H];
            }
            if (this.f == NoiseChunk.this.F) {
                return this.h;
            }
            this.f = NoiseChunk.this.F;
            this.h = d2 = this.b.a(context);
            return d2;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            if (this.i != null && this.g == NoiseChunk.this.G) {
                System.arraycopy(this.i, 0, array, 0, array.length);
            } else {
                this.l().a(array, contextProvider);
                if (this.i != null && this.i.length == array.length) {
                    System.arraycopy(array, 0, this.i, 0, array.length);
                } else {
                    this.i = (double[])array.clone();
                }
                this.g = NoiseChunk.this.G;
            }
        }

        @Override
        public DensityFunction l() {
            return this.b;
        }

        @Override
        public DensityFunctions.m.a k() {
            return DensityFunctions.m.a.d;
        }
    }

    static interface h
    extends DensityFunction {
        public DensityFunction l();

        @Override
        default public double a() {
            return this.l().a();
        }

        @Override
        default public double b() {
            return this.l().b();
        }
    }
}

