/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.LevelHeightAccessor;

public final class NoiseSettings
extends Record {
    private final int g;
    private final int h;
    private final int i;
    private final int j;
    public static final Codec<NoiseSettings> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)-2032, (int)2031).fieldOf("min_y").forGetter(NoiseSettings::c), (App)Codec.intRange((int)0, (int)4064).fieldOf("height").forGetter(NoiseSettings::d), (App)Codec.intRange((int)1, (int)4).fieldOf("size_horizontal").forGetter(NoiseSettings::e), (App)Codec.intRange((int)1, (int)4).fieldOf("size_vertical").forGetter(NoiseSettings::f)).apply((Applicative)instance, NoiseSettings::new)).comapFlatMap(NoiseSettings::a, Function.identity());
    protected static final NoiseSettings b = NoiseSettings.a(-64, 384, 1, 2);
    protected static final NoiseSettings c = NoiseSettings.a(0, 128, 1, 2);
    protected static final NoiseSettings d = NoiseSettings.a(0, 128, 2, 1);
    protected static final NoiseSettings e = NoiseSettings.a(-64, 192, 1, 2);
    protected static final NoiseSettings f = NoiseSettings.a(0, 256, 2, 1);

    public NoiseSettings(int minY, int height, int noiseSizeHorizontal, int noiseSizeVertical) {
        this.g = minY;
        this.h = height;
        this.i = noiseSizeHorizontal;
        this.j = noiseSizeVertical;
    }

    private static DataResult<NoiseSettings> a(NoiseSettings settings) {
        if (settings.c() + settings.d() > 2032) {
            return DataResult.error(() -> "min_y + height cannot be higher than: 2032");
        }
        if (settings.d() % 16 != 0) {
            return DataResult.error(() -> "height has to be a multiple of 16");
        }
        return settings.c() % 16 != 0 ? DataResult.error(() -> "min_y has to be a multiple of 16") : DataResult.success((Object)settings);
    }

    public static NoiseSettings a(int minY, int height, int noiseSizeHorizontal, int noiseSizeVertical) {
        NoiseSettings noiseSettings = new NoiseSettings(minY, height, noiseSizeHorizontal, noiseSizeVertical);
        NoiseSettings.a(noiseSettings).error().ifPresent(error -> {
            throw new IllegalStateException(error.message());
        });
        return noiseSettings;
    }

    public int a() {
        return QuartPos.c(this.f());
    }

    public int b() {
        return QuartPos.c(this.e());
    }

    public NoiseSettings a(LevelHeightAccessor heightAccessor) {
        int max = Math.max(this.g, heightAccessor.K_());
        int i2 = Math.min(this.g + this.h, heightAccessor.aw() + 1) - max;
        return new NoiseSettings(max, i2, this.i, this.j);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this, o2);
    }

    public int c() {
        return this.g;
    }

    public int d() {
        return this.h;
    }

    public int e() {
        return this.i;
    }

    public int f() {
        return this.j;
    }
}

