/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.primitives.Doubles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import org.jspecify.annotations.Nullable;

public class BlendingData {
    private static final double e = 0.1;
    protected static final int a = 4;
    protected static final int b = 8;
    protected static final int c = 2;
    private static final double f = 1.0;
    private static final double g = -1.0;
    private static final int h = 2;
    private static final int i = QuartPos.a(16);
    private static final int j = i - 1;
    private static final int k = i;
    private static final int l = 2 * j + 1;
    private static final int m = 2 * k + 1;
    static final int n = l + m;
    private final LevelHeightAccessor o;
    private static final List<Block> p = List.of(Blocks.l, Blocks.O, Blocks.i, Blocks.b, Blocks.k, Blocks.L, Blocks.N, Blocks.fU, Blocks.er, Blocks.js, Blocks.j);
    protected static final double d = Double.MAX_VALUE;
    private boolean q;
    private final double[] r;
    private final List<@Nullable List<@Nullable Holder<BiomeBase>>> s;
    private final transient double[][] t;

    private BlendingData(int sectionX, int sectionZ, Optional<double[]> heights) {
        this.r = heights.orElseGet(() -> SystemUtils.a(new double[n], (? super T doubles) -> Arrays.fill(doubles, Double.MAX_VALUE)));
        this.t = new double[n][];
        ObjectArrayList list = new ObjectArrayList(n);
        list.size(n);
        this.s = list;
        int blockPosX = SectionPosition.c(sectionX);
        int i2 = SectionPosition.c(sectionZ) - blockPosX;
        this.o = LevelHeightAccessor.e(blockPosX, i2);
    }

    public static @Nullable BlendingData a(@Nullable d packed) {
        return packed == null ? null : new BlendingData(packed.a(), packed.b(), packed.c());
    }

    public d a() {
        boolean flag = false;
        for (double d2 : this.r) {
            if (d2 == Double.MAX_VALUE) continue;
            flag = true;
            break;
        }
        return new d(this.o.ay(), this.o.az() + 1, flag ? Optional.of(DoubleArrays.copy((double[])this.r)) : Optional.empty());
    }

    public static @Nullable BlendingData a(RegionLimitedWorldAccess region, int chunkX, int chunkZ) {
        IChunkAccess chunk = region.a(chunkX, chunkZ);
        BlendingData blendingData = chunk.v();
        if (blendingData != null && !chunk.o().d(ChunkStatus.f)) {
            blendingData.a(chunk, BlendingData.a(region, chunkX, chunkZ, false));
            return blendingData;
        }
        return null;
    }

    public static Set<EnumDirection8> a(GeneratorAccessSeed level, int chunkX, int chunkZ, boolean oldNoiseGeneration) {
        EnumSet<EnumDirection8> set = EnumSet.noneOf(EnumDirection8.class);
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            int i1;
            int i2 = chunkX + direction8.b();
            if (level.a(i2, i1 = chunkZ + direction8.c()).u() != oldNoiseGeneration) continue;
            set.add(direction8);
        }
        return set;
    }

    private void a(IChunkAccess chunk, Set<EnumDirection8> directions) {
        if (!this.q) {
            int i2;
            if (directions.contains((Object)EnumDirection8.a) || directions.contains((Object)EnumDirection8.g) || directions.contains((Object)EnumDirection8.h)) {
                this.a(BlendingData.a(0, 0), chunk, 0, 0);
            }
            if (directions.contains((Object)EnumDirection8.a)) {
                for (i2 = 1; i2 < i; ++i2) {
                    this.a(BlendingData.a(i2, 0), chunk, 4 * i2, 0);
                }
            }
            if (directions.contains((Object)EnumDirection8.g)) {
                for (i2 = 1; i2 < i; ++i2) {
                    this.a(BlendingData.a(0, i2), chunk, 0, 4 * i2);
                }
            }
            if (directions.contains((Object)EnumDirection8.c)) {
                for (i2 = 1; i2 < i; ++i2) {
                    this.a(BlendingData.b(k, i2), chunk, 15, 4 * i2);
                }
            }
            if (directions.contains((Object)EnumDirection8.e)) {
                for (i2 = 0; i2 < i; ++i2) {
                    this.a(BlendingData.b(i2, k), chunk, 4 * i2, 15);
                }
            }
            if (directions.contains((Object)EnumDirection8.c) && directions.contains((Object)EnumDirection8.b)) {
                this.a(BlendingData.b(k, 0), chunk, 15, 0);
            }
            if (directions.contains((Object)EnumDirection8.c) && directions.contains((Object)EnumDirection8.e) && directions.contains((Object)EnumDirection8.d)) {
                this.a(BlendingData.b(k, k), chunk, 15, 15);
            }
            this.q = true;
        }
    }

    private void a(int index, IChunkAccess chunk, int x2, int z2) {
        if (this.r[index] == Double.MAX_VALUE) {
            this.r[index] = this.a(chunk, x2, z2);
        }
        this.t[index] = this.a(chunk, x2, z2, MathHelper.c(this.r[index]));
        this.s.set(index, this.b(chunk, x2, z2));
    }

    private int a(IChunkAccess chunk, int x2, int z2) {
        int min = chunk.b(HeightMap.Type.a) ? Math.min(chunk.a(HeightMap.Type.a, x2, z2), this.o.aw()) : this.o.aw();
        int minY = this.o.K_();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, min, z2);
        while (mutableBlockPos.v() > minY) {
            if (p.contains(chunk.a_(mutableBlockPos).b())) {
                return mutableBlockPos.v();
            }
            mutableBlockPos.c(EnumDirection.a);
        }
        return minY;
    }

    private static double a(IChunkAccess chunk, BlockPosition.MutableBlockPosition pos) {
        return BlendingData.a(chunk, (BlockPosition)pos.c(EnumDirection.a)) ? 1.0 : -1.0;
    }

    private static double b(IChunkAccess chunk, BlockPosition.MutableBlockPosition pos) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < 7; ++i2) {
            d2 += BlendingData.a(chunk, pos);
        }
        return d2;
    }

    private double[] a(IChunkAccess chunk, int x2, int z2, int height) {
        double d2;
        double d1;
        int i2;
        double[] doubles = new double[this.c()];
        Arrays.fill(doubles, -1.0);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, this.o.aw() + 1, z2);
        double d3 = BlendingData.b(chunk, mutableBlockPos);
        for (i2 = doubles.length - 2; i2 >= 0; --i2) {
            d1 = BlendingData.a(chunk, mutableBlockPos);
            d2 = BlendingData.b(chunk, mutableBlockPos);
            doubles[i2] = (d3 + d1 + d2) / 15.0;
            d3 = d2;
        }
        i2 = this.a(MathHelper.b(height, 8));
        if (i2 >= 0 && i2 < doubles.length - 1) {
            d1 = ((double)height + 0.5) % 8.0 / 8.0;
            d2 = (1.0 - d1) / d1;
            double d32 = Math.max(d2, 1.0) * 0.25;
            doubles[i2 + 1] = -d2 / d32;
            doubles[i2] = 1.0 / d32;
        }
        return doubles;
    }

    private List<Holder<BiomeBase>> b(IChunkAccess chunk, int x2, int z2) {
        ObjectArrayList list = new ObjectArrayList(this.d());
        list.size(this.d());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int i1 = i2 + QuartPos.a(this.o.K_());
            list.set(i2, chunk.getNoiseBiome(QuartPos.a(x2), i1, QuartPos.a(z2)));
        }
        return list;
    }

    private static boolean a(IChunkAccess chunk, BlockPosition pos) {
        IBlockData blockState = chunk.a_(pos);
        return !blockState.l() && !blockState.a(TagsBlock.M) && !blockState.a(TagsBlock.E) && !blockState.a(Blocks.fz) && !blockState.a(Blocks.fA) && !blockState.g(chunk, pos).c();
    }

    protected double a(int x2, int y2, int z2) {
        if (x2 == k || z2 == k) {
            return this.r[BlendingData.b(x2, z2)];
        }
        return x2 != 0 && z2 != 0 ? Double.MAX_VALUE : this.r[BlendingData.a(x2, z2)];
    }

    private double a(double @Nullable [] heights, int y2) {
        if (heights == null) {
            return Double.MAX_VALUE;
        }
        int cellYIndex = this.a(y2);
        return cellYIndex >= 0 && cellYIndex < heights.length ? heights[cellYIndex] * 0.1 : Double.MAX_VALUE;
    }

    protected double b(int x2, int y2, int z2) {
        if (y2 == this.f()) {
            return 0.1;
        }
        if (x2 == k || z2 == k) {
            return this.a(this.t[BlendingData.b(x2, z2)], y2);
        }
        return x2 != 0 && z2 != 0 ? Double.MAX_VALUE : this.a(this.t[BlendingData.a(x2, z2)], y2);
    }

    protected void a(int x2, int y2, int z2, a consumer) {
        if (y2 >= QuartPos.a(this.o.K_()) && y2 <= QuartPos.a(this.o.aw())) {
            int i2 = y2 - QuartPos.a(this.o.K_());
            for (int i1 = 0; i1 < this.s.size(); ++i1) {
                Holder<BiomeBase> holder;
                List<Holder<BiomeBase>> list = this.s.get(i1);
                if (list == null || (holder = list.get(i2)) == null) continue;
                consumer.consume(x2 + BlendingData.b(i1), z2 + BlendingData.c(i1), holder);
            }
        }
    }

    protected void a(int x2, int z2, c consumer) {
        for (int i2 = 0; i2 < this.r.length; ++i2) {
            double d2 = this.r[i2];
            if (d2 == Double.MAX_VALUE) continue;
            consumer.consume(x2 + BlendingData.b(i2), z2 + BlendingData.c(i2), d2);
        }
    }

    protected void a(int x2, int z2, int minY, int maxY, b consumer) {
        int columnMinY = this.e();
        int max = Math.max(0, minY - columnMinY);
        int min = Math.min(this.c(), maxY - columnMinY);
        for (int i2 = 0; i2 < this.t.length; ++i2) {
            double[] doubles = this.t[i2];
            if (doubles == null) continue;
            int i1 = x2 + BlendingData.b(i2);
            int i22 = z2 + BlendingData.c(i2);
            for (int i3 = max; i3 < min; ++i3) {
                consumer.consume(i1, i3 + columnMinY, i22, doubles[i3] * 0.1);
            }
        }
    }

    private int c() {
        return this.o.ax() * 2;
    }

    private int d() {
        return QuartPos.d(this.o.ax());
    }

    private int e() {
        return this.f() + 1;
    }

    private int f() {
        return this.o.ay() * 2;
    }

    private int a(int y2) {
        return y2 - this.e();
    }

    private static int a(int x2, int z2) {
        return j - x2 + z2;
    }

    private static int b(int x2, int z2) {
        return l + x2 + k - z2;
    }

    private static int b(int index) {
        if (index < l) {
            return BlendingData.d(j - index);
        }
        int i2 = index - l;
        return k - BlendingData.d(k - i2);
    }

    private static int c(int index) {
        if (index < l) {
            return BlendingData.d(index - j);
        }
        int i2 = index - l;
        return k - BlendingData.d(i2 - k);
    }

    private static int d(int value) {
        return value & ~(value >> 31);
    }

    public LevelHeightAccessor b() {
        return this.o;
    }

    public static final class d
    extends Record {
        private final int b;
        private final int c;
        private final Optional<double[]> d;
        private static final Codec<double[]> e = Codec.DOUBLE.listOf().xmap(Doubles::toArray, Doubles::asList);
        public static final Codec<d> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_section").forGetter(d::a), (App)Codec.INT.fieldOf("max_section").forGetter(d::b), (App)e.lenientOptionalFieldOf("heights").forGetter(d::c)).apply((Applicative)instance, d::new)).validate(d::a);

        public d(int minSection, int maxSection, Optional<double[]> heights) {
            this.b = minSection;
            this.c = maxSection;
            this.d = heights;
        }

        private static DataResult<d> a(d packed) {
            return packed.d.isPresent() && packed.d.get().length != n ? DataResult.error(() -> "heights has to be of length " + n) : DataResult.success((Object)packed);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "minSection;maxSection;heights", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "minSection;maxSection;heights", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "minSection;maxSection;heights", "b", "c", "d"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public Optional<double[]> c() {
            return this.d;
        }
    }

    protected static interface a {
        public void consume(int var1, int var2, Holder<BiomeBase> var3);
    }

    protected static interface c {
        public void consume(int var1, int var2, double var3);
    }

    protected static interface b {
        public void consume(int var1, int var2, int var3, double var4);
    }
}

