/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;

public class WorldGenCaves
extends WorldGenCarverAbstract<CaveCarverConfiguration> {
    public WorldGenCaves(Codec<CaveCarverConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(CaveCarverConfiguration config, RandomSource random) {
        return random.i() <= config.l;
    }

    @Override
    public boolean a(CarvingContext context, CaveCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> biomeAccessor, RandomSource random, Aquifer aquifer, ChunkCoordIntPair chunkPos, CarvingMask carvingMask) {
        int blockPosCoord = SectionPosition.c(this.d() * 2 - 1);
        int randomInt = random.a(random.a(random.a(this.a()) + 1) + 1);
        for (int i2 = 0; i2 < randomInt; ++i2) {
            float f2;
            double d2 = chunkPos.a(random.a(16));
            double d1 = config.e.a(random, context);
            double d22 = chunkPos.b(random.a(16));
            double d3 = config.b.a(random);
            double d4 = config.c.a(random);
            double d5 = config.j.a(random);
            WorldGenCarverAbstract.a carveSkipChecker = (skipContext, relativeX, relativeY, relativeZ, y2) -> WorldGenCaves.a(relativeX, relativeY, relativeZ, d5);
            int i1 = 1;
            if (random.a(4) == 0) {
                double d6 = config.f.a(random);
                f2 = 1.0f + random.i() * 6.0f;
                this.a(context, config, chunk, biomeAccessor, aquifer, d2, d1, d22, f2, d6, carvingMask, carveSkipChecker);
                i1 += random.a(4);
            }
            for (int i22 = 0; i22 < i1; ++i22) {
                float f1 = random.i() * ((float)Math.PI * 2);
                f2 = (random.i() - 0.5f) / 4.0f;
                float thickness = this.a(random);
                int i3 = blockPosCoord - random.a(blockPosCoord / 4);
                boolean i4 = false;
                this.a(context, config, chunk, biomeAccessor, random.g(), aquifer, d2, d1, d22, d3, d4, thickness, f1, f2, 0, i3, this.b(), carvingMask, carveSkipChecker);
            }
        }
        return true;
    }

    protected int a() {
        return 15;
    }

    protected float a(RandomSource random) {
        float f2 = random.i() * 2.0f + random.i();
        if (random.a(10) == 0) {
            f2 *= random.i() * random.i() * 3.0f + 1.0f;
        }
        return f2;
    }

    protected double b() {
        return 1.0;
    }

    protected void a(CarvingContext context, CaveCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> biomeAccessor, Aquifer aquifer, double x2, double y2, double z2, float radius, double horizontalVerticalRatio, CarvingMask carvingMask, WorldGenCarverAbstract.a skipChecker) {
        double d2 = 1.5 + (double)(MathHelper.a(1.5707963705062866) * radius);
        double d1 = d2 * horizontalVerticalRatio;
        this.a(context, config, chunk, biomeAccessor, aquifer, x2 + 1.0, y2, z2, d2, d1, carvingMask, skipChecker);
    }

    protected void a(CarvingContext context, CaveCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> biomeAccessor, long seed, Aquifer aquifer, double x2, double y2, double z2, double horizontalRadiusMultiplier, double verticalRadiusMultiplier, float thickness, float yaw, float pitch, int branchIndex, int branchCount, double horizontalVerticalRatio, CarvingMask carvingMask, WorldGenCarverAbstract.a skipChecker) {
        RandomSource randomSource = RandomSource.a(seed);
        int i2 = randomSource.a(branchCount / 2) + branchCount / 4;
        boolean flag = randomSource.a(6) == 0;
        float f2 = 0.0f;
        float f1 = 0.0f;
        for (int i1 = branchIndex; i1 < branchCount; ++i1) {
            double d2 = 1.5 + (double)(MathHelper.a((double)((float)Math.PI * (float)i1 / (float)branchCount)) * thickness);
            double d1 = d2 * horizontalVerticalRatio;
            float cos = MathHelper.b((double)pitch);
            x2 += (double)(MathHelper.b((double)yaw) * cos);
            y2 += (double)MathHelper.a((double)pitch);
            z2 += (double)(MathHelper.a((double)yaw) * cos);
            pitch *= flag ? 0.92f : 0.7f;
            pitch += f1 * 0.1f;
            yaw += f2 * 0.1f;
            f1 *= 0.9f;
            f2 *= 0.75f;
            f1 += (randomSource.i() - randomSource.i()) * randomSource.i() * 2.0f;
            f2 += (randomSource.i() - randomSource.i()) * randomSource.i() * 4.0f;
            if (i1 == i2 && thickness > 1.0f) {
                this.a(context, config, chunk, biomeAccessor, randomSource.g(), aquifer, x2, y2, z2, horizontalRadiusMultiplier, verticalRadiusMultiplier, randomSource.i() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, i1, branchCount, 1.0, carvingMask, skipChecker);
                this.a(context, config, chunk, biomeAccessor, randomSource.g(), aquifer, x2, y2, z2, horizontalRadiusMultiplier, verticalRadiusMultiplier, randomSource.i() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, i1, branchCount, 1.0, carvingMask, skipChecker);
                return;
            }
            if (randomSource.a(4) == 0) continue;
            if (!WorldGenCaves.a(chunk.f(), x2, z2, i1, branchCount, thickness)) {
                return;
            }
            this.a(context, config, chunk, biomeAccessor, aquifer, x2, y2, z2, d2 * horizontalRadiusMultiplier, d1 * verticalRadiusMultiplier, carvingMask, skipChecker);
        }
    }

    private static boolean a(double relative, double relativeY, double relativeZ, double minrelativeY) {
        return relativeY <= minrelativeY || relative * relative + relativeY * relativeY + relativeZ * relativeZ >= 1.0;
    }
}

