/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class UnderwaterMagmaFeature
extends WorldGenerator<UnderwaterMagmaConfiguration> {
    public UnderwaterMagmaFeature(Codec<UnderwaterMagmaConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<UnderwaterMagmaConfiguration> context) {
        BaseBlockPosition vec3i;
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        UnderwaterMagmaConfiguration underwaterMagmaConfiguration = context.f();
        RandomSource randomSource = context.d();
        OptionalInt floorY = UnderwaterMagmaFeature.a(worldGenLevel, blockPos, underwaterMagmaConfiguration);
        if (floorY.isEmpty()) {
            return false;
        }
        BlockPosition blockPos1 = blockPos.h(floorY.getAsInt());
        StructureBoundingBox boundingBox = StructureBoundingBox.a((BaseBlockPosition)blockPos1.b(vec3i = new BaseBlockPosition(underwaterMagmaConfiguration.c, underwaterMagmaConfiguration.c, underwaterMagmaConfiguration.c)), (BaseBlockPosition)blockPos1.a(vec3i));
        return BlockPosition.a(boundingBox).filter(blockPos2 -> randomSource.i() < underwaterMagmaConfiguration.d).filter(blockPos2 -> this.b(worldGenLevel, (BlockPosition)blockPos2)).mapToInt(blockPos2 -> {
            worldGenLevel.a((BlockPosition)blockPos2, Blocks.lF.m(), 2);
            return 1;
        }).sum() > 0;
    }

    private static OptionalInt a(GeneratorAccessSeed level, BlockPosition pos, UnderwaterMagmaConfiguration config) {
        Predicate<IBlockData> predicate = blockState -> blockState.a(Blocks.J);
        Predicate<IBlockData> predicate1 = blockState -> !blockState.a(Blocks.J);
        Optional<Column> optional = Column.a(level, pos, config.b, predicate, predicate1);
        return optional.map(Column::c).orElseGet(OptionalInt::empty);
    }

    private boolean b(GeneratorAccessSeed level, BlockPosition pos) {
        if (!UnderwaterMagmaFeature.c(level.a_(pos)) && !this.a(level, pos.e(), EnumDirection.b)) {
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                if (!this.a(level, pos.a(direction), direction.g())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean c(IBlockData state) {
        return state.a(Blocks.J) || state.l();
    }

    private boolean a(GeneratorAccess level, BlockPosition pos, EnumDirection face) {
        IBlockData blockState = level.a_(pos);
        VoxelShape faceOcclusionShape = blockState.a(face);
        return faceOcclusionShape == VoxelShapes.a() || !Block.a(faceOcclusionShape);
    }
}

