/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class VegetationPatchFeature
extends WorldGenerator<VegetationPatchConfiguration> {
    public VegetationPatchFeature(Codec<VegetationPatchConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<VegetationPatchConfiguration> context) {
        GeneratorAccessSeed worldGenLevel = context.b();
        VegetationPatchConfiguration vegetationPatchConfiguration = context.f();
        RandomSource randomSource = context.d();
        BlockPosition blockPos = context.e();
        Predicate<IBlockData> predicate = blockState -> blockState.a(vegetationPatchConfiguration.b);
        int i2 = vegetationPatchConfiguration.j.a(randomSource) + 1;
        int i1 = vegetationPatchConfiguration.j.a(randomSource) + 1;
        Set<BlockPosition> set = this.a(worldGenLevel, vegetationPatchConfiguration, randomSource, blockPos, predicate, i2, i1);
        this.a(context, worldGenLevel, vegetationPatchConfiguration, randomSource, set, i2, i1);
        return !set.isEmpty();
    }

    protected Set<BlockPosition> a(GeneratorAccessSeed level, VegetationPatchConfiguration config, RandomSource random, BlockPosition pos, Predicate<IBlockData> state, int xRadius, int zRadius) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        BlockPosition.MutableBlockPosition mutableBlockPos1 = mutableBlockPos.k();
        EnumDirection direction = config.e.a();
        EnumDirection opposite = direction.g();
        HashSet<BlockPosition> set = new HashSet<BlockPosition>();
        for (int i2 = -xRadius; i2 <= xRadius; ++i2) {
            boolean flag = i2 == -xRadius || i2 == xRadius;
            for (int i1 = -zRadius; i1 <= zRadius; ++i1) {
                boolean flag4;
                boolean flag1 = i1 == -zRadius || i1 == zRadius;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (flag3 || flag4 && (config.k == 0.0f || random.i() > config.k)) continue;
                mutableBlockPos.a(pos, i2, 0, i1);
                for (int i22 = 0; level.a((BlockPosition)mutableBlockPos, BlockBase.BlockData::l) && i22 < config.h; ++i22) {
                    mutableBlockPos.c(direction);
                }
                for (int var25 = 0; level.a((BlockPosition)mutableBlockPos, (IBlockData blockState1) -> !blockState1.l()) && var25 < config.h; ++var25) {
                    mutableBlockPos.c(opposite);
                }
                mutableBlockPos1.a((BaseBlockPosition)mutableBlockPos, config.e.a());
                IBlockData blockState = level.a_(mutableBlockPos1);
                if (!level.A(mutableBlockPos) || !blockState.c((IBlockAccess)level, (BlockPosition)mutableBlockPos1, config.e.a().g())) continue;
                int i3 = config.f.a(random) + (config.g > 0.0f && random.i() < config.g ? 1 : 0);
                BlockPosition blockPos = mutableBlockPos1.j();
                boolean flag5 = this.a(level, config, state, random, mutableBlockPos1, i3);
                if (!flag5) continue;
                set.add(blockPos);
            }
        }
        return set;
    }

    protected void a(FeaturePlaceContext<VegetationPatchConfiguration> context, GeneratorAccessSeed level, VegetationPatchConfiguration config, RandomSource random, Set<BlockPosition> possiblePositions, int xRadius, int zRadius) {
        for (BlockPosition blockPos : possiblePositions) {
            if (!(config.i > 0.0f) || !(random.i() < config.i)) continue;
            this.a(level, config, context.c(), random, blockPos);
        }
    }

    protected boolean a(GeneratorAccessSeed level, VegetationPatchConfiguration config, ChunkGenerator chunkGenerator, RandomSource random, BlockPosition pos) {
        return config.d.a().a(level, chunkGenerator, random, pos.a(config.e.a().g()));
    }

    protected boolean a(GeneratorAccessSeed level, VegetationPatchConfiguration config, Predicate<IBlockData> replaceableBlocks, RandomSource random, BlockPosition.MutableBlockPosition mutablePos, int maxDistance) {
        for (int i2 = 0; i2 < maxDistance; ++i2) {
            IBlockData blockState;
            IBlockData state = config.c.a(random, mutablePos);
            if (state.a((blockState = level.a_(mutablePos)).b())) continue;
            if (!replaceableBlocks.test(blockState)) {
                return i2 != 0;
            }
            level.a((BlockPosition)mutablePos, state, 2);
            mutablePos.c(config.e.a());
        }
        return true;
    }
}

