/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOreConfiguration;

public class WorldGenMinable
extends WorldGenerator<WorldGenFeatureOreConfiguration> {
    public WorldGenMinable(Codec<WorldGenFeatureOreConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureOreConfiguration> context) {
        RandomSource randomSource = context.d();
        BlockPosition blockPos = context.e();
        GeneratorAccessSeed worldGenLevel = context.b();
        WorldGenFeatureOreConfiguration oreConfiguration = context.f();
        float f2 = randomSource.i() * (float)Math.PI;
        float f1 = (float)oreConfiguration.c / 8.0f;
        int ceil = MathHelper.d(((float)oreConfiguration.c / 16.0f * 2.0f + 1.0f) / 2.0f);
        double d2 = (double)blockPos.u() + Math.sin(f2) * (double)f1;
        double d1 = (double)blockPos.u() - Math.sin(f2) * (double)f1;
        double d22 = (double)blockPos.w() + Math.cos(f2) * (double)f1;
        double d3 = (double)blockPos.w() - Math.cos(f2) * (double)f1;
        int i2 = 2;
        double d4 = blockPos.v() + randomSource.a(3) - 2;
        double d5 = blockPos.v() + randomSource.a(3) - 2;
        int i1 = blockPos.u() - MathHelper.d(f1) - ceil;
        int i22 = blockPos.v() - 2 - ceil;
        int i3 = blockPos.w() - MathHelper.d(f1) - ceil;
        int i4 = 2 * (MathHelper.d(f1) + ceil);
        int i5 = 2 * (2 + ceil);
        for (int i6 = i1; i6 <= i1 + i4; ++i6) {
            for (int i7 = i3; i7 <= i3 + i4; ++i7) {
                if (i22 > worldGenLevel.a(HeightMap.Type.c, i6, i7)) continue;
                return this.a(worldGenLevel, randomSource, oreConfiguration, d2, d1, d22, d3, d4, d5, i1, i22, i3, i4, i5);
            }
        }
        return false;
    }

    protected boolean a(GeneratorAccessSeed level, RandomSource random, WorldGenFeatureOreConfiguration config, double minX, double maxX, double minZ, double maxZ, double minY, double maxY, int x2, int y2, int z2, int width, int height) {
        double d3;
        double d2;
        double d1;
        double d4;
        int i2;
        int i3 = 0;
        BitSet bitSet = new BitSet(width * height * width);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        int i1 = config.c;
        double[] doubles = new double[i1 * 4];
        for (i2 = 0; i2 < i1; ++i2) {
            float f2 = (float)i2 / (float)i1;
            d4 = MathHelper.d((double)f2, minX, maxX);
            d1 = MathHelper.d((double)f2, minY, maxY);
            d2 = MathHelper.d((double)f2, minZ, maxZ);
            d3 = random.j() * (double)i1 / 16.0;
            double d42 = ((double)(MathHelper.a((double)((float)Math.PI * f2)) + 1.0f) * d3 + 1.0) / 2.0;
            doubles[i2 * 4 + 0] = d4;
            doubles[i2 * 4 + 1] = d1;
            doubles[i2 * 4 + 2] = d2;
            doubles[i2 * 4 + 3] = d42;
        }
        for (i2 = 0; i2 < i1 - 1; ++i2) {
            if (doubles[i2 * 4 + 3] <= 0.0) continue;
            for (int i32 = i2 + 1; i32 < i1; ++i32) {
                if (doubles[i32 * 4 + 3] <= 0.0 || !((d3 = doubles[i2 * 4 + 3] - doubles[i32 * 4 + 3]) * d3 > (d4 = doubles[i2 * 4 + 0] - doubles[i32 * 4 + 0]) * d4 + (d1 = doubles[i2 * 4 + 1] - doubles[i32 * 4 + 1]) * d1 + (d2 = doubles[i2 * 4 + 2] - doubles[i32 * 4 + 2]) * d2)) continue;
                if (d3 > 0.0) {
                    doubles[i32 * 4 + 3] = -1.0;
                    continue;
                }
                doubles[i2 * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess(level);){
            for (int i3x = 0; i3x < i1; ++i3x) {
                d4 = doubles[i3x * 4 + 3];
                if (d4 < 0.0) continue;
                d1 = doubles[i3x * 4 + 0];
                d2 = doubles[i3x * 4 + 1];
                d3 = doubles[i3x * 4 + 2];
                int max = Math.max(MathHelper.c(d1 - d4), x2);
                int max1 = Math.max(MathHelper.c(d2 - d4), y2);
                int max2 = Math.max(MathHelper.c(d3 - d4), z2);
                int max3 = Math.max(MathHelper.c(d1 + d4), max);
                int max4 = Math.max(MathHelper.c(d2 + d4), max1);
                int max5 = Math.max(MathHelper.c(d3 + d4), max2);
                for (int i4 = max; i4 <= max3; ++i4) {
                    double d5 = ((double)i4 + 0.5 - d1) / d4;
                    if (!(d5 * d5 < 1.0)) continue;
                    for (int i5 = max1; i5 <= max4; ++i5) {
                        double d6 = ((double)i5 + 0.5 - d2) / d4;
                        if (!(d5 * d5 + d6 * d6 < 1.0)) continue;
                        block11: for (int i6 = max2; i6 <= max5; ++i6) {
                            ChunkSection section;
                            int i7;
                            double d7 = ((double)i6 + 0.5 - d3) / d4;
                            if (!(d5 * d5 + d6 * d6 + d7 * d7 < 1.0) || level.e(i5) || bitSet.get(i7 = i4 - x2 + (i5 - y2) * width + (i6 - z2) * width * height)) continue;
                            bitSet.set(i7);
                            mutableBlockPos.d(i4, i5, i6);
                            if (!level.e_(mutableBlockPos) || (section = bulkSectionAccess.a(mutableBlockPos)) == null) continue;
                            int relativeBlockPosCoord = SectionPosition.b(i4);
                            int relativeBlockPosCoord1 = SectionPosition.b(i5);
                            int relativeBlockPosCoord2 = SectionPosition.b(i6);
                            IBlockData blockState = section.a(relativeBlockPosCoord, relativeBlockPosCoord1, relativeBlockPosCoord2);
                            for (WorldGenFeatureOreConfiguration.a targetBlockState : config.b) {
                                if (!WorldGenMinable.a(blockState, bulkSectionAccess::b, random, config, targetBlockState, mutableBlockPos)) continue;
                                section.a(relativeBlockPosCoord, relativeBlockPosCoord1, relativeBlockPosCoord2, targetBlockState.c, false);
                                ++i3;
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        return i3 > 0;
    }

    public static boolean a(IBlockData state, Function<BlockPosition, IBlockData> adjacentStateAccessor, RandomSource random, WorldGenFeatureOreConfiguration config, WorldGenFeatureOreConfiguration.a targetState, BlockPosition.MutableBlockPosition mutablePos) {
        return targetState.b.a(state, random) && (WorldGenMinable.a(random, config.d) || !WorldGenMinable.a(adjacentStateAccessor, (BlockPosition)mutablePos));
    }

    protected static boolean a(RandomSource random, float chance) {
        return chance <= 0.0f || !(chance >= 1.0f) && random.i() >= chance;
    }
}

