/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;

public class MultifaceGrowthConfiguration
implements WorldGenFeatureConfiguration {
    public static final Codec<MultifaceGrowthConfiguration> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("block").flatXmap(MultifaceGrowthConfiguration::a, DataResult::success).orElse((Object)((MultifaceSpreadeableBlock)Blocks.fO)).forGetter(config -> config.b), (App)Codec.intRange((int)1, (int)64).fieldOf("search_range").orElse((Object)10).forGetter(config -> config.c), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(config -> config.d), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(config -> config.e), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(config -> config.f), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spreading").orElse((Object)Float.valueOf(0.5f)).forGetter(config -> Float.valueOf(config.g)), (App)RegistryCodecs.a(Registries.i).fieldOf("can_be_placed_on").forGetter(config -> config.h)).apply((Applicative)instance, MultifaceGrowthConfiguration::new));
    public final MultifaceSpreadeableBlock b;
    public final int c;
    public final boolean d;
    public final boolean e;
    public final boolean f;
    public final float g;
    public final HolderSet<Block> h;
    private final ObjectArrayList<EnumDirection> i;

    private static DataResult<MultifaceSpreadeableBlock> a(Block block) {
        DataResult dataResult;
        if (block instanceof MultifaceSpreadeableBlock) {
            MultifaceSpreadeableBlock multifaceSpreadeableBlock = (MultifaceSpreadeableBlock)block;
            dataResult = DataResult.success((Object)multifaceSpreadeableBlock);
        } else {
            dataResult = DataResult.error(() -> "Growth block should be a multiface spreadeable block");
        }
        return dataResult;
    }

    public MultifaceGrowthConfiguration(MultifaceSpreadeableBlock placeBlock, int searchRange, boolean canPlaceOnFloor, boolean canPlaceOnCeiling, boolean canPlaceOnWall, float chanceOfSpreading, HolderSet<Block> canBePlacedOn) {
        this.b = placeBlock;
        this.c = searchRange;
        this.d = canPlaceOnFloor;
        this.e = canPlaceOnCeiling;
        this.f = canPlaceOnWall;
        this.g = chanceOfSpreading;
        this.h = canBePlacedOn;
        this.i = new ObjectArrayList(6);
        if (canPlaceOnCeiling) {
            this.i.add((Object)EnumDirection.b);
        }
        if (canPlaceOnFloor) {
            this.i.add((Object)EnumDirection.a);
        }
        if (canPlaceOnWall) {
            EnumDirection.EnumDirectionLimit.a.forEach(arg_0 -> this.i.add(arg_0));
        }
    }

    public List<EnumDirection> a(RandomSource random, EnumDirection direction) {
        return SystemUtils.a(this.i.stream().filter(direction1 -> direction1 != direction), random);
    }

    public List<EnumDirection> a(RandomSource random) {
        return SystemUtils.a(this.i, random);
    }
}

