/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;

public class CherryFoliagePlacer
extends WorldGenFoilagePlacer {
    public static final MapCodec<CherryFoliagePlacer> a = RecordCodecBuilder.mapCodec(instance -> CherryFoliagePlacer.b(instance).and(instance.group((App)IntProvider.b(4, 16).fieldOf("height").forGetter(cherryFoliagePlacer -> cherryFoliagePlacer.b), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("wide_bottom_layer_hole_chance").forGetter(cherryFoliagePlacer -> Float.valueOf(cherryFoliagePlacer.c)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("corner_hole_chance").forGetter(cherryFoliagePlacer -> Float.valueOf(cherryFoliagePlacer.c)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_chance").forGetter(cherryFoliagePlacer -> Float.valueOf(cherryFoliagePlacer.h)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_extension_chance").forGetter(cherryFoliagePlacer -> Float.valueOf(cherryFoliagePlacer.i)))).apply((Applicative)instance, CherryFoliagePlacer::new));
    private final IntProvider b;
    private final float c;
    private final float g;
    private final float h;
    private final float i;

    public CherryFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider height, float wideBottomLayerHoleChance, float cornerHoleChance, float hangingLeavesChance, float hangingLeavesExtensionChance) {
        super(radius, offset);
        this.b = height;
        this.c = wideBottomLayerHoleChance;
        this.g = cornerHoleChance;
        this.h = hangingLeavesChance;
        this.i = hangingLeavesExtensionChance;
    }

    @Override
    protected WorldGenFoilagePlacers<?> a() {
        return WorldGenFoilagePlacers.k;
    }

    @Override
    protected void a(VirtualLevelReadable level, WorldGenFoilagePlacer.b blockSetter, RandomSource random, WorldGenFeatureTreeConfiguration config, int maxFreeTreeHeight, WorldGenFoilagePlacer.a attachment, int foliageHeight, int foliageRadius, int offset) {
        boolean doubleTrunk = attachment.c();
        BlockPosition blockPos = attachment.a().b(offset);
        int i2 = foliageRadius + attachment.b() - 1;
        this.a(level, blockSetter, random, config, blockPos, i2 - 2, foliageHeight - 3, doubleTrunk);
        this.a(level, blockSetter, random, config, blockPos, i2 - 1, foliageHeight - 4, doubleTrunk);
        for (int i1 = foliageHeight - 5; i1 >= 0; --i1) {
            this.a(level, blockSetter, random, config, blockPos, i2, i1, doubleTrunk);
        }
        this.a(level, blockSetter, random, config, blockPos, i2, -1, doubleTrunk, this.h, this.i);
        this.a(level, blockSetter, random, config, blockPos, i2 - 1, -2, doubleTrunk, this.h, this.i);
    }

    @Override
    public int a(RandomSource random, int height, WorldGenFeatureTreeConfiguration config) {
        return this.b.a(random);
    }

    @Override
    protected boolean a(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        boolean flag1;
        if (localY == -1 && (localX == range || localZ == range) && random.i() < this.c) {
            return true;
        }
        boolean flag = localX == range && localZ == range;
        boolean bl = flag1 = range > 2;
        return flag1 ? flag || localX + localZ > range * 2 - 2 && random.i() < this.g : flag && random.i() < this.g;
    }
}

