/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import org.jspecify.annotations.Nullable;

public class RandomizedIntStateProvider
extends WorldGenFeatureStateProvider {
    public static final MapCodec<RandomizedIntStateProvider> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldGenFeatureStateProvider.a.fieldOf("source").forGetter(provider -> provider.c), (App)Codec.STRING.fieldOf("property").forGetter(provider -> provider.d), (App)IntProvider.c.fieldOf("values").forGetter(provider -> provider.f)).apply((Applicative)instance, RandomizedIntStateProvider::new));
    private final WorldGenFeatureStateProvider c;
    private final String d;
    private @Nullable BlockStateInteger e;
    private final IntProvider f;

    public RandomizedIntStateProvider(WorldGenFeatureStateProvider source, BlockStateInteger property, IntProvider values) {
        this.c = source;
        this.e = property;
        this.d = property.f();
        this.f = values;
        List<Integer> possibleValues = property.a();
        for (int value = values.a(); value <= values.b(); ++value) {
            if (possibleValues.contains(value)) continue;
            throw new IllegalArgumentException("Property value out of range: " + property.f() + ": " + value);
        }
    }

    public RandomizedIntStateProvider(WorldGenFeatureStateProvider source, String propertyName, IntProvider values) {
        this.c = source;
        this.d = propertyName;
        this.f = values;
    }

    @Override
    protected WorldGenFeatureStateProviders<?> a() {
        return WorldGenFeatureStateProviders.g;
    }

    @Override
    public IBlockData a(RandomSource random, BlockPosition pos) {
        IBlockData state = this.c.a(random, pos);
        if (this.e == null || !state.b(this.e)) {
            BlockStateInteger integerProperty = RandomizedIntStateProvider.a(state, this.d);
            if (integerProperty == null) {
                return state;
            }
            this.e = integerProperty;
        }
        return (IBlockData)state.b(this.e, this.f.a(random));
    }

    private static @Nullable BlockStateInteger a(IBlockData state, String propertyName) {
        Collection<IBlockState<?>> properties = state.F();
        Optional<BlockStateInteger> optional = properties.stream().filter(property -> property.f().equals(propertyName)).filter(property -> property instanceof BlockStateInteger).map(property -> (BlockStateInteger)property).findAny();
        return optional.orElse(null);
    }
}

