/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public class TrunkPlacerFancy
extends TrunkPlacer {
    public static final MapCodec<TrunkPlacerFancy> a = RecordCodecBuilder.mapCodec(instance -> TrunkPlacerFancy.a(instance).apply((Applicative)instance, TrunkPlacerFancy::new));
    private static final double b = 0.618;
    private static final double h = 1.382;
    private static final double i = 0.381;
    private static final double j = 0.328;

    public TrunkPlacerFancy(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @Override
    protected TrunkPlacers<?> a() {
        return TrunkPlacers.f;
    }

    @Override
    public List<WorldGenFoilagePlacer.a> a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, int freeTreeHeight, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        int i3;
        int i2 = 5;
        int i1 = freeTreeHeight + 2;
        int floor = MathHelper.c((double)i1 * 0.618);
        TrunkPlacerFancy.a(level, blockSetter, random, pos.e(), config);
        double d2 = 1.0;
        int min = Math.min(1, MathHelper.c(1.382 + Math.pow(1.0 * (double)i1 / 13.0, 2.0)));
        int i22 = pos.v() + floor;
        ArrayList list = Lists.newArrayList();
        list.add(new a(pos.b(i3), i22));
        for (i3 = i1 - 5; i3 >= 0; --i3) {
            float f2 = TrunkPlacerFancy.b(i1, i3);
            if (f2 < 0.0f) continue;
            for (int i4 = 0; i4 < min; ++i4) {
                BlockPosition blockPos1;
                double d1 = 1.0;
                double d22 = 1.0 * (double)f2 * ((double)random.i() + 0.328);
                double d3 = (double)(random.i() * 2.0f) * Math.PI;
                double d4 = d22 * Math.sin(d3) + 0.5;
                double d5 = d22 * Math.cos(d3) + 0.5;
                BlockPosition blockPos = pos.b(MathHelper.c(d4), i3 - 1, MathHelper.c(d5));
                if (!this.a(level, blockSetter, random, blockPos, blockPos1 = blockPos.b(5), false, config)) continue;
                int i5 = pos.u() - blockPos.u();
                int i6 = pos.w() - blockPos.w();
                double d6 = (double)blockPos.v() - Math.sqrt(i5 * i5 + i6 * i6) * 0.381;
                int i7 = d6 > (double)i22 ? i22 : (int)d6;
                BlockPosition blockPos2 = new BlockPosition(pos.u(), i7, pos.w());
                if (!this.a(level, blockSetter, random, blockPos2, blockPos, false, config)) continue;
                list.add(new a(blockPos, blockPos2.v()));
            }
        }
        this.a(level, blockSetter, random, pos, pos.b(floor), true, config);
        this.a(level, blockSetter, random, i1, pos, list, config);
        ArrayList list1 = Lists.newArrayList();
        for (a foliageCoords : list) {
            if (!this.a(i1, foliageCoords.a() - pos.v())) continue;
            list1.add(foliageCoords.a);
        }
        return list1;
    }

    private boolean a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, BlockPosition basePos, BlockPosition offsetPos, boolean modifyWorld, WorldGenFeatureTreeConfiguration config) {
        if (!modifyWorld && Objects.equals(basePos, offsetPos)) {
            return true;
        }
        BlockPosition blockPos = offsetPos.b(-basePos.u(), -basePos.v(), -basePos.w());
        int steps = this.a(blockPos);
        float f2 = (float)blockPos.u() / (float)steps;
        float f1 = (float)blockPos.v() / (float)steps;
        float f22 = (float)blockPos.w() / (float)steps;
        for (int i2 = 0; i2 <= steps; ++i2) {
            BlockPosition blockPos1 = basePos.b(MathHelper.b(0.5f + (float)i2 * f2), MathHelper.b(0.5f + (float)i2 * f1), MathHelper.b(0.5f + (float)i2 * f22));
            if (modifyWorld) {
                this.a(level, blockSetter, random, blockPos1, config, (IBlockData blockState) -> (IBlockData)blockState.c(BlockRotatable.d, this.a(basePos, blockPos1)));
                continue;
            }
            if (this.b(level, blockPos1)) continue;
            return false;
        }
        return true;
    }

    private int a(BlockPosition pos) {
        int abs = MathHelper.a(pos.u());
        int abs1 = MathHelper.a(pos.v());
        int abs2 = MathHelper.a(pos.w());
        return Math.max(abs, Math.max(abs1, abs2));
    }

    private EnumDirection.EnumAxis a(BlockPosition pos, BlockPosition otherPos) {
        int abs1;
        EnumDirection.EnumAxis axis = EnumDirection.EnumAxis.b;
        int abs = Math.abs(otherPos.u() - pos.u());
        int max = Math.max(abs, abs1 = Math.abs(otherPos.w() - pos.w()));
        if (max > 0) {
            axis = abs == max ? EnumDirection.EnumAxis.a : EnumDirection.EnumAxis.c;
        }
        return axis;
    }

    private boolean a(int maxHeight, int currentHeight) {
        return (double)currentHeight >= (double)maxHeight * 0.2;
    }

    private void a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, int maxHeight, BlockPosition pos, List<a> foliageCoords, WorldGenFeatureTreeConfiguration config) {
        for (a foliageCoords1 : foliageCoords) {
            int branchBase = foliageCoords1.a();
            BlockPosition blockPos = new BlockPosition(pos.u(), branchBase, pos.w());
            if (blockPos.equals(foliageCoords1.a.a()) || !this.a(maxHeight, branchBase - pos.v())) continue;
            this.a(level, blockSetter, random, blockPos, foliageCoords1.a.a(), true, config);
        }
    }

    private static float b(int height, int currentY) {
        if ((float)currentY < (float)height * 0.3f) {
            return -1.0f;
        }
        float f2 = (float)height / 2.0f;
        float f1 = f2 - (float)currentY;
        float squareRoot = MathHelper.a(f2 * f2 - f1 * f1);
        if (f1 == 0.0f) {
            squareRoot = f2;
        } else if (Math.abs(f1) >= f2) {
            return 0.0f;
        }
        return squareRoot * 0.5f;
    }

    static class a {
        final WorldGenFoilagePlacer.a a;
        private final int b;

        public a(BlockPosition attachmentPos, int branchBase) {
            this.a = new WorldGenFoilagePlacer.a(attachmentPos, 0, false);
            this.b = branchBase;
        }

        public int a() {
            return this.b;
        }
    }
}

