/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class EnvironmentScanPlacement
extends PlacementModifier {
    private final EnumDirection c;
    private final BlockPredicate d;
    private final BlockPredicate e;
    private final int f;
    public static final MapCodec<EnvironmentScanPlacement> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumDirection.h.fieldOf("direction_of_search").forGetter(placement -> placement.c), (App)BlockPredicate.b.fieldOf("target_condition").forGetter(placement -> placement.d), (App)BlockPredicate.b.optionalFieldOf("allowed_search_condition", (Object)BlockPredicate.e()).forGetter(placement -> placement.e), (App)Codec.intRange((int)1, (int)32).fieldOf("max_steps").forGetter(placement -> placement.f)).apply((Applicative)instance, EnvironmentScanPlacement::new));

    private EnvironmentScanPlacement(EnumDirection directionOfSearch, BlockPredicate targetCondition, BlockPredicate allowedSearchCondition, int maxSteps) {
        this.c = directionOfSearch;
        this.d = targetCondition;
        this.e = allowedSearchCondition;
        this.f = maxSteps;
    }

    public static EnvironmentScanPlacement a(EnumDirection directionOfSearch, BlockPredicate targetCondition, BlockPredicate allowedSearchCondition, int maxSteps) {
        return new EnvironmentScanPlacement(directionOfSearch, targetCondition, allowedSearchCondition, maxSteps);
    }

    public static EnvironmentScanPlacement a(EnumDirection directionOfSearch, BlockPredicate targetCondition, int maxSteps) {
        return EnvironmentScanPlacement.a(directionOfSearch, targetCondition, BlockPredicate.e(), maxSteps);
    }

    @Override
    public Stream<BlockPosition> a_(PlacementContext context, RandomSource random, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        GeneratorAccessSeed level = context.d();
        if (!this.e.test(level, mutableBlockPos)) {
            return Stream.of(new BlockPosition[0]);
        }
        for (int i2 = 0; i2 < this.f; ++i2) {
            if (this.d.test(level, mutableBlockPos)) {
                return Stream.of(mutableBlockPos);
            }
            mutableBlockPos.c(this.c);
            if (level.e(mutableBlockPos.v())) {
                return Stream.of(new BlockPosition[0]);
            }
            if (!this.e.test(level, mutableBlockPos)) break;
        }
        return this.d.test(level, mutableBlockPos) ? Stream.of(mutableBlockPos) : Stream.of(new BlockPosition[0]);
    }

    @Override
    public PlacementModifierType<?> b() {
        return PlacementModifierType.j;
    }
}

