/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeatureCountTracker;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.apache.commons.lang3.mutable.MutableBoolean;

public final class PlacedFeature
extends Record {
    private final Holder<WorldGenFeatureConfigured<?, ?>> e;
    private final List<PlacementModifier> f;
    public static final Codec<PlacedFeature> a = RecordCodecBuilder.create(instance -> instance.group((App)WorldGenFeatureConfigured.b.fieldOf("feature").forGetter(feature -> feature.e), (App)PlacementModifier.b.listOf().fieldOf("placement").forGetter(feature -> feature.f)).apply((Applicative)instance, PlacedFeature::new));
    public static final Codec<Holder<PlacedFeature>> b = RegistryFileCodec.a(Registries.bp, a);
    public static final Codec<HolderSet<PlacedFeature>> c = RegistryCodecs.a(Registries.bp, a);
    public static final Codec<List<HolderSet<PlacedFeature>>> d = RegistryCodecs.a(Registries.bp, a, true).listOf();

    public PlacedFeature(Holder<WorldGenFeatureConfigured<?, ?>> feature, List<PlacementModifier> placement) {
        this.e = feature;
        this.f = placement;
    }

    public boolean a(GeneratorAccessSeed level, ChunkGenerator generator, RandomSource random, BlockPosition pos) {
        return this.a(new PlacementContext(level, generator, Optional.empty()), random, pos);
    }

    public boolean b(GeneratorAccessSeed level, ChunkGenerator generator, RandomSource random, BlockPosition pos) {
        return this.a(new PlacementContext(level, generator, Optional.of(this)), random, pos);
    }

    private boolean a(PlacementContext context, RandomSource source, BlockPosition pos) {
        Stream<BlockPosition> stream = Stream.of(pos);
        for (PlacementModifier placementModifier : this.f) {
            stream = stream.flatMap(blockPos -> placementModifier.a_(context, source, (BlockPosition)blockPos));
        }
        WorldGenFeatureConfigured<?, ?> configuredFeature = this.e.a();
        MutableBoolean mutableBoolean = new MutableBoolean();
        stream.forEach(blockPos -> {
            if (configuredFeature.a(context.d(), context.f(), source, (BlockPosition)blockPos)) {
                mutableBoolean.setTrue();
                if (SharedConstants.aP) {
                    FeatureCountTracker.a(context.d().a(), configuredFeature, context.e());
                }
            }
        });
        return mutableBoolean.isTrue();
    }

    public Stream<WorldGenFeatureConfigured<?, ?>> a() {
        return this.e.a().a();
    }

    @Override
    public String toString() {
        return "Placed " + String.valueOf(this.e);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlacedFeature.class, "feature;placement", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlacedFeature.class, "feature;placement", "e", "f"}, this, o2);
    }

    public Holder<WorldGenFeatureConfigured<?, ?>> b() {
        return this.e;
    }

    public List<PlacementModifier> c() {
        return this.f;
    }
}

