/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public abstract class DefinedStructurePiece
extends StructurePiece {
    private static final Logger h = LogUtils.getLogger();
    protected final String a;
    protected DefinedStructure b;
    protected DefinedStructureInfo c;
    protected BlockPosition d;

    public DefinedStructurePiece(WorldGenFeatureStructurePieceType type, int genDepth, StructureTemplateManager structureTemplateManager, MinecraftKey location, String templateName, DefinedStructureInfo placeSettings, BlockPosition templatePosition) {
        super(type, genDepth, structureTemplateManager.a(location).b(placeSettings, templatePosition));
        this.a(EnumDirection.c);
        this.a = templateName;
        this.d = templatePosition;
        this.b = structureTemplateManager.a(location);
        this.c = placeSettings;
    }

    public DefinedStructurePiece(WorldGenFeatureStructurePieceType type, NBTTagCompound tag, StructureTemplateManager structureTemplateManager, Function<MinecraftKey, DefinedStructureInfo> placeSettingsFactory) {
        super(type, tag);
        this.a(EnumDirection.c);
        this.a = tag.b("Template", "");
        this.d = new BlockPosition(tag.b("TPX", 0), tag.b("TPY", 0), tag.b("TPZ", 0));
        MinecraftKey identifier = this.b();
        this.b = structureTemplateManager.a(identifier);
        this.c = placeSettingsFactory.apply(identifier);
        this.f = this.b.b(this.c, this.d);
    }

    protected MinecraftKey b() {
        return MinecraftKey.a(this.a);
    }

    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
        tag.a("TPX", this.d.u());
        tag.a("TPY", this.d.v());
        tag.a("TPZ", this.d.w());
        tag.a("Template", this.a);
    }

    @Override
    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
        this.c.a(box);
        this.f = this.b.b(this.c, this.d);
        if (this.b.a(level, this.d, pos, this.c, random, 2)) {
            for (DefinedStructure.BlockInfo structureBlockInfo : this.b.a(this.d, this.c, Blocks.pY)) {
                BlockPropertyStructureMode structureMode;
                if (structureBlockInfo.c() == null || (structureMode = structureBlockInfo.c().a("mode", BlockPropertyStructureMode.e).orElseThrow()) != BlockPropertyStructureMode.d) continue;
                this.a(structureBlockInfo.c().b("metadata", ""), structureBlockInfo.a(), level, random, box);
            }
            for (DefinedStructure.BlockInfo structureBlockInfo1 : this.b.a(this.d, this.c, Blocks.pZ)) {
                if (structureBlockInfo1.c() == null) continue;
                String stringOr = structureBlockInfo1.c().b("final_state", "minecraft:air");
                IBlockData blockState = Blocks.a.m();
                try {
                    blockState = ArgumentBlock.a(level.a(Registries.i), stringOr, true).a();
                }
                catch (CommandSyntaxException var15) {
                    h.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)stringOr, (Object)structureBlockInfo1.a());
                }
                level.a(structureBlockInfo1.a(), blockState, 3);
            }
        }
    }

    protected abstract void a(String var1, BlockPosition var2, WorldAccess var3, RandomSource var4, StructureBoundingBox var5);

    @Override
    @Deprecated
    public void a(int x2, int y2, int z2) {
        super.a(x2, y2, z2);
        this.d = this.d.b(x2, y2, z2);
    }

    @Override
    public EnumBlockRotation a() {
        return this.c.d();
    }

    public DefinedStructure c() {
        return this.b;
    }

    public BlockPosition d() {
        return this.d;
    }

    public DefinedStructureInfo e() {
        return this.c;
    }
}

