/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.jspecify.annotations.Nullable;

public class PersistentStructureLegacy
implements LegacyTagFixer {
    public static final int b = 1493;
    private static final Map<String, String> c = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put("Village", "Village");
        map.put("Mineshaft", "Mineshaft");
        map.put("Mansion", "Mansion");
        map.put("Igloo", "Temple");
        map.put("Desert_Pyramid", "Temple");
        map.put("Jungle_Pyramid", "Temple");
        map.put("Swamp_Hut", "Temple");
        map.put("Stronghold", "Stronghold");
        map.put("Monument", "Monument");
        map.put("Fortress", "Fortress");
        map.put("EndCity", "EndCity");
    });
    private static final Map<String, String> d = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put("Iglu", "Igloo");
        map.put("TeDP", "Desert_Pyramid");
        map.put("TeJP", "Jungle_Pyramid");
        map.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> e = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean f;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> g = Maps.newHashMap();
    private final Map<String, PersistentIndexed> h = Maps.newHashMap();
    private final @Nullable WorldPersistentData i;
    private final List<String> j;
    private final List<String> k;
    private final DataFixer l;
    private boolean m;

    public PersistentStructureLegacy(@Nullable WorldPersistentData dimensionDataStorage, List<String> legacyKeys, List<String> currentKeys, DataFixer dataFixer) {
        this.i = dimensionDataStorage;
        this.j = legacyKeys;
        this.k = currentKeys;
        this.l = dataFixer;
        boolean flag = false;
        for (String string : this.k) {
            flag |= this.g.get(string) != null;
        }
        this.f = flag;
    }

    @Override
    public void markChunkDone(ChunkCoordIntPair chunkPos) {
        long packedChunkPos = chunkPos.b();
        for (String string : this.j) {
            PersistentIndexed structureFeatureIndexSavedData = this.h.get(string);
            if (structureFeatureIndexSavedData == null || !structureFeatureIndexSavedData.c(packedChunkPos)) continue;
            structureFeatureIndexSavedData.d(packedChunkPos);
        }
    }

    @Override
    public int targetDataVersion() {
        return 1493;
    }

    @Override
    public NBTTagCompound applyFix(NBTTagCompound tag) {
        int dataVersion;
        if (!this.m && this.i != null) {
            this.a(this.i);
        }
        if ((dataVersion = GameProfileSerializer.f(tag)) < 1493 && (tag = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, tag, dataVersion, 1493)).m("Level").flatMap(compoundTag -> compoundTag.q("hasLegacyStructureData")).orElse(false).booleanValue()) {
            tag = this.a(tag);
        }
        return tag;
    }

    private NBTTagCompound a(NBTTagCompound tag) {
        NBTTagCompound compoundOrEmpty = tag.n("Level");
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(compoundOrEmpty.b("xPos", 0), compoundOrEmpty.b("zPos", 0));
        if (this.a(chunkPos.h, chunkPos.i)) {
            tag = this.a(tag, chunkPos);
        }
        NBTTagCompound compoundOrEmpty1 = compoundOrEmpty.n("Structures");
        NBTTagCompound compoundOrEmpty2 = compoundOrEmpty1.n("References");
        for (String string : this.k) {
            boolean flag = e.contains(string.toLowerCase(Locale.ROOT));
            if (compoundOrEmpty2.l(string).isPresent() || !flag) continue;
            int i2 = 8;
            LongArrayList list = new LongArrayList();
            for (int i1 = chunkPos.h - 8; i1 <= chunkPos.h + 8; ++i1) {
                for (int i22 = chunkPos.i - 8; i22 <= chunkPos.i + 8; ++i22) {
                    if (!this.a(i1, i22, string)) continue;
                    list.add(ChunkCoordIntPair.d(i1, i22));
                }
            }
            compoundOrEmpty2.a(string, list.toLongArray());
        }
        compoundOrEmpty1.a("References", compoundOrEmpty2);
        compoundOrEmpty.a("Structures", compoundOrEmpty1);
        tag.a("Level", compoundOrEmpty);
        return tag;
    }

    private boolean a(int chunkX, int chunkZ, String key) {
        return this.f && this.g.get(key) != null && this.h.get(c.get(key)).b(ChunkCoordIntPair.d(chunkX, chunkZ));
    }

    private boolean a(int chunkX, int chunkZ) {
        if (!this.f) {
            return false;
        }
        for (String string : this.k) {
            if (this.g.get(string) == null || !this.h.get(c.get(string)).c(ChunkCoordIntPair.d(chunkX, chunkZ))) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound a(NBTTagCompound tag, ChunkCoordIntPair chunkPos) {
        NBTTagCompound compoundOrEmpty = tag.n("Level");
        NBTTagCompound compoundOrEmpty1 = compoundOrEmpty.n("Structures");
        NBTTagCompound compoundOrEmpty2 = compoundOrEmpty1.n("Starts");
        for (String string : this.k) {
            NBTTagCompound compoundTag;
            Long2ObjectMap<NBTTagCompound> map = this.g.get(string);
            if (map == null) continue;
            long packedChunkPos = chunkPos.b();
            if (!this.h.get(c.get(string)).c(packedChunkPos) || (compoundTag = (NBTTagCompound)map.get(packedChunkPos)) == null) continue;
            compoundOrEmpty2.a(string, compoundTag);
        }
        compoundOrEmpty1.a("Starts", compoundOrEmpty2);
        compoundOrEmpty.a("Structures", compoundOrEmpty1);
        tag.a("Level", compoundOrEmpty);
        return tag;
    }

    private synchronized void a(WorldPersistentData storage) {
        if (!this.m) {
            for (String string : this.j) {
                NBTTagCompound compoundTag = new NBTTagCompound();
                try {
                    compoundTag = storage.a(string, DataFixTypes.q, 1493).n("data").n("Features");
                    if (compoundTag.j()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                compoundTag.a((String string2, NBTBase tag) -> {
                    if (tag instanceof NBTTagCompound) {
                        NBTTagCompound compoundTag1 = (NBTTagCompound)tag;
                        long packedChunkPos = ChunkCoordIntPair.d(compoundTag1.b("ChunkX", 0), compoundTag1.b("ChunkZ", 0));
                        NBTTagList listOrEmpty = compoundTag1.p("Children");
                        if (!listOrEmpty.isEmpty()) {
                            Optional<String> optional = listOrEmpty.a(0).flatMap(compoundTag2 -> compoundTag2.i("id"));
                            optional.map(d::get).ifPresent(string3 -> compoundTag1.a("id", (String)string3));
                        }
                        compoundTag1.i("id").ifPresent(string3 -> this.g.computeIfAbsent((String)string3, string4 -> new Long2ObjectOpenHashMap()).put(packedChunkPos, (Object)compoundTag1));
                    }
                });
                String string1 = string + "_index";
                PersistentIndexed structureFeatureIndexSavedData = storage.a(PersistentIndexed.a(string1));
                if (structureFeatureIndexSavedData.b().isEmpty()) {
                    PersistentIndexed structureFeatureIndexSavedData1 = new PersistentIndexed();
                    this.h.put(string, structureFeatureIndexSavedData1);
                    compoundTag.a((String string2, NBTBase tag) -> {
                        if (tag instanceof NBTTagCompound) {
                            NBTTagCompound compoundTag1 = (NBTTagCompound)tag;
                            structureFeatureIndexSavedData1.a(ChunkCoordIntPair.d(compoundTag1.b("ChunkX", 0), compoundTag1.b("ChunkZ", 0)));
                        }
                    });
                    continue;
                }
                this.h.put(string, structureFeatureIndexSavedData);
            }
            this.m = true;
        }
    }

    public static Supplier<LegacyTagFixer> a(ResourceKey<World> level, Supplier<@Nullable WorldPersistentData> storage, DataFixer dataFixer) {
        ResourceKey<WorldDimension> stemKey = Registries.b(level);
        if (stemKey == WorldDimension.b) {
            return () -> new PersistentStructureLegacy((WorldPersistentData)storage.get(), (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"), dataFixer);
        }
        if (stemKey == WorldDimension.c) {
            ImmutableList list = ImmutableList.of((Object)"Fortress");
            return () -> PersistentStructureLegacy.b(storage, (List)list, dataFixer);
        }
        if (stemKey == WorldDimension.d) {
            ImmutableList list = ImmutableList.of((Object)"EndCity");
            return () -> PersistentStructureLegacy.a(storage, (List)list, dataFixer);
        }
        return LegacyTagFixer.a;
    }

    private static /* synthetic */ LegacyTagFixer a(Supplier storage, List list, DataFixer dataFixer) {
        return new PersistentStructureLegacy((WorldPersistentData)storage.get(), list, list, dataFixer);
    }

    private static /* synthetic */ LegacyTagFixer b(Supplier storage, List list, DataFixer dataFixer) {
        return new PersistentStructureLegacy((WorldPersistentData)storage.get(), list, list, dataFixer);
    }
}

