/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class Structure {
    public static final Codec<Structure> a = BuiltInRegistries.R.q().dispatch(Structure::e, StructureType::codec);
    public static final Codec<Holder<Structure>> b = RegistryFileCodec.a(Registries.bs, a);
    protected final c c;

    public static <S extends Structure> RecordCodecBuilder<S, c> a(RecordCodecBuilder.Instance<S> instance) {
        return net.minecraft.world.level.levelgen.structure.Structure$c.a.forGetter(structure -> structure.c);
    }

    public static <S extends Structure> MapCodec<S> a(Function<c, S> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(Structure.a(instance)).apply((Applicative)instance, factory));
    }

    protected Structure(c settings) {
        this.c = settings;
    }

    public HolderSet<BiomeBase> a() {
        return this.c.b;
    }

    public Map<EnumCreatureType, StructureSpawnOverride> b() {
        return this.c.c;
    }

    public WorldGenStage.Decoration c() {
        return this.c.d;
    }

    public TerrainAdjustment d() {
        return this.c.e;
    }

    public StructureBoundingBox a(StructureBoundingBox boundingBox) {
        return this.d() != TerrainAdjustment.a ? boundingBox.a(12) : boundingBox;
    }

    public StructureStart a(Holder<Structure> structure, ResourceKey<World> level, IRegistryCustom registryAccess, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long seed, ChunkCoordIntPair chunkPos, int references, LevelHeightAccessor heightAccessor, Predicate<Holder<BiomeBase>> validBiome) {
        StructurePiecesBuilder piecesBuilder;
        StructureStart structureStart;
        ProfiledDuration profiledDuration = JvmProfiler.f.a(chunkPos, level, structure);
        a generationContext = new a(registryAccess, chunkGenerator, biomeSource, randomState, structureTemplateManager, seed, chunkPos, heightAccessor, validBiome);
        Optional<b> optional = this.b(generationContext);
        if (optional.isPresent() && (structureStart = new StructureStart(this, chunkPos, references, (piecesBuilder = optional.get().a()).a())).b()) {
            if (profiledDuration != null) {
                profiledDuration.finish(true);
            }
            return structureStart;
        }
        if (profiledDuration != null) {
            profiledDuration.finish(false);
        }
        return StructureStart.b;
    }

    protected static Optional<b> a(a context, HeightMap.Type heightmapTypes, Consumer<StructurePiecesBuilder> generator) {
        ChunkCoordIntPair chunkPos = context.h();
        int middleBlockX = chunkPos.c();
        int middleBlockZ = chunkPos.d();
        int firstOccupiedHeight = context.b().c(middleBlockX, middleBlockZ, heightmapTypes, context.i(), context.d());
        return Optional.of(new b(new BlockPosition(middleBlockX, firstOccupiedHeight, middleBlockZ), generator));
    }

    private static boolean a(b stub, a context) {
        BlockPosition blockPos = stub.b();
        return context.j.test(context.b.d().getNoiseBiome(QuartPos.a(blockPos.u()), QuartPos.a(blockPos.v()), QuartPos.a(blockPos.w()), context.d.b()));
    }

    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox boundingBox, ChunkCoordIntPair chunkPos, PiecesContainer pieces) {
    }

    private static int[] c(a context, int minX, int maxX, int minZ, int maxZ) {
        ChunkGenerator chunkGenerator = context.b();
        LevelHeightAccessor levelHeightAccessor = context.i();
        RandomState randomState = context.d();
        return new int[]{chunkGenerator.c(minX, minZ, HeightMap.Type.a, levelHeightAccessor, randomState), chunkGenerator.c(minX, minZ + maxZ, HeightMap.Type.a, levelHeightAccessor, randomState), chunkGenerator.c(minX + maxX, minZ, HeightMap.Type.a, levelHeightAccessor, randomState), chunkGenerator.c(minX + maxX, minZ + maxZ, HeightMap.Type.a, levelHeightAccessor, randomState)};
    }

    public static int a(a context, int minX, int maxX, int minZ, int maxZ) {
        int[] cornerHeights = Structure.c(context, minX, maxX, minZ, maxZ);
        return (cornerHeights[0] + cornerHeights[1] + cornerHeights[2] + cornerHeights[3]) / 4;
    }

    protected static int a(a context, int maxX, int maxZ) {
        ChunkCoordIntPair chunkPos = context.h();
        int minBlockX = chunkPos.e();
        int minBlockZ = chunkPos.f();
        return Structure.b(context, minBlockX, minBlockZ, maxX, maxZ);
    }

    protected static int b(a context, int minX, int minZ, int maxX, int maxZ) {
        int[] cornerHeights = Structure.c(context, minX, maxX, minZ, maxZ);
        return Math.min(Math.min(cornerHeights[0], cornerHeights[1]), Math.min(cornerHeights[2], cornerHeights[3]));
    }

    @Deprecated
    protected BlockPosition a(a context, EnumBlockRotation rotation) {
        int i2 = 5;
        int i1 = 5;
        if (rotation == EnumBlockRotation.b) {
            i2 = -5;
        } else if (rotation == EnumBlockRotation.c) {
            i2 = -5;
            i1 = -5;
        } else if (rotation == EnumBlockRotation.d) {
            i1 = -5;
        }
        ChunkCoordIntPair chunkPos = context.h();
        int blockX = chunkPos.a(7);
        int blockZ = chunkPos.b(7);
        return new BlockPosition(blockX, Structure.b(context, blockX, blockZ, i2, i1), blockZ);
    }

    protected abstract Optional<b> a(a var1);

    public Optional<b> b(a context) {
        return this.a(context).filter(stub -> Structure.a(stub, context));
    }

    public abstract StructureType<?> e();

    public static final class c
    extends Record {
        private final HolderSet<BiomeBase> b;
        private final Map<EnumCreatureType, StructureSpawnOverride> c;
        private final WorldGenStage.Decoration d;
        private final TerrainAdjustment e;
        static final c f = new c(HolderSet.a(new Holder[0]), Map.of(), WorldGenStage.Decoration.e, TerrainAdjustment.a);
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.a(Registries.aS).fieldOf("biomes").forGetter(c::a), (App)Codec.simpleMap(EnumCreatureType.i, StructureSpawnOverride.a, (Keyable)INamable.b(EnumCreatureType.values())).fieldOf("spawn_overrides").forGetter(c::b), (App)WorldGenStage.Decoration.l.fieldOf("step").forGetter(c::c), (App)TerrainAdjustment.f.optionalFieldOf("terrain_adaptation", (Object)net.minecraft.world.level.levelgen.structure.Structure$c.f.e).forGetter(c::d)).apply((Applicative)instance, c::new));

        public c(HolderSet<BiomeBase> biomes) {
            this(biomes, net.minecraft.world.level.levelgen.structure.Structure$c.f.c, net.minecraft.world.level.levelgen.structure.Structure$c.f.d, net.minecraft.world.level.levelgen.structure.Structure$c.f.e);
        }

        public c(HolderSet<BiomeBase> biomes, Map<EnumCreatureType, StructureSpawnOverride> spawnOverrides, WorldGenStage.Decoration step, TerrainAdjustment terrainAdaptation) {
            this.b = biomes;
            this.c = spawnOverrides;
            this.d = step;
            this.e = terrainAdaptation;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "b", "c", "d", "e"}, this, o2);
        }

        public HolderSet<BiomeBase> a() {
            return this.b;
        }

        public Map<EnumCreatureType, StructureSpawnOverride> b() {
            return this.c;
        }

        public WorldGenStage.Decoration c() {
            return this.d;
        }

        public TerrainAdjustment d() {
            return this.e;
        }

        public static class a {
            private final HolderSet<BiomeBase> a;
            private Map<EnumCreatureType, StructureSpawnOverride> b;
            private WorldGenStage.Decoration c;
            private TerrainAdjustment d;

            public a(HolderSet<BiomeBase> biomes) {
                this.b = net.minecraft.world.level.levelgen.structure.Structure$c.f.c;
                this.c = net.minecraft.world.level.levelgen.structure.Structure$c.f.d;
                this.d = net.minecraft.world.level.levelgen.structure.Structure$c.f.e;
                this.a = biomes;
            }

            public a a(Map<EnumCreatureType, StructureSpawnOverride> spawnOverrides) {
                this.b = spawnOverrides;
                return this;
            }

            public a a(WorldGenStage.Decoration generationStep) {
                this.c = generationStep;
                return this;
            }

            public a a(TerrainAdjustment terrainAdaptation) {
                this.d = terrainAdaptation;
                return this;
            }

            public c a() {
                return new c(this.a, this.b, this.c, this.d);
            }
        }
    }

    public record a(IRegistryCustom a, ChunkGenerator b, WorldChunkManager c, RandomState d, StructureTemplateManager e, SeededRandom f, long g, ChunkCoordIntPair h, LevelHeightAccessor i, Predicate<Holder<BiomeBase>> j) {
        public a(IRegistryCustom registryAccess, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long seed, ChunkCoordIntPair chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<BiomeBase>> validBiome) {
            this(registryAccess, chunkGenerator, biomeSource, randomState, structureTemplateManager, net.minecraft.world.level.levelgen.structure.Structure$a.a(seed, chunkPos), seed, chunkPos, heightAccessor, validBiome);
        }

        private static SeededRandom a(long seed, ChunkCoordIntPair chunkPos) {
            SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
            worldgenRandom.c(seed, chunkPos.h, chunkPos.i);
            return worldgenRandom;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this, o2);
        }
    }

    public record b(BlockPosition a, Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> b) {
        private final BlockPosition a;
        private final Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> b;

        public b(BlockPosition position, Consumer<StructurePiecesBuilder> generator) {
            this(position, Either.left(generator));
        }

        public StructurePiecesBuilder a() {
            return this.b.map(consumer -> {
                StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
                consumer.accept(structurePiecesBuilder);
                return structurePiecesBuilder;
            }, builder -> builder);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "position;generator", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "position;generator", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "position;generator", "a", "b"}, this, o2);
        }

        public BlockPosition b() {
            return this.a;
        }

        public Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> c() {
            return this.b;
        }
    }
}

