/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class WorldGenFeatureDefinedStructureJigsawPlacement {
    static final Logger a = LogUtils.getLogger();
    private static final int b = Integer.MIN_VALUE;

    public static Optional<Structure.b> a(Structure.a context, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, Optional<MinecraftKey> startJigsawName, int maxDepth, BlockPosition pos, boolean useExpansionHack, Optional<HeightMap.Type> projectStartToHeightmap, JigsawStructure.a maxDistanceFromCenter, PoolAliasLookup aliasLookup, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        BlockPosition blockPos;
        IRegistryCustom registryAccess = context.a();
        ChunkGenerator chunkGenerator = context.b();
        StructureTemplateManager structureTemplateManager = context.e();
        LevelHeightAccessor levelHeightAccessor = context.i();
        SeededRandom worldgenRandom = context.f();
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> registry = registryAccess.f(Registries.bt);
        EnumBlockRotation random = EnumBlockRotation.a(worldgenRandom);
        WorldGenFeatureDefinedStructurePoolTemplate structureTemplatePool = startPool.e().flatMap(key -> registry.f(aliasLookup.lookup((ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>)key))).orElse(startPool.a());
        WorldGenFeatureDefinedStructurePoolStructure randomTemplate = structureTemplatePool.a(worldgenRandom);
        if (randomTemplate == WorldGenFeatureDefinedStructurePoolEmpty.b) {
            return Optional.empty();
        }
        if (startJigsawName.isPresent()) {
            MinecraftKey identifier = startJigsawName.get();
            Optional<BlockPosition> randomNamedJigsaw = WorldGenFeatureDefinedStructureJigsawPlacement.a(randomTemplate, identifier, pos, random, structureTemplateManager, worldgenRandom);
            if (randomNamedJigsaw.isEmpty()) {
                a.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)startPool.e().map(resourceKey -> resourceKey.a().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = randomNamedJigsaw.get();
        } else {
            blockPos = pos;
        }
        BlockPosition vec3i = blockPos.b(pos);
        BlockPosition blockPos1 = pos.b(vec3i);
        WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = new WorldGenFeaturePillagerOutpostPoolPiece(structureTemplateManager, randomTemplate, blockPos1, randomTemplate.h(), random, randomTemplate.a(structureTemplateManager, blockPos1, random), liquidSettings);
        StructureBoundingBox boundingBox = poolElementStructurePiece.f();
        int i2 = (boundingBox.k() + boundingBox.h()) / 2;
        int i1 = (boundingBox.m() + boundingBox.j()) / 2;
        int i22 = projectStartToHeightmap.isEmpty() ? blockPos1.v() : pos.v() + chunkGenerator.b(i2, i1, projectStartToHeightmap.get(), levelHeightAccessor, context.d());
        int i3 = boundingBox.i() + poolElementStructurePiece.d();
        poolElementStructurePiece.a(0, i22 - i3, 0);
        if (WorldGenFeatureDefinedStructureJigsawPlacement.a(levelHeightAccessor, dimensionPadding, poolElementStructurePiece.f())) {
            a.debug("Center piece {} with bounding box {} does not fit dimension padding {}", new Object[]{randomTemplate, poolElementStructurePiece.f(), dimensionPadding});
            return Optional.empty();
        }
        int i4 = i22 + vec3i.v();
        return Optional.of(new Structure.b(new BlockPosition(i2, i4, i1), builder -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolElementStructurePiece);
            if (maxDepth > 0) {
                AxisAlignedBB aabb = new AxisAlignedBB(i2 - maxDistanceFromCenter.a(), Math.max(i4 - maxDistanceFromCenter.b(), levelHeightAccessor.K_() + dimensionPadding.b()), i1 - maxDistanceFromCenter.a(), i2 + maxDistanceFromCenter.a() + 1, Math.min(i4 + maxDistanceFromCenter.b() + 1, levelHeightAccessor.aw() + 1 - dimensionPadding.c()), i1 + maxDistanceFromCenter.a() + 1);
                VoxelShape voxelShape = VoxelShapes.a(VoxelShapes.a(aabb), VoxelShapes.a(AxisAlignedBB.a(boundingBox)), OperatorBoolean.e);
                WorldGenFeatureDefinedStructureJigsawPlacement.a(context.d(), maxDepth, useExpansionHack, chunkGenerator, structureTemplateManager, levelHeightAccessor, worldgenRandom, registry, poolElementStructurePiece, list, voxelShape, aliasLookup, liquidSettings);
                list.forEach(builder::a);
            }
        }));
    }

    private static boolean a(LevelHeightAccessor level, DimensionPadding padding, StructureBoundingBox boundingBox) {
        if (padding == DimensionPadding.b) {
            return false;
        }
        int i2 = level.K_() + padding.b();
        int i1 = level.aw() - padding.c();
        return boundingBox.i() < i2 || boundingBox.l() > i1;
    }

    private static Optional<BlockPosition> a(WorldGenFeatureDefinedStructurePoolStructure element, MinecraftKey startJigsawName, BlockPosition pos, EnumBlockRotation rotation, StructureTemplateManager structureTemplateManager, SeededRandom random) {
        for (DefinedStructure.a jigsawBlockInfo : element.a(structureTemplateManager, pos, rotation, random)) {
            if (!startJigsawName.equals(jigsawBlockInfo.c())) continue;
            return Optional.of(jigsawBlockInfo.a().a());
        }
        return Optional.empty();
    }

    private static void a(RandomState randomState, int maxDepth, boolean useExpansionHack, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor level, RandomSource random, IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> pools, WorldGenFeaturePillagerOutpostPoolPiece startPiece, List<WorldGenFeaturePillagerOutpostPoolPiece> pieces, VoxelShape free, PoolAliasLookup aliasLookup, LiquidSettings liquidSettings) {
        b placer = new b(pools, maxDepth, chunkGenerator, structureTemplateManager, pieces, random);
        placer.a(startPiece, (MutableObject<VoxelShape>)new MutableObject((Object)free), 0, useExpansionHack, level, randomState, aliasLookup, liquidSettings);
        while (placer.g.hasNext()) {
            a pieceState = (a)placer.g.next();
            placer.a(pieceState.a, pieceState.b, pieceState.c, useExpansionHack, level, randomState, aliasLookup, liquidSettings);
        }
    }

    public static boolean a(WorldServer level, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, MinecraftKey startJigsawName, int maxDepth, BlockPosition pos, boolean keepJigsaws) {
        ChunkGenerator generator = level.p().g();
        StructureTemplateManager structureManager = level.u();
        StructureManager structureManager1 = level.b();
        RandomSource random = level.G_();
        Structure.a generationContext = new Structure.a(level.J_(), generator, generator.d(), level.p().i(), structureManager, level.J(), new ChunkCoordIntPair(pos), level, holder -> true);
        Optional<Structure.b> optional = WorldGenFeatureDefinedStructureJigsawPlacement.a(generationContext, startPool, Optional.of(startJigsawName), maxDepth, pos, false, Optional.empty(), new JigsawStructure.a(128), PoolAliasLookup.a, JigsawStructure.d, JigsawStructure.e);
        if (optional.isPresent()) {
            StructurePiecesBuilder piecesBuilder = optional.get().a();
            for (StructurePiece structurePiece : piecesBuilder.a().c()) {
                if (!(structurePiece instanceof WorldGenFeaturePillagerOutpostPoolPiece)) continue;
                WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = (WorldGenFeaturePillagerOutpostPoolPiece)structurePiece;
                poolElementStructurePiece.a((GeneratorAccessSeed)level, structureManager1, generator, random, StructureBoundingBox.a(), pos, keepJigsaws);
            }
            return true;
        }
        return false;
    }

    static final class b {
        private final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> a;
        private final int b;
        private final ChunkGenerator c;
        private final StructureTemplateManager d;
        private final List<? super WorldGenFeaturePillagerOutpostPoolPiece> e;
        private final RandomSource f;
        final SequencedPriorityIterator<a> g = new SequencedPriorityIterator();

        b(IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> pools, int maxDepth, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super WorldGenFeaturePillagerOutpostPoolPiece> pieces, RandomSource random) {
            this.a = pools;
            this.b = maxDepth;
            this.c = chunkGenerator;
            this.d = structureTemplateManager;
            this.e = pieces;
            this.f = random;
        }

        void a(WorldGenFeaturePillagerOutpostPoolPiece piece, MutableObject<VoxelShape> free, int depth, boolean useExpansionHack, LevelHeightAccessor level, RandomState random, PoolAliasLookup poolAliasLookup, LiquidSettings liquidSettings) {
            WorldGenFeatureDefinedStructurePoolStructure element = piece.b();
            BlockPosition position = piece.c();
            EnumBlockRotation rotation = piece.a();
            WorldGenFeatureDefinedStructurePoolTemplate.Matching projection = element.g();
            boolean flag = projection == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b;
            MutableObject<VoxelShape> mutableObject = new MutableObject<VoxelShape>();
            StructureBoundingBox boundingBox = piece.f();
            int minY = boundingBox.i();
            block0: for (DefinedStructure.a jigsawBlockInfo : element.a(this.d, position, rotation, this.f)) {
                WorldGenFeatureDefinedStructurePoolStructure structurePoolElement;
                MutableObject<VoxelShape> mutableObject1;
                DefinedStructure.BlockInfo structureBlockInfo = jigsawBlockInfo.a();
                EnumDirection frontFacing = BlockJigsaw.p(structureBlockInfo.b());
                BlockPosition blockPos = structureBlockInfo.a();
                BlockPosition blockPos1 = blockPos.a(frontFacing);
                int i2 = blockPos.v() - minY;
                int i1 = Integer.MIN_VALUE;
                ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> resourceKey = poolAliasLookup.lookup(jigsawBlockInfo.d());
                Optional optional = this.a.a(resourceKey);
                if (optional.isEmpty()) {
                    a.warn("Empty or non-existent pool: {}", (Object)resourceKey.a());
                    continue;
                }
                Holder holder = (Holder)optional.get();
                if (((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).c() == 0 && !holder.a(WorldGenFeaturePieces.a)) {
                    a.warn("Empty or non-existent pool: {}", (Object)resourceKey.a());
                    continue;
                }
                Holder<WorldGenFeatureDefinedStructurePoolTemplate> fallback = ((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).b();
                if (fallback.a().c() == 0 && !fallback.a(WorldGenFeaturePieces.a)) {
                    a.warn("Empty or non-existent fallback pool: {}", (Object)fallback.e().map(key -> key.a().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean isInside = boundingBox.b(blockPos1);
                if (isInside) {
                    mutableObject1 = mutableObject;
                    if (mutableObject.get() == null) {
                        mutableObject.setValue((Object)VoxelShapes.a(AxisAlignedBB.a(boundingBox)));
                    }
                } else {
                    mutableObject1 = free;
                }
                ArrayList list = Lists.newArrayList();
                if (depth != this.b) {
                    list.addAll(((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).b(this.f));
                }
                list.addAll(fallback.a().b(this.f));
                int placementPriority = jigsawBlockInfo.f();
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurePoolElement = (WorldGenFeatureDefinedStructurePoolStructure)iterator.next()) != WorldGenFeatureDefinedStructurePoolEmpty.b) {
                    for (EnumBlockRotation rotation1 : EnumBlockRotation.b(this.f)) {
                        List<DefinedStructure.a> shuffledJigsawBlocks = structurePoolElement.a(this.d, BlockPosition.c, rotation1, this.f);
                        StructureBoundingBox boundingBox1 = structurePoolElement.a(this.d, BlockPosition.c, rotation1);
                        int i22 = useExpansionHack && boundingBox1.e() <= 16 ? shuffledJigsawBlocks.stream().mapToInt(info -> {
                            DefinedStructure.BlockInfo structureBlockInfo1 = info.a();
                            if (!boundingBox1.b(structureBlockInfo1.a().a(BlockJigsaw.p(structureBlockInfo1.b())))) {
                                return 0;
                            }
                            ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> resourceKey1 = poolAliasLookup.lookup(info.d());
                            Optional optional1 = this.a.a(resourceKey1);
                            Optional<Holder> optional2 = optional1.map(holder1 -> ((WorldGenFeatureDefinedStructurePoolTemplate)holder1.a()).b());
                            int i8 = optional1.map(holder1 -> ((WorldGenFeatureDefinedStructurePoolTemplate)holder1.a()).a(this.d)).orElse(0);
                            int i9 = optional2.map(holder1 -> ((WorldGenFeatureDefinedStructurePoolTemplate)holder1.a()).a(this.d)).orElse(0);
                            return Math.max(i8, i9);
                        }).max().orElse(0) : 0;
                        for (DefinedStructure.a jigsawBlockInfo1 : shuffledJigsawBlocks) {
                            int i7;
                            int max;
                            int i4;
                            if (!BlockJigsaw.a(jigsawBlockInfo, jigsawBlockInfo1)) continue;
                            BlockPosition blockPos2 = jigsawBlockInfo1.a().a();
                            BlockPosition blockPos3 = blockPos1.b(blockPos2);
                            StructureBoundingBox boundingBox2 = structurePoolElement.a(this.d, blockPos3, rotation1);
                            int minY1 = boundingBox2.i();
                            WorldGenFeatureDefinedStructurePoolTemplate.Matching projection1 = structurePoolElement.g();
                            boolean flag1 = projection1 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b;
                            int y2 = blockPos2.v();
                            int i3 = i2 - y2 + BlockJigsaw.p(structureBlockInfo.b()).k();
                            if (flag && flag1) {
                                i4 = minY + i3;
                            } else {
                                if (i1 == Integer.MIN_VALUE) {
                                    i1 = this.c.b(blockPos.u(), blockPos.w(), HeightMap.Type.a, level, random);
                                }
                                i4 = i1 - y2;
                            }
                            int i5 = i4 - minY1;
                            StructureBoundingBox boundingBox3 = boundingBox2.b(0, i5, 0);
                            BlockPosition blockPos4 = blockPos3.b(0, i5, 0);
                            if (i22 > 0) {
                                max = Math.max(i22 + 1, boundingBox3.l() - boundingBox3.i());
                                boundingBox3.a(new BlockPosition(boundingBox3.h(), boundingBox3.i() + max, boundingBox3.j()));
                            }
                            if (VoxelShapes.c((VoxelShape)mutableObject1.get(), VoxelShapes.a(AxisAlignedBB.a(boundingBox3).h(0.25)), OperatorBoolean.c)) continue;
                            mutableObject1.setValue((Object)VoxelShapes.b((VoxelShape)mutableObject1.get(), VoxelShapes.a(AxisAlignedBB.a(boundingBox3)), OperatorBoolean.e));
                            max = piece.d();
                            int i6 = flag1 ? max - i3 : structurePoolElement.h();
                            WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = new WorldGenFeaturePillagerOutpostPoolPiece(this.d, structurePoolElement, blockPos4, i6, rotation1, boundingBox3, liquidSettings);
                            if (flag) {
                                i7 = minY + i2;
                            } else if (flag1) {
                                i7 = i4 + y2;
                            } else {
                                if (i1 == Integer.MIN_VALUE) {
                                    i1 = this.c.b(blockPos.u(), blockPos.w(), HeightMap.Type.a, level, random);
                                }
                                i7 = i1 + i3 / 2;
                            }
                            piece.a(new WorldGenFeatureDefinedStructureJigsawJunction(blockPos1.u(), i7 - i2 + max, blockPos1.w(), i3, projection1));
                            poolElementStructurePiece.a(new WorldGenFeatureDefinedStructureJigsawJunction(blockPos.u(), i7 - y2 + i6, blockPos.w(), -i3, projection));
                            this.e.add(poolElementStructurePiece);
                            if (depth + 1 > this.b) continue block0;
                            a pieceState = new a(poolElementStructurePiece, mutableObject1, depth + 1);
                            this.g.a(pieceState, placementPriority);
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    record a(WorldGenFeaturePillagerOutpostPoolPiece a, MutableObject<VoxelShape> b, int c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "piece;free;depth", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "piece;free;depth", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "piece;free;depth", "a", "b", "c"}, this, o2);
        }
    }
}

