/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorGravity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;

public class WorldGenFeatureDefinedStructurePoolTemplate {
    private static final int c = Integer.MIN_VALUE;
    private static final MutableObject<Codec<Holder<WorldGenFeatureDefinedStructurePoolTemplate>>> d = new MutableObject();
    public static final Codec<WorldGenFeatureDefinedStructurePoolTemplate> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.lazyInitialized(d).fieldOf("fallback").forGetter(WorldGenFeatureDefinedStructurePoolTemplate::b), (App)Codec.mapPair((MapCodec)WorldGenFeatureDefinedStructurePoolStructure.f.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.e)).apply((Applicative)instance, WorldGenFeatureDefinedStructurePoolTemplate::new));
    public static final Codec<Holder<WorldGenFeatureDefinedStructurePoolTemplate>> b = SystemUtils.a(RegistryFileCodec.a(Registries.bt, a), arg_0 -> d.setValue(arg_0));
    private final List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> e;
    private final ObjectArrayList<WorldGenFeatureDefinedStructurePoolStructure> f;
    private final Holder<WorldGenFeatureDefinedStructurePoolTemplate> g;
    private int h = Integer.MIN_VALUE;

    public WorldGenFeatureDefinedStructurePoolTemplate(Holder<WorldGenFeatureDefinedStructurePoolTemplate> fallback, List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> rawTemplates) {
        this.e = rawTemplates;
        this.f = new ObjectArrayList();
        for (Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer> pair : rawTemplates) {
            WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = (WorldGenFeatureDefinedStructurePoolStructure)pair.getFirst();
            for (int i2 = 0; i2 < (Integer)pair.getSecond(); ++i2) {
                this.f.add((Object)structurePoolElement);
            }
        }
        this.g = fallback;
    }

    public WorldGenFeatureDefinedStructurePoolTemplate(Holder<WorldGenFeatureDefinedStructurePoolTemplate> fallback, List<Pair<Function<Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer>> rawTemplateFactories, Matching projection) {
        this.e = Lists.newArrayList();
        this.f = new ObjectArrayList();
        for (Pair<Function<Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer> pair : rawTemplateFactories) {
            WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = (WorldGenFeatureDefinedStructurePoolStructure)((Function)pair.getFirst()).apply(projection);
            this.e.add((Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>)Pair.of((Object)structurePoolElement, (Object)((Integer)pair.getSecond())));
            for (int i2 = 0; i2 < (Integer)pair.getSecond(); ++i2) {
                this.f.add((Object)structurePoolElement);
            }
        }
        this.g = fallback;
    }

    public int a(StructureTemplateManager structureTemplateManager) {
        if (this.h == Integer.MIN_VALUE) {
            this.h = this.f.stream().filter(template -> template != WorldGenFeatureDefinedStructurePoolEmpty.b).mapToInt(template -> template.a(structureTemplateManager, BlockPosition.c, EnumBlockRotation.a).e()).max().orElse(0);
        }
        return this.h;
    }

    @VisibleForTesting
    public List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> a() {
        return this.e;
    }

    public Holder<WorldGenFeatureDefinedStructurePoolTemplate> b() {
        return this.g;
    }

    public WorldGenFeatureDefinedStructurePoolStructure a(RandomSource random) {
        return this.f.isEmpty() ? WorldGenFeatureDefinedStructurePoolEmpty.b : (WorldGenFeatureDefinedStructurePoolStructure)this.f.get(random.a(this.f.size()));
    }

    public List<WorldGenFeatureDefinedStructurePoolStructure> b(RandomSource random) {
        return SystemUtils.a(this.f, random);
    }

    public int c() {
        return this.f.size();
    }

    public static final class Matching
    extends Enum<Matching>
    implements INamable {
        public static final /* enum */ Matching a = new Matching("terrain_matching", (ImmutableList<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorGravity(HeightMap.Type.a, -1)));
        public static final /* enum */ Matching b = new Matching("rigid", (ImmutableList<DefinedStructureProcessor>)ImmutableList.of());
        public static final INamable.a<Matching> c;
        private final String d;
        private final ImmutableList<DefinedStructureProcessor> e;
        private static final /* synthetic */ Matching[] f;

        public static Matching[] values() {
            return (Matching[])f.clone();
        }

        public static Matching valueOf(String name) {
            return Enum.valueOf(Matching.class, name);
        }

        private Matching(String name, ImmutableList<DefinedStructureProcessor> processors) {
            this.d = name;
            this.e = processors;
        }

        public String a() {
            return this.d;
        }

        public static Matching a(String name) {
            return c.a(name);
        }

        public ImmutableList<DefinedStructureProcessor> b() {
            return this.e;
        }

        @Override
        public String c() {
            return this.d;
        }

        private static /* synthetic */ Matching[] d() {
            return new Matching[]{a, b};
        }

        static {
            f = Matching.d();
            c = INamable.a(Matching::values);
        }
    }
}

