/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentPieces;

public class OceanMonumentStructure
extends Structure {
    public static final MapCodec<OceanMonumentStructure> d = OceanMonumentStructure.a(OceanMonumentStructure::new);

    public OceanMonumentStructure(Structure.c settings) {
        super(settings);
    }

    @Override
    public Optional<Structure.b> a(Structure.a context) {
        int blockX = context.h().a(9);
        int blockZ = context.h().b(9);
        for (Holder<BiomeBase> holder : context.c().a(blockX, context.b().f(), blockZ, 29, context.d().b())) {
            if (holder.a(BiomeTags.X)) continue;
            return Optional.empty();
        }
        return OceanMonumentStructure.a(context, HeightMap.Type.c, (StructurePiecesBuilder structurePiecesBuilder) -> OceanMonumentStructure.a(structurePiecesBuilder, context));
    }

    private static StructurePiece a(ChunkCoordIntPair chunkPos, SeededRandom random) {
        int i2 = chunkPos.e() - 29;
        int i1 = chunkPos.f() - 29;
        EnumDirection randomDirection = EnumDirection.EnumDirectionLimit.a.a(random);
        return new OceanMonumentPieces.h(random, i2, i1, randomDirection);
    }

    private static void a(StructurePiecesBuilder builder, Structure.a context) {
        builder.a(OceanMonumentStructure.a(context.h(), context.f()));
    }

    public static PiecesContainer a(ChunkCoordIntPair chunkPos, long seed, PiecesContainer piecesContainer) {
        if (piecesContainer.a()) {
            return piecesContainer;
        }
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
        worldgenRandom.c(seed, chunkPos.h, chunkPos.i);
        StructurePiece structurePiece = piecesContainer.c().get(0);
        StructureBoundingBox boundingBox = structurePiece.f();
        int minX = boundingBox.h();
        int minZ = boundingBox.j();
        EnumDirection randomDirection = EnumDirection.EnumDirectionLimit.a.a(worldgenRandom);
        EnumDirection direction = Objects.requireNonNullElse(structurePiece.i(), randomDirection);
        OceanMonumentPieces.h structurePiece1 = new OceanMonumentPieces.h(worldgenRandom, minX, minZ, direction);
        StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
        structurePiecesBuilder.a(structurePiece1);
        return structurePiecesBuilder.a();
    }

    @Override
    public StructureType<?> e() {
        return StructureType.j;
    }
}

