/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;

public class RuinedPortalStructure
extends Structure {
    private static final String[] e = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] f = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float g = 0.05f;
    private static final int h = 15;
    private final List<a> i;
    public static final MapCodec<RuinedPortalStructure> d = RecordCodecBuilder.mapCodec(instance -> instance.group(RuinedPortalStructure.a(instance), (App)ExtraCodecs.b(net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure$a.a.listOf()).fieldOf("setups").forGetter(structure -> structure.i)).apply((Applicative)instance, RuinedPortalStructure::new));

    public RuinedPortalStructure(Structure.c settings, List<a> setups) {
        super(settings);
        this.i = setups;
    }

    public RuinedPortalStructure(Structure.c settings, a setup) {
        this(settings, List.of(setup));
    }

    @Override
    public Optional<Structure.b> a(Structure.a context) {
        RuinedPortalPiece.a properties = new RuinedPortalPiece.a();
        SeededRandom worldgenRandom = context.f();
        a setup = null;
        if (this.i.size() > 1) {
            float f2 = 0.0f;
            for (a a2 : this.i) {
                f2 += a2.h();
            }
            float randomFloat = worldgenRandom.i();
            for (a setup2 : this.i) {
                if (!((randomFloat -= setup2.h() / f2) < 0.0f)) continue;
                setup = setup2;
                break;
            }
        } else {
            setup = this.i.get(0);
        }
        if (setup == null) {
            throw new IllegalStateException();
        }
        a setup3 = setup;
        properties.d = RuinedPortalStructure.a(worldgenRandom, setup3.b());
        properties.c = setup3.c();
        properties.e = setup3.d();
        properties.f = setup3.e();
        properties.g = setup3.g();
        MinecraftKey identifier = worldgenRandom.i() < 0.05f ? MinecraftKey.b(f[worldgenRandom.a(f.length)]) : MinecraftKey.b(e[worldgenRandom.a(e.length)]);
        DefinedStructure definedStructure = context.e().a(identifier);
        EnumBlockRotation rotation = SystemUtils.a(EnumBlockRotation.values(), (RandomSource)worldgenRandom);
        EnumBlockMirror mirror = worldgenRandom.i() < 0.5f ? EnumBlockMirror.a : EnumBlockMirror.c;
        BlockPosition blockPos = new BlockPosition(definedStructure.a().u() / 2, 0, definedStructure.a().w() / 2);
        ChunkGenerator chunkGenerator = context.b();
        LevelHeightAccessor levelHeightAccessor = context.i();
        RandomState randomState = context.d();
        BlockPosition worldPosition = context.h().m();
        StructureBoundingBox boundingBox = definedStructure.a(worldPosition, rotation, blockPos, mirror);
        BlockPosition center = boundingBox.g();
        int i2 = chunkGenerator.a(center.u(), center.w(), RuinedPortalPiece.a(setup3.a()), levelHeightAccessor, randomState) - 1;
        int i1 = RuinedPortalStructure.a(worldgenRandom, chunkGenerator, setup3.a(), properties.d, i2, boundingBox.e(), boundingBox, levelHeightAccessor, randomState);
        BlockPosition blockPos1 = new BlockPosition(worldPosition.u(), i1, worldPosition.w());
        return Optional.of(new Structure.b(blockPos1, structurePiecesBuilder -> {
            if (setup3.f()) {
                properties.b = RuinedPortalStructure.a(blockPos1, context.b().d().getNoiseBiome(QuartPos.a(blockPos1.u()), QuartPos.a(blockPos1.v()), QuartPos.a(blockPos1.w()), randomState.b()), chunkGenerator.f());
            }
            structurePiecesBuilder.a(new RuinedPortalPiece(context.e(), blockPos1, setup3.a(), properties, identifier, structureTemplate, rotation, mirror, blockPos));
        }));
    }

    private static boolean a(SeededRandom random, float threshold) {
        return threshold != 0.0f && (threshold == 1.0f || random.i() < threshold);
    }

    private static boolean a(BlockPosition pos, Holder<BiomeBase> biome, int seaLevel) {
        return biome.a().b(pos, seaLevel);
    }

    private static int a(RandomSource random, ChunkGenerator chunkGenerator, RuinedPortalPiece.b verticalPlacement, boolean airPocket, int height, int blockCountY, StructureBoundingBox box, LevelHeightAccessor level, RandomState randomState) {
        int i3;
        int i2 = level.K_() + 15;
        if (verticalPlacement == RuinedPortalPiece.b.f) {
            i1 = airPocket ? MathHelper.b(random, 32, 100) : (random.i() < 0.5f ? MathHelper.b(random, 27, 29) : MathHelper.b(random, 29, 100));
        } else if (verticalPlacement == RuinedPortalPiece.b.d) {
            i2 = height - blockCountY;
            i1 = RuinedPortalStructure.a(random, 70, i2);
        } else if (verticalPlacement == RuinedPortalPiece.b.e) {
            i2 = height - blockCountY;
            i1 = RuinedPortalStructure.a(random, i2, i2);
        } else {
            i1 = verticalPlacement == RuinedPortalPiece.b.b ? height - blockCountY + MathHelper.b(random, 2, 8) : height;
        }
        ImmutableList list = ImmutableList.of((Object)new BlockPosition(box.h(), 0, box.j()), (Object)new BlockPosition(box.k(), 0, box.j()), (Object)new BlockPosition(box.h(), 0, box.m()), (Object)new BlockPosition(box.k(), 0, box.m()));
        List list1 = list.stream().map(pos -> chunkGenerator.a(pos.u(), pos.w(), level, randomState)).collect(Collectors.toList());
        HeightMap.Type types = verticalPlacement == RuinedPortalPiece.b.c ? HeightMap.Type.c : HeightMap.Type.a;
        for (i3 = i1; i3 > i2; --i3) {
            int i4 = 0;
            for (BlockColumn noiseColumn : list1) {
                IBlockData block = noiseColumn.a(i3);
                if (!types.e().test(block) || ++i4 != 3) continue;
                return i3;
            }
        }
        return i3;
    }

    private static int a(RandomSource random, int min, int max) {
        return min < max ? MathHelper.b(random, min, max) : max;
    }

    @Override
    public StructureType<?> e() {
        return StructureType.l;
    }

    public static final class a
    extends Record {
        private final RuinedPortalPiece.b b;
        private final float c;
        private final float d;
        private final boolean e;
        private final boolean f;
        private final boolean g;
        private final boolean h;
        private final float i;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)RuinedPortalPiece.b.g.fieldOf("placement").forGetter(a::a), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(a::b), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(a::c), (App)Codec.BOOL.fieldOf("overgrown").forGetter(a::d), (App)Codec.BOOL.fieldOf("vines").forGetter(a::e), (App)Codec.BOOL.fieldOf("can_be_cold").forGetter(a::f), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(a::g), (App)ExtraCodecs.v.fieldOf("weight").forGetter(a::h)).apply((Applicative)instance, a::new));

        public a(RuinedPortalPiece.b placement, float airPocketProbability, float mossiness, boolean overgrown, boolean vines, boolean canBeCold, boolean replaceWithBlackstone, float weight) {
            this.b = placement;
            this.c = airPocketProbability;
            this.d = mossiness;
            this.e = overgrown;
            this.f = vines;
            this.g = canBeCold;
            this.h = replaceWithBlackstone;
            this.i = weight;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this, o2);
        }

        public RuinedPortalPiece.b a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }

        public boolean d() {
            return this.e;
        }

        public boolean e() {
            return this.f;
        }

        public boolean f() {
            return this.g;
        }

        public boolean g() {
            return this.h;
        }

        public float h() {
            return this.i;
        }
    }
}

