/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;

public class PosRuleTestAxisAlignedLinear
extends PosRuleTest {
    public static final MapCodec<PosRuleTestAxisAlignedLinear> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(axisAlignedLinearPosTest -> Float.valueOf(axisAlignedLinearPosTest.b)), (App)Codec.FLOAT.fieldOf("max_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(axisAlignedLinearPosTest -> Float.valueOf(axisAlignedLinearPosTest.d)), (App)Codec.INT.fieldOf("min_dist").orElse((Object)0).forGetter(axisAlignedLinearPosTest -> axisAlignedLinearPosTest.e), (App)Codec.INT.fieldOf("max_dist").orElse((Object)0).forGetter(axisAlignedLinearPosTest -> axisAlignedLinearPosTest.f), (App)EnumDirection.EnumAxis.e.fieldOf("axis").orElse((Object)EnumDirection.EnumAxis.b).forGetter(axisAlignedLinearPosTest -> axisAlignedLinearPosTest.g)).apply((Applicative)instance, PosRuleTestAxisAlignedLinear::new));
    private final float b;
    private final float d;
    private final int e;
    private final int f;
    private final EnumDirection.EnumAxis g;

    public PosRuleTestAxisAlignedLinear(float minChance, float maxChance, int minDist, int maxDist, EnumDirection.EnumAxis axis) {
        if (minDist >= maxDist) {
            throw new IllegalArgumentException("Invalid range: [" + minDist + "," + maxDist + "]");
        }
        this.b = minChance;
        this.d = maxChance;
        this.e = minDist;
        this.f = maxDist;
        this.g = axis;
    }

    @Override
    public boolean a(BlockPosition localPos, BlockPosition relativePos, BlockPosition structurePos, RandomSource random) {
        EnumDirection direction = EnumDirection.a(EnumDirection.EnumAxisDirection.a, this.g);
        float f2 = Math.abs((relativePos.u() - structurePos.u()) * direction.j());
        float f1 = Math.abs((relativePos.v() - structurePos.v()) * direction.k());
        float f22 = Math.abs((relativePos.w() - structurePos.w()) * direction.l());
        int i2 = (int)(f2 + f1 + f22);
        float randomFloat = random.i();
        return randomFloat <= MathHelper.b(MathHelper.f(i2, this.e, this.f), this.b, this.d);
    }

    @Override
    protected PosRuleTestType<?> a() {
        return PosRuleTestType.c;
    }
}

