/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import org.jspecify.annotations.Nullable;

public class NoiseGenerator3 {
    private final @Nullable NoiseGenerator3Handler[] a;
    private final double b;
    private final double c;

    public NoiseGenerator3(RandomSource random, List<Integer> octaves) {
        this(random, (IntSortedSet)new IntRBTreeSet(octaves));
    }

    private NoiseGenerator3(RandomSource random, IntSortedSet octaves) {
        int i1;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i2 = -octaves.firstInt();
        int i22 = i2 + (i1 = octaves.lastInt()) + 1;
        if (i22 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        NoiseGenerator3Handler simplexNoise = new NoiseGenerator3Handler(random);
        int i3 = i1;
        this.a = new NoiseGenerator3Handler[i22];
        if (i1 >= 0 && i1 < i22 && octaves.contains(0)) {
            this.a[i1] = simplexNoise;
        }
        for (int i4 = i1 + 1; i4 < i22; ++i4) {
            if (i4 >= 0 && octaves.contains(i3 - i4)) {
                this.a[i4] = new NoiseGenerator3Handler(random);
                continue;
            }
            random.b(262);
        }
        if (i1 > 0) {
            long l2 = (long)(simplexNoise.a(simplexNoise.b, simplexNoise.c, simplexNoise.d) * 9.223372036854776E18);
            SeededRandom randomSource = new SeededRandom(new LegacyRandomSource(l2));
            for (int i5 = i3 - 1; i5 >= 0; --i5) {
                if (i5 < i22 && octaves.contains(i3 - i5)) {
                    this.a[i5] = new NoiseGenerator3Handler(randomSource);
                    continue;
                }
                randomSource.b(262);
            }
        }
        this.c = Math.pow(2.0, i1);
        this.b = 1.0 / (Math.pow(2.0, i22) - 1.0);
    }

    public double a(double x2, double y2, boolean useNoiseOffsets) {
        double d2 = 0.0;
        double d1 = this.c;
        double d22 = this.b;
        for (NoiseGenerator3Handler simplexNoise : this.a) {
            if (simplexNoise != null) {
                d2 += simplexNoise.a(x2 * d1 + (useNoiseOffsets ? simplexNoise.b : 0.0), y2 * d1 + (useNoiseOffsets ? simplexNoise.c : 0.0)) * d22;
            }
            d1 /= 2.0;
            d22 *= 2.0;
        }
        return d2;
    }
}

