/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;

public final class NoiseGeneratorPerlin {
    private static final float d = 1.0E-7f;
    private final byte[] e;
    public final double a;
    public final double b;
    public final double c;

    public NoiseGeneratorPerlin(RandomSource random) {
        int i2;
        this.a = random.j() * 256.0;
        this.b = random.j() * 256.0;
        this.c = random.j() * 256.0;
        this.e = new byte[256];
        for (i2 = 0; i2 < 256; ++i2) {
            this.e[i2] = (byte)i2;
        }
        for (i2 = 0; i2 < 256; ++i2) {
            int randomInt = random.a(256 - i2);
            byte b2 = this.e[i2];
            this.e[i2] = this.e[i2 + randomInt];
            this.e[i2 + randomInt] = b2;
        }
    }

    public double a(double x2, double y2, double z2) {
        return this.a(x2, y2, z2, 0.0, 0.0);
    }

    @Deprecated
    public double a(double x2, double y2, double z2, double yScale, double yMax) {
        double d7;
        double d2 = x2 + this.a;
        double d1 = y2 + this.b;
        double d22 = z2 + this.c;
        int floor = MathHelper.c(d2);
        int floor1 = MathHelper.c(d1);
        int floor2 = MathHelper.c(d22);
        double d3 = d2 - (double)floor;
        double d4 = d1 - (double)floor1;
        double d5 = d22 - (double)floor2;
        if (yScale != 0.0) {
            double d6 = yMax >= 0.0 && yMax < d4 ? yMax : d4;
            d7 = (double)MathHelper.c(d6 / yScale + (double)1.0E-7f) * yScale;
        } else {
            d7 = 0.0;
        }
        return this.a(floor, floor1, floor2, d3, d4 - d7, d5, d4);
    }

    public double a(double x2, double y2, double z2, double[] values) {
        double d2 = x2 + this.a;
        double d1 = y2 + this.b;
        double d22 = z2 + this.c;
        int floor = MathHelper.c(d2);
        int floor1 = MathHelper.c(d1);
        int floor2 = MathHelper.c(d22);
        double d3 = d2 - (double)floor;
        double d4 = d1 - (double)floor1;
        double d5 = d22 - (double)floor2;
        return this.a(floor, floor1, floor2, d3, d4, d5, values);
    }

    private static double a(int gradIndex, double xFactor, double yFactor, double zFactor) {
        return NoiseGenerator3Handler.a(NoiseGenerator3Handler.a[gradIndex & 0xF], xFactor, yFactor, zFactor);
    }

    private int a(int index) {
        return this.e[index & 0xFF] & 0xFF;
    }

    private double a(int gridX, int gridY, int gridZ, double deltaX, double weirdDeltaY, double deltaZ, double deltaY) {
        int i2 = this.a(gridX);
        int i1 = this.a(gridX + 1);
        int i22 = this.a(i2 + gridY);
        int i3 = this.a(i2 + gridY + 1);
        int i4 = this.a(i1 + gridY);
        int i5 = this.a(i1 + gridY + 1);
        double d2 = NoiseGeneratorPerlin.a(this.a(i22 + gridZ), deltaX, weirdDeltaY, deltaZ);
        double d1 = NoiseGeneratorPerlin.a(this.a(i4 + gridZ), deltaX - 1.0, weirdDeltaY, deltaZ);
        double d22 = NoiseGeneratorPerlin.a(this.a(i3 + gridZ), deltaX, weirdDeltaY - 1.0, deltaZ);
        double d3 = NoiseGeneratorPerlin.a(this.a(i5 + gridZ), deltaX - 1.0, weirdDeltaY - 1.0, deltaZ);
        double d4 = NoiseGeneratorPerlin.a(this.a(i22 + gridZ + 1), deltaX, weirdDeltaY, deltaZ - 1.0);
        double d5 = NoiseGeneratorPerlin.a(this.a(i4 + gridZ + 1), deltaX - 1.0, weirdDeltaY, deltaZ - 1.0);
        double d6 = NoiseGeneratorPerlin.a(this.a(i3 + gridZ + 1), deltaX, weirdDeltaY - 1.0, deltaZ - 1.0);
        double d7 = NoiseGeneratorPerlin.a(this.a(i5 + gridZ + 1), deltaX - 1.0, weirdDeltaY - 1.0, deltaZ - 1.0);
        double d8 = MathHelper.k(deltaX);
        double d9 = MathHelper.k(deltaY);
        double d10 = MathHelper.k(deltaZ);
        return MathHelper.a(d8, d9, d10, d2, d1, d22, d3, d4, d5, d6, d7);
    }

    private double a(int gridX, int gridY, int gridZ, double deltaX, double deltaY, double deltaZ, double[] noiseValues) {
        int i2 = this.a(gridX);
        int i1 = this.a(gridX + 1);
        int i22 = this.a(i2 + gridY);
        int i3 = this.a(i2 + gridY + 1);
        int i4 = this.a(i1 + gridY);
        int i5 = this.a(i1 + gridY + 1);
        int i6 = this.a(i22 + gridZ);
        int i7 = this.a(i4 + gridZ);
        int i8 = this.a(i3 + gridZ);
        int i9 = this.a(i5 + gridZ);
        int i10 = this.a(i22 + gridZ + 1);
        int i11 = this.a(i4 + gridZ + 1);
        int i12 = this.a(i3 + gridZ + 1);
        int i13 = this.a(i5 + gridZ + 1);
        int[] ints = NoiseGenerator3Handler.a[i6 & 0xF];
        int[] ints1 = NoiseGenerator3Handler.a[i7 & 0xF];
        int[] ints2 = NoiseGenerator3Handler.a[i8 & 0xF];
        int[] ints3 = NoiseGenerator3Handler.a[i9 & 0xF];
        int[] ints4 = NoiseGenerator3Handler.a[i10 & 0xF];
        int[] ints5 = NoiseGenerator3Handler.a[i11 & 0xF];
        int[] ints6 = NoiseGenerator3Handler.a[i12 & 0xF];
        int[] ints7 = NoiseGenerator3Handler.a[i13 & 0xF];
        double d2 = NoiseGenerator3Handler.a(ints, deltaX, deltaY, deltaZ);
        double d1 = NoiseGenerator3Handler.a(ints1, deltaX - 1.0, deltaY, deltaZ);
        double d22 = NoiseGenerator3Handler.a(ints2, deltaX, deltaY - 1.0, deltaZ);
        double d3 = NoiseGenerator3Handler.a(ints3, deltaX - 1.0, deltaY - 1.0, deltaZ);
        double d4 = NoiseGenerator3Handler.a(ints4, deltaX, deltaY, deltaZ - 1.0);
        double d5 = NoiseGenerator3Handler.a(ints5, deltaX - 1.0, deltaY, deltaZ - 1.0);
        double d6 = NoiseGenerator3Handler.a(ints6, deltaX, deltaY - 1.0, deltaZ - 1.0);
        double d7 = NoiseGenerator3Handler.a(ints7, deltaX - 1.0, deltaY - 1.0, deltaZ - 1.0);
        double d8 = MathHelper.k(deltaX);
        double d9 = MathHelper.k(deltaY);
        double d10 = MathHelper.k(deltaZ);
        double d11 = MathHelper.a(d8, d9, d10, ints[0], ints1[0], ints2[0], ints3[0], ints4[0], ints5[0], ints6[0], ints7[0]);
        double d12 = MathHelper.a(d8, d9, d10, ints[1], ints1[1], ints2[1], ints3[1], ints4[1], ints5[1], ints6[1], ints7[1]);
        double d13 = MathHelper.a(d8, d9, d10, ints[2], ints1[2], ints2[2], ints3[2], ints4[2], ints5[2], ints6[2], ints7[2]);
        double d14 = MathHelper.a(d9, d10, d1 - d2, d3 - d22, d5 - d4, d7 - d6);
        double d15 = MathHelper.a(d10, d8, d22 - d2, d6 - d4, d3 - d1, d7 - d5);
        double d16 = MathHelper.a(d8, d9, d4 - d2, d5 - d1, d6 - d22, d7 - d3);
        double d17 = MathHelper.l(deltaX);
        double d18 = MathHelper.l(deltaY);
        double d19 = MathHelper.l(deltaZ);
        double d20 = d11 + d17 * d14;
        double d21 = d12 + d18 * d15;
        double d222 = d13 + d19 * d16;
        noiseValues[0] = noiseValues[0] + d20;
        noiseValues[1] = noiseValues[1] + d21;
        noiseValues[2] = noiseValues[2] + d222;
        return MathHelper.a(d8, d9, d10, d2, d1, d22, d3, d4, d5, d6, d7);
    }

    @VisibleForTesting
    public void a(StringBuilder builder) {
        NoiseUtils.a(builder, this.a, this.b, this.c, this.e);
    }
}

