/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import net.minecraft.world.level.lighting.LightEngineStorage;
import net.minecraft.world.level.lighting.LightEngineStorageArray;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public abstract class LightEngine<M extends LightEngineStorageArray<M>, S extends LightEngineStorage<M>>
implements LightEngineLayerEventListener {
    public static final int a = 15;
    protected static final int b = 1;
    protected static final long c = net.minecraft.world.level.lighting.LightEngine$a.a(1);
    private static final int g = 512;
    protected static final EnumDirection[] d = EnumDirection.values();
    protected final ILightAccess e;
    protected final S f;
    private final LongOpenHashSet h = new LongOpenHashSet(512, 0.5f);
    private final LongArrayFIFOQueue i = new LongArrayFIFOQueue();
    private final LongArrayFIFOQueue j = new LongArrayFIFOQueue();
    private static final int k = 2;
    private final long[] l = new long[2];
    private final LightChunk[] m = new LightChunk[2];

    protected LightEngine(ILightAccess chunkSource, S storage) {
        this.e = chunkSource;
        this.f = storage;
        this.c();
    }

    public static boolean a(IBlockData state1, IBlockData state2) {
        return state2 != state1 && (state2.g() != state1.g() || state2.k() != state1.k() || state2.j() || state1.j());
    }

    public static int a(IBlockData state1, IBlockData state2, EnumDirection direction, int defaultReturnValue) {
        boolean isEmptyShape = LightEngine.a(state1);
        boolean isEmptyShape1 = LightEngine.a(state2);
        if (isEmptyShape && isEmptyShape1) {
            return defaultReturnValue;
        }
        VoxelShape voxelShape = isEmptyShape ? VoxelShapes.a() : state1.h();
        VoxelShape voxelShape1 = isEmptyShape1 ? VoxelShapes.a() : state2.h();
        return VoxelShapes.b(voxelShape, voxelShape1, direction) ? 16 : defaultReturnValue;
    }

    public static VoxelShape a(IBlockData state, EnumDirection direction) {
        return LightEngine.a(state) ? VoxelShapes.a() : state.a(direction);
    }

    protected static boolean a(IBlockData state) {
        return !state.t() || !state.j();
    }

    protected IBlockData c(BlockPosition pos) {
        int sectionPosZ;
        int sectionPosX = SectionPosition.a(pos.u());
        LightChunk chunk = this.a(sectionPosX, sectionPosZ = SectionPosition.a(pos.w()));
        return chunk == null ? Blocks.I.m() : chunk.a_(pos);
    }

    protected int b(IBlockData state) {
        return Math.max(1, state.g());
    }

    protected boolean a(IBlockData state1, IBlockData state2, EnumDirection direction) {
        VoxelShape occlusionShape = LightEngine.a(state1, direction);
        VoxelShape occlusionShape1 = LightEngine.a(state2, direction.g());
        return VoxelShapes.b(occlusionShape, occlusionShape1);
    }

    protected @Nullable LightChunk a(int x2, int z2) {
        long packedChunkPos = ChunkCoordIntPair.d(x2, z2);
        for (int i2 = 0; i2 < 2; ++i2) {
            if (packedChunkPos != this.l[i2]) continue;
            return this.m[i2];
        }
        LightChunk chunkForLighting = this.e.c(x2, z2);
        for (int i1 = 1; i1 > 0; --i1) {
            this.l[i1] = this.l[i1 - 1];
            this.m[i1] = this.m[i1 - 1];
        }
        this.l[0] = packedChunkPos;
        this.m[0] = chunkForLighting;
        return chunkForLighting;
    }

    private void c() {
        Arrays.fill(this.l, ChunkCoordIntPair.c);
        Arrays.fill(this.m, null);
    }

    @Override
    public void a(BlockPosition pos) {
        this.h.add(pos.a());
    }

    public void a(long sectionPos, @Nullable NibbleArray data) {
        ((LightEngineStorage)this.f).a(sectionPos, data);
    }

    public void b(ChunkCoordIntPair chunkPos, boolean retainData) {
        ((LightEngineStorage)this.f).c(SectionPosition.b(chunkPos.h, chunkPos.i), retainData);
    }

    @Override
    public void a(SectionPosition pos, boolean isQueueEmpty) {
        ((LightEngineStorage)this.f).d(pos.s(), isQueueEmpty);
    }

    @Override
    public void a(ChunkCoordIntPair chunkPos, boolean lightEnabled) {
        ((LightEngineStorage)this.f).b(SectionPosition.b(chunkPos.h, chunkPos.i), lightEnabled);
    }

    @Override
    public int a() {
        LongIterator longIterator = this.h.iterator();
        while (longIterator.hasNext()) {
            this.a(longIterator.nextLong());
        }
        this.h.clear();
        this.h.trim(512);
        int i2 = 0;
        i2 += this.e();
        this.c();
        ((LightEngineStorage)this.f).a(this);
        ((LightEngineStorage)this.f).b();
        return i2 += this.d();
    }

    private int d() {
        int i2 = 0;
        while (!this.j.isEmpty()) {
            long l2 = this.j.dequeueLong();
            long l1 = this.j.dequeueLong();
            int storedLevel = ((LightEngineStorage)this.f).e(l2);
            int fromLevel = net.minecraft.world.level.lighting.LightEngine$a.a(l1);
            if (net.minecraft.world.level.lighting.LightEngine$a.c(l1) && storedLevel < fromLevel) {
                ((LightEngineStorage)this.f).a(l2, fromLevel);
                storedLevel = fromLevel;
            }
            if (storedLevel == fromLevel) {
                this.a(l2, l1, storedLevel);
            }
            ++i2;
        }
        return i2;
    }

    private int e() {
        int i2 = 0;
        while (!this.i.isEmpty()) {
            long l2 = this.i.dequeueLong();
            long l1 = this.i.dequeueLong();
            this.a(l2, l1);
            ++i2;
        }
        return i2;
    }

    protected void b(long packedPos1, long packedPos2) {
        this.i.enqueue(packedPos1);
        this.i.enqueue(packedPos2);
    }

    protected void c(long packedPos1, long packedPos2) {
        this.j.enqueue(packedPos1);
        this.j.enqueue(packedPos2);
    }

    @Override
    public boolean M_() {
        return ((LightEngineStorage)this.f).a() || !this.h.isEmpty() || !this.i.isEmpty() || !this.j.isEmpty();
    }

    @Override
    public @Nullable NibbleArray a(SectionPosition sectionPos) {
        return ((LightEngineStorage)this.f).d(sectionPos.s());
    }

    @Override
    public int b(BlockPosition pos) {
        return ((LightEngineStorage)this.f).a(pos.a());
    }

    public String b(long sectionPos) {
        return this.c(sectionPos).a();
    }

    public LightEngineStorage.b c(long sectionPos) {
        return ((LightEngineStorage)this.f).l(sectionPos);
    }

    protected abstract void a(long var1);

    protected abstract void a(long var1, long var3, int var5);

    protected abstract void a(long var1, long var3);

    public static class a {
        private static final int a = 4;
        private static final int b = 6;
        private static final long c = 15L;
        private static final long d = 1008L;
        private static final long e = 1024L;
        private static final long f = 2048L;

        public static long a(int level, EnumDirection direction) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.c(1008L, direction);
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, level);
        }

        public static long a(int level) {
            return net.minecraft.world.level.lighting.LightEngine$a.a(1008L, level);
        }

        public static long a(int level, boolean fromEmptyShape) {
            long l2 = 1008L;
            l2 |= 0x800L;
            if (fromEmptyShape) {
                l2 |= 0x400L;
            }
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, level);
        }

        public static long a(int level, boolean fromEmptyShape, EnumDirection direction) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.c(1008L, direction);
            if (fromEmptyShape) {
                l2 |= 0x400L;
            }
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, level);
        }

        public static long b(int level, boolean fromEmptyShape, EnumDirection direction) {
            long l2 = 0L;
            if (fromEmptyShape) {
                l2 |= 0x400L;
            }
            l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, direction);
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, level);
        }

        public static long a(boolean down, boolean north, boolean south, boolean west, boolean east) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.a(0L, 15);
            if (down) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.a);
            }
            if (north) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.c);
            }
            if (south) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.d);
            }
            if (west) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.e);
            }
            if (east) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.f);
            }
            return l2;
        }

        public static int a(long entry) {
            return (int)(entry & 0xFL);
        }

        public static boolean b(long entry) {
            return (entry & 0x400L) != 0L;
        }

        public static boolean c(long entry) {
            return (entry & 0x800L) != 0L;
        }

        public static boolean a(long entry, EnumDirection direction) {
            return (entry & 1L << direction.ordinal() + 4) != 0L;
        }

        private static long a(long entry, int level) {
            return entry & 0xFFFFFFFFFFFFFFF0L | (long)level & 0xFL;
        }

        private static long b(long entry, EnumDirection direction) {
            return entry | 1L << direction.ordinal() + 4;
        }

        private static long c(long entry, EnumDirection direction) {
            return entry & (1L << direction.ordinal() + 4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

