/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.lighting.LeveledPriorityQueue;

public abstract class LightEngineGraph {
    public static final long e = Long.MAX_VALUE;
    private static final int a = 255;
    protected final int f;
    private final LeveledPriorityQueue b;
    private final Long2ByteMap c;
    private volatile boolean d;

    protected LightEngineGraph(int firstQueuedLevel, int width, final int height) {
        if (firstQueuedLevel >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.f = firstQueuedLevel;
        this.b = new LeveledPriorityQueue(firstQueuedLevel, width);
        this.c = new Long2ByteOpenHashMap(height, 0.5f){

            protected void rehash(int newSize) {
                if (newSize > height) {
                    super.rehash(newSize);
                }
            }
        };
        this.c.defaultReturnValue((byte)-1);
    }

    protected void d(long position) {
        int i2 = this.c.remove(position) & 0xFF;
        if (i2 != 255) {
            int level = this.c(position);
            int i1 = this.a(level, i2);
            this.b.a(position, i1, this.f);
            this.d = !this.b.b();
        }
    }

    public void a(LongPredicate predicate) {
        LongArrayList list = new LongArrayList();
        this.c.keySet().forEach(arg_0 -> LightEngineGraph.a(predicate, (LongList)list, arg_0));
        list.forEach(this::d);
    }

    private int a(int oldLevel, int newLevel) {
        return Math.min(Math.min(oldLevel, newLevel), this.f - 1);
    }

    protected void e(long pos) {
        this.a(pos, pos, this.f - 1, false);
    }

    protected void a(long fromPos, long toPos, int newLevel, boolean isDecreasing) {
        this.a(fromPos, toPos, newLevel, this.c(toPos), this.c.get(toPos) & 0xFF, isDecreasing);
        this.d = !this.b.b();
    }

    private void a(long fromPos, long toPos, int newLevel, int previousLevel, int propagationLevel, boolean isDecreasing) {
        if (!this.a(toPos)) {
            boolean flag;
            newLevel = MathHelper.a(newLevel, 0, this.f - 1);
            previousLevel = MathHelper.a(previousLevel, 0, this.f - 1);
            boolean bl = flag = propagationLevel == 255;
            if (flag) {
                propagationLevel = previousLevel;
            }
            int min = isDecreasing ? Math.min(propagationLevel, newLevel) : MathHelper.a(this.a(toPos, fromPos, newLevel), 0, this.f - 1);
            int i2 = this.a(previousLevel, propagationLevel);
            if (previousLevel != min) {
                int i1 = this.a(previousLevel, min);
                if (i2 != i1 && !flag) {
                    this.b.a(toPos, i2, i1);
                }
                this.b.a(toPos, i1);
                this.c.put(toPos, (byte)min);
            } else if (!flag) {
                this.b.a(toPos, i2, this.f);
                this.c.remove(toPos);
            }
        }
    }

    protected final void b(long fromPos, long toPos, int sourceLevel, boolean isDecreasing) {
        int i2 = this.c.get(toPos) & 0xFF;
        int i1 = MathHelper.a(this.b(fromPos, toPos, sourceLevel), 0, this.f - 1);
        if (isDecreasing) {
            this.a(fromPos, toPos, i1, this.c(toPos), i2, isDecreasing);
        } else {
            boolean flag = i2 == 255;
            int i22 = flag ? MathHelper.a(this.c(toPos), 0, this.f - 1) : i2;
            if (i1 == i22) {
                this.a(fromPos, toPos, this.f - 1, flag ? i22 : this.c(toPos), i2, isDecreasing);
            }
        }
    }

    protected final boolean b() {
        return this.d;
    }

    protected final int b(int toUpdateCount) {
        if (this.b.b()) {
            return toUpdateCount;
        }
        while (!this.b.b() && toUpdateCount > 0) {
            --toUpdateCount;
            long l2 = this.b.a();
            int i2 = MathHelper.a(this.c(l2), 0, this.f - 1);
            int i1 = this.c.remove(l2) & 0xFF;
            if (i1 < i2) {
                this.a(l2, i1);
                this.a(l2, i1, true);
                continue;
            }
            if (i1 <= i2) continue;
            this.a(l2, this.f - 1);
            if (i1 != this.f - 1) {
                this.b.a(l2, this.a(this.f - 1, i1));
                this.c.put(l2, (byte)i1);
            }
            this.a(l2, i2, false);
        }
        this.d = !this.b.b();
        return toUpdateCount;
    }

    public int c() {
        return this.c.size();
    }

    protected boolean a(long pos) {
        return pos == Long.MAX_VALUE;
    }

    protected abstract int a(long var1, long var3, int var5);

    protected abstract void a(long var1, int var3, boolean var4);

    protected abstract int c(long var1);

    protected abstract void a(long var1, int var3);

    protected abstract int b(long var1, long var3, int var5);

    private static /* synthetic */ void a(LongPredicate predicate, LongList list, long value) {
        if (predicate.test(value)) {
            list.add(value);
        }
    }
}

