/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public final class PathEntity {
    public static final StreamCodec<PacketDataSerializer, PathEntity> a = StreamCodec.a((B buffer, V value) -> value.a((PacketDataSerializer)((Object)buffer)), PathEntity::b);
    public final List<PathPoint> b;
    private @Nullable a c;
    private int d;
    private final BlockPosition e;
    private final float f;
    private final boolean g;

    public PathEntity(List<PathPoint> nodes, BlockPosition target, boolean reached) {
        this.b = nodes;
        this.e = target;
        this.f = nodes.isEmpty() ? Float.MAX_VALUE : this.b.get(this.b.size() - 1).c(this.e);
        this.g = reached;
    }

    public void a() {
        ++this.d;
    }

    public boolean b() {
        return this.d <= 0;
    }

    public boolean c() {
        return this.d >= this.b.size();
    }

    public @Nullable PathPoint d() {
        return !this.b.isEmpty() ? this.b.get(this.b.size() - 1) : null;
    }

    public PathPoint a(int index) {
        return this.b.get(index);
    }

    public void b(int length) {
        if (this.b.size() > length) {
            this.b.subList(length, this.b.size()).clear();
        }
    }

    public void a(int index, PathPoint node) {
        this.b.set(index, node);
    }

    public int e() {
        return this.b.size();
    }

    public int f() {
        return this.d;
    }

    public void c(int currentIndex) {
        this.d = currentIndex;
    }

    public Vec3D a(Entity entity, int index) {
        PathPoint node = this.b.get(index);
        double d2 = (double)node.a + (double)((int)(entity.dF() + 1.0f)) * 0.5;
        double d1 = node.b;
        double d22 = (double)node.c + (double)((int)(entity.dF() + 1.0f)) * 0.5;
        return new Vec3D(d2, d1, d22);
    }

    public BlockPosition d(int index) {
        return this.b.get(index).a();
    }

    public Vec3D a(Entity entity) {
        return this.a(entity, this.d);
    }

    public BlockPosition g() {
        return this.b.get(this.d).a();
    }

    public PathPoint h() {
        return this.b.get(this.d);
    }

    public @Nullable PathPoint i() {
        return this.d > 0 ? this.b.get(this.d - 1) : null;
    }

    public boolean a(@Nullable PathEntity path) {
        return path != null && this.b.equals(path.b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof PathEntity)) return false;
        PathEntity path = (PathEntity)other;
        if (this.d != path.d) return false;
        if (this.c != path.c) return false;
        if (this.g != path.g) return false;
        if (!this.e.equals(path.e)) return false;
        if (!this.b.equals(path.b)) return false;
        return true;
    }

    public int hashCode() {
        return this.d + this.b.hashCode() * 31;
    }

    public boolean j() {
        return this.g;
    }

    @VisibleForDebug
    void a(PathPoint[] openSet, PathPoint[] closedSet, Set<PathDestination> targetNodes) {
        this.c = new a(openSet, closedSet, targetNodes);
    }

    public @Nullable a k() {
        return this.c;
    }

    public void a(PacketDataSerializer buffer) {
        if (this.c == null || this.c.c.isEmpty()) {
            throw new IllegalStateException("Missing debug data");
        }
        buffer.a(this.g);
        buffer.q(this.d);
        buffer.a(this.e);
        buffer.a(this.b, (? super PacketDataSerializer buffer1, T value) -> value.a((PacketDataSerializer)((Object)buffer1)));
        this.c.a(buffer);
    }

    public static PathEntity b(PacketDataSerializer buffer) {
        boolean _boolean = buffer.readBoolean();
        int _int = buffer.readInt();
        BlockPosition blockPos = buffer.e();
        List<PathPoint> list = buffer.a(PathPoint::b);
        a debugData = net.minecraft.world.level.pathfinder.PathEntity$a.b(buffer);
        PathEntity path = new PathEntity(list, blockPos, _boolean);
        path.c = debugData;
        path.d = _int;
        return path;
    }

    public String toString() {
        return "Path(length=" + this.b.size() + ")";
    }

    public BlockPosition l() {
        return this.e;
    }

    public float m() {
        return this.f;
    }

    static PathPoint[] c(PacketDataSerializer buffer) {
        PathPoint[] nodes = new PathPoint[buffer.l()];
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            nodes[i2] = PathPoint.b(buffer);
        }
        return nodes;
    }

    static void a(PacketDataSerializer buffer, PathPoint[] nodeArray) {
        buffer.c(nodeArray.length);
        for (PathPoint node : nodeArray) {
            node.a(buffer);
        }
    }

    public PathEntity n() {
        PathEntity path = new PathEntity(this.b, this.e, this.g);
        path.c = this.c;
        path.d = this.d;
        return path;
    }

    public record a(PathPoint[] a, PathPoint[] b, Set<PathDestination> c) {
        public void a(PacketDataSerializer buffer) {
            buffer.a(this.c, (buffer1, value) -> value.a((PacketDataSerializer)((Object)buffer1)));
            PathEntity.a(buffer, this.a);
            PathEntity.a(buffer, this.b);
        }

        public static a b(PacketDataSerializer buffer) {
            HashSet set = (HashSet)((Object)buffer.a(HashSet::new, PathDestination::c));
            PathPoint[] nodeArray = PathEntity.c(buffer);
            PathPoint[] nodeArray1 = PathEntity.c(buffer);
            return new a(nodeArray, nodeArray1, set);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this, o2);
        }
    }
}

