/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class PathfinderNormal
extends PathfinderAbstract {
    public static final double l = 0.5;
    private static final double a = 1.125;
    private final Long2ObjectMap<PathType> m = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AxisAlignedBB> n = new Object2BooleanOpenHashMap();
    private final PathPoint[] o = new PathPoint[EnumDirection.EnumDirectionLimit.a.b()];

    @Override
    public void a(ChunkCache level, EntityInsentient mob) {
        super.a(level, mob);
        mob.G();
    }

    @Override
    public void b() {
        this.c.H();
        this.m.clear();
        this.n.clear();
        super.b();
    }

    @Override
    public PathPoint a() {
        int blockY;
        BlockPosition.MutableBlockPosition mutableBlockPos;
        block11: {
            mutableBlockPos = new BlockPosition.MutableBlockPosition();
            blockY = this.c.dQ();
            IBlockData blockState = this.b.a(mutableBlockPos.b(this.c.dP(), (double)blockY, this.c.dV()));
            if (!this.c.a(blockState.y())) {
                if (this.f() && this.c.by()) {
                    while (true) {
                        if (!blockState.a(Blocks.J) && blockState.y() != FluidTypes.c.a(false)) {
                            --blockY;
                            break block11;
                        }
                        blockState = this.b.a(mutableBlockPos.b(this.c.dP(), (double)(++blockY), this.c.dV()));
                    }
                }
                if (this.c.aV()) {
                    blockY = MathHelper.c(this.c.dR() + 0.5);
                } else {
                    mutableBlockPos.b(this.c.dP(), this.c.dR() + 1.0, this.c.dV());
                    while (mutableBlockPos.v() > this.b.a().K_()) {
                        blockY = mutableBlockPos.v();
                        mutableBlockPos.q(mutableBlockPos.v() - 1);
                        IBlockData blockState1 = this.b.a(mutableBlockPos);
                        if (blockState1.l() || blockState1.a(PathMode.a)) continue;
                        break;
                    }
                }
            } else {
                while (this.c.a(blockState.y())) {
                    blockState = this.b.a(mutableBlockPos.b(this.c.dP(), (double)(++blockY), this.c.dV()));
                }
                --blockY;
            }
        }
        BlockPosition blockPos = this.c.dK();
        if (!this.a(mutableBlockPos.d(blockPos.u(), blockY, blockPos.w()))) {
            AxisAlignedBB boundingBox = this.c.dj();
            if (this.a(mutableBlockPos.b(boundingBox.a, (double)blockY, boundingBox.c)) || this.a(mutableBlockPos.b(boundingBox.a, (double)blockY, boundingBox.f)) || this.a(mutableBlockPos.b(boundingBox.d, (double)blockY, boundingBox.c)) || this.a(mutableBlockPos.b(boundingBox.d, (double)blockY, boundingBox.f))) {
                return this.c(mutableBlockPos);
            }
        }
        return this.c(new BlockPosition(blockPos.u(), blockY, blockPos.w()));
    }

    protected PathPoint c(BlockPosition pos) {
        PathPoint node = this.b(pos);
        node.l = this.b(node.a, node.b, node.c);
        node.k = this.c.a(node.l);
        return node;
    }

    protected boolean a(BlockPosition pos) {
        PathType cachedPathType = this.b(pos.u(), pos.v(), pos.w());
        return cachedPathType != PathType.b && this.c.a(cachedPathType) >= 0.0f;
    }

    @Override
    public PathDestination a(double x2, double y2, double z2) {
        return this.b(x2, y2, z2);
    }

    @Override
    public int a(PathPoint[] outputArray, PathPoint node) {
        int i2 = 0;
        int i1 = 0;
        PathType cachedPathType = this.b(node.a, node.b + 1, node.c);
        PathType cachedPathType1 = this.b(node.a, node.b, node.c);
        if (this.c.a(cachedPathType) >= 0.0f && cachedPathType1 != PathType.w) {
            i1 = MathHelper.b(Math.max(1.0f, this.c.eg()));
        }
        double floorLevel = this.d(new BlockPosition(node.a, node.b, node.c));
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            PathPoint node1;
            this.o[direction.e()] = node1 = this.a(node.a + direction.j(), node.b, node.c + direction.l(), i1, floorLevel, direction, cachedPathType1);
            if (!this.a(node1, node)) continue;
            outputArray[i2++] = node1;
        }
        for (EnumDirection directionx : EnumDirection.EnumDirectionLimit.a) {
            PathPoint node2;
            EnumDirection clockWise = directionx.h();
            if (!this.a(node, this.o[directionx.e()], this.o[clockWise.e()]) || !this.a(node2 = this.a(node.a + directionx.j() + clockWise.j(), node.b, node.c + directionx.l() + clockWise.l(), i1, floorLevel, directionx, cachedPathType1))) continue;
            outputArray[i2++] = node2;
        }
        return i2;
    }

    protected boolean a(@Nullable PathPoint neighbor, PathPoint node) {
        return neighbor != null && !neighbor.i && (neighbor.k >= 0.0f || node.k < 0.0f);
    }

    protected boolean a(PathPoint root, @Nullable PathPoint xNode, @Nullable PathPoint zNode) {
        if (zNode == null || xNode == null || zNode.b > root.b || xNode.b > root.b) {
            return false;
        }
        if (xNode.l != PathType.d && zNode.l != PathType.d) {
            boolean flag = zNode.l == PathType.h && xNode.l == PathType.h && (double)this.c.dF() < 0.5;
            return (zNode.b < root.b || zNode.k >= 0.0f || flag) && (xNode.b < root.b || xNode.k >= 0.0f || flag);
        }
        return false;
    }

    protected boolean a(@Nullable PathPoint node) {
        return node != null && !node.i && node.l != PathType.d && node.k >= 0.0f;
    }

    private static boolean a(PathType pathType) {
        return pathType == PathType.h || pathType == PathType.s || pathType == PathType.t;
    }

    private boolean b(PathPoint node) {
        AxisAlignedBB boundingBox = this.c.dj();
        Vec3D vec3 = new Vec3D((double)node.a - this.c.dP() + boundingBox.b() / 2.0, (double)node.b - this.c.dR() + boundingBox.c() / 2.0, (double)node.c - this.c.dV() + boundingBox.d() / 2.0);
        int ceil = MathHelper.e(vec3.g() / boundingBox.a());
        vec3 = vec3.c((double)(1.0f / (float)ceil));
        for (int i2 = 1; i2 <= ceil; ++i2) {
            if (!this.a(boundingBox = boundingBox.c(vec3))) continue;
            return false;
        }
        return true;
    }

    protected double d(BlockPosition pos) {
        ICollisionAccess blockGetter = this.b.a();
        return (this.f() || this.c()) && blockGetter.b_(pos).a(TagsFluid.a) ? (double)pos.v() + 0.5 : PathfinderNormal.a(blockGetter, pos);
    }

    public static double a(IBlockAccess level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        VoxelShape collisionShape = level.a_(blockPos).g(level, blockPos);
        return (double)blockPos.v() + (collisionShape.c() ? 0.0 : collisionShape.c(EnumDirection.EnumAxis.b));
    }

    protected boolean c() {
        return false;
    }

    protected @Nullable PathPoint a(int x2, int y2, int z2, int verticalDeltaLimit, double nodeFloorLevel, EnumDirection direction, PathType pathType) {
        PathPoint node = null;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        double floorLevel = this.d(mutableBlockPos.d(x2, y2, z2));
        if (floorLevel - nodeFloorLevel > this.h()) {
            return null;
        }
        PathType cachedPathType = this.b(x2, y2, z2);
        float pathfindingMalus = this.c.a(cachedPathType);
        if (pathfindingMalus >= 0.0f) {
            node = this.a(x2, y2, z2, cachedPathType, pathfindingMalus);
        }
        if (PathfinderNormal.a(pathType) && node != null && node.k >= 0.0f && !this.b(node)) {
            node = null;
        }
        if (!(cachedPathType == PathType.c || this.c() && cachedPathType == PathType.j)) {
            if ((node == null || node.k < 0.0f) && verticalDeltaLimit > 0 && (cachedPathType != PathType.h || this.g()) && cachedPathType != PathType.m && cachedPathType != PathType.e && cachedPathType != PathType.f) {
                node = this.a(x2, y2, z2, verticalDeltaLimit, nodeFloorLevel, direction, pathType, mutableBlockPos);
            } else if (!this.c() && cachedPathType == PathType.j && !this.f()) {
                node = this.a(x2, y2, z2, node);
            } else if (cachedPathType == PathType.b) {
                node = this.d(x2, y2, z2);
            } else if (PathfinderNormal.a(cachedPathType) && node == null) {
                node = this.a(x2, y2, z2, cachedPathType);
            }
            return node;
        }
        return node;
    }

    private double h() {
        return Math.max(1.125, (double)this.c.eg());
    }

    private PathPoint a(int x2, int y2, int z2, PathType pathType, float malus) {
        PathPoint node = this.c(x2, y2, z2);
        node.l = pathType;
        node.k = Math.max(node.k, malus);
        return node;
    }

    private PathPoint a(int x2, int y2, int z2) {
        PathPoint node = this.c(x2, y2, z2);
        node.l = PathType.a;
        node.k = -1.0f;
        return node;
    }

    private PathPoint a(int x2, int y2, int z2, PathType pathType) {
        PathPoint node = this.c(x2, y2, z2);
        node.i = true;
        node.l = pathType;
        node.k = pathType.a();
        return node;
    }

    private @Nullable PathPoint a(int x2, int y2, int z2, int verticalDeltaLimit, double nodeFloorLevel, EnumDirection direction, PathType pathType, BlockPosition.MutableBlockPosition pos) {
        PathPoint node = this.a(x2, y2 + 1, z2, verticalDeltaLimit - 1, nodeFloorLevel, direction, pathType);
        if (node == null) {
            return null;
        }
        if (this.c.dF() >= 1.0f) {
            return node;
        }
        if (node.l != PathType.b && node.l != PathType.c) {
            return node;
        }
        double d2 = (double)(x2 - direction.j()) + 0.5;
        double d1 = (double)(z2 - direction.l()) + 0.5;
        double d22 = (double)this.c.dF() / 2.0;
        AxisAlignedBB aabb = new AxisAlignedBB(d2 - d22, this.d(pos.b(d2, (double)(y2 + 1), d1)) + 0.001, d1 - d22, d2 + d22, (double)this.c.dG() + this.d(pos.b((double)node.a, (double)node.b, (double)node.c)) - 0.002, d1 + d22);
        return this.a(aabb) ? null : node;
    }

    private @Nullable PathPoint a(int x2, int y2, int z2, @Nullable PathPoint node) {
        --y2;
        while (y2 > this.c.ao().K_()) {
            PathType cachedPathType = this.b(x2, y2, z2);
            if (cachedPathType != PathType.j) {
                return node;
            }
            node = this.a(x2, y2, z2, cachedPathType, this.c.a(cachedPathType));
            --y2;
        }
        return node;
    }

    private PathPoint d(int x2, int y2, int z2) {
        for (int i2 = y2 - 1; i2 >= this.c.ao().K_(); --i2) {
            if (y2 - i2 > this.c.cW()) {
                return this.a(x2, i2, z2);
            }
            PathType cachedPathType = this.b(x2, i2, z2);
            float pathfindingMalus = this.c.a(cachedPathType);
            if (cachedPathType == PathType.b) continue;
            if (pathfindingMalus >= 0.0f) {
                return this.a(x2, i2, z2, cachedPathType, pathfindingMalus);
            }
            return this.a(x2, i2, z2);
        }
        return this.a(x2, y2, z2);
    }

    private boolean a(AxisAlignedBB boundingBox) {
        return this.n.computeIfAbsent((Object)boundingBox, key -> !this.b.a().a((Entity)this.c, boundingBox));
    }

    protected PathType b(int x2, int y2, int z2) {
        return (PathType)((Object)this.m.computeIfAbsent(BlockPosition.a(x2, y2, z2), l2 -> this.a(this.b, x2, y2, z2, this.c)));
    }

    @Override
    public PathType a(PathfindingContext context, int x2, int y2, int z2, EntityInsentient mob) {
        Set<PathType> pathTypeWithinMobBb = this.b(context, x2, y2, z2);
        if (pathTypeWithinMobBb.contains((Object)PathType.h)) {
            return PathType.h;
        }
        if (pathTypeWithinMobBb.contains((Object)PathType.m)) {
            return PathType.m;
        }
        PathType pathType = PathType.a;
        for (PathType pathType1 : pathTypeWithinMobBb) {
            if (mob.a(pathType1) < 0.0f) {
                return pathType1;
            }
            if (!(mob.a(pathType1) >= mob.a(pathType))) continue;
            pathType = pathType1;
        }
        return this.e <= 1 && pathType != PathType.b && mob.a(pathType) == 0.0f && this.a(context, x2, y2, z2) == PathType.b ? PathType.b : pathType;
    }

    public Set<PathType> b(PathfindingContext context, int x2, int y2, int z2) {
        EnumSet<PathType> set = EnumSet.noneOf(PathType.class);
        for (int i2 = 0; i2 < this.e; ++i2) {
            for (int i1 = 0; i1 < this.f; ++i1) {
                for (int i22 = 0; i22 < this.g; ++i22) {
                    int i3 = i2 + x2;
                    int i4 = i1 + y2;
                    int i5 = i22 + z2;
                    PathType pathType = this.a(context, i3, i4, i5);
                    BlockPosition blockPos = this.c.dK();
                    boolean canPassDoors = this.d();
                    if (pathType == PathType.s && this.e() && canPassDoors) {
                        pathType = PathType.d;
                    }
                    if (pathType == PathType.r && !canPassDoors) {
                        pathType = PathType.a;
                    }
                    if (pathType == PathType.l && this.a(context, blockPos.u(), blockPos.v(), blockPos.w()) != PathType.l && this.a(context, blockPos.u(), blockPos.v() - 1, blockPos.w()) != PathType.l) {
                        pathType = PathType.m;
                    }
                    set.add(pathType);
                }
            }
        }
        return set;
    }

    @Override
    public PathType a(PathfindingContext context, int x2, int y2, int z2) {
        return PathfinderNormal.a(context, new BlockPosition.MutableBlockPosition(x2, y2, z2));
    }

    public static PathType b(EntityInsentient mob, BlockPosition pos) {
        return PathfinderNormal.a(new PathfindingContext(mob.ao(), mob), pos.k());
    }

    public static PathType a(PathfindingContext context, BlockPosition.MutableBlockPosition pos) {
        int z2;
        int y2;
        int x2 = pos.u();
        PathType pathTypeFromState = context.a(x2, y2 = pos.v(), z2 = pos.w());
        if (pathTypeFromState == PathType.b && y2 >= context.a().K_() + 1) {
            return switch (context.a(x2, y2 - 1, z2)) {
                case PathType.b, PathType.j, PathType.i, PathType.c -> PathType.b;
                case PathType.o -> PathType.o;
                case PathType.q -> PathType.q;
                case PathType.w -> PathType.w;
                case PathType.f -> PathType.g;
                case PathType.y -> PathType.y;
                case PathType.e -> PathType.z;
                default -> PathfinderNormal.a(context, x2, y2, z2, PathType.c);
            };
        }
        return pathTypeFromState;
    }

    public static PathType a(PathfindingContext context, int x2, int y2, int z2, PathType pathType) {
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int i22 = -1; i22 <= 1; ++i22) {
                    if (i2 == 0 && i22 == 0) continue;
                    PathType pathTypeFromState = context.a(x2 + i2, y2 + i1, z2 + i22);
                    if (pathTypeFromState == PathType.q) {
                        return PathType.p;
                    }
                    if (pathTypeFromState == PathType.o || pathTypeFromState == PathType.i) {
                        return PathType.n;
                    }
                    if (pathTypeFromState == PathType.j) {
                        return PathType.k;
                    }
                    if (pathTypeFromState != PathType.y) continue;
                    return PathType.y;
                }
            }
        }
        return pathType;
    }

    protected static PathType b(IBlockAccess level, BlockPosition pos) {
        IBlockData blockState = level.getBlockStateIfLoaded(pos);
        if (blockState == null) {
            return PathType.a;
        }
        Block block = blockState.b();
        if (blockState.l()) {
            return PathType.b;
        }
        if (blockState.a(TagsBlock.O) || blockState.a(Blocks.fV) || blockState.a(Blocks.uc)) {
            return PathType.e;
        }
        if (blockState.a(Blocks.rP)) {
            return PathType.f;
        }
        if (blockState.a(Blocks.es) || blockState.a(Blocks.pg)) {
            return PathType.q;
        }
        if (blockState.a(Blocks.qg)) {
            return PathType.w;
        }
        if (blockState.a(Blocks.gr)) {
            return PathType.x;
        }
        if (!blockState.a(Blocks.cn) && !blockState.a(Blocks.tQ)) {
            Fluid fluidState = blockState.y();
            if (fluidState.a(TagsFluid.b)) {
                return PathType.i;
            }
            if (PathfinderNormal.a(blockState)) {
                return PathType.o;
            }
            if (block instanceof BlockDoor) {
                BlockDoor doorBlock = (BlockDoor)block;
                if (blockState.c(BlockDoor.e).booleanValue()) {
                    return PathType.r;
                }
                return doorBlock.b().c() ? PathType.s : PathType.t;
            }
            if (block instanceof BlockMinecartTrackAbstract) {
                return PathType.l;
            }
            if (block instanceof BlockLeaves) {
                return PathType.v;
            }
            if (!(blockState.a(TagsBlock.S) || blockState.a(TagsBlock.I) || block instanceof BlockFenceGate && !blockState.c(BlockFenceGate.b).booleanValue())) {
                if (!blockState.a(PathMode.a)) {
                    return PathType.a;
                }
                return fluidState.a(TagsFluid.a) ? PathType.j : PathType.b;
            }
            return PathType.h;
        }
        return PathType.y;
    }
}

