/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R7.map.RenderData;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCursor;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger j = LogUtils.getLogger();
    private static final int k = 128;
    private static final int l = 64;
    public static final int a = 4;
    public static final int b = 256;
    private static final String m = "frame-";
    public static final Codec<WorldMap> c = RecordCodecBuilder.create(instance -> instance.group((App)WorldMap.createUUIDBackedDimensionKeyCodec().forGetter(WorldMap::packUUIDBackedDimension), (App)Codec.INT.fieldOf("xCenter").forGetter(mapItemSavedData -> mapItemSavedData.d), (App)Codec.INT.fieldOf("zCenter").forGetter(mapItemSavedData -> mapItemSavedData.e), (App)Codec.BYTE.optionalFieldOf("scale", (Object)0).forGetter(mapItemSavedData -> mapItemSavedData.g), (App)Codec.BYTE_BUFFER.fieldOf("colors").forGetter(mapItemSavedData -> ByteBuffer.wrap(mapItemSavedData.h)), (App)Codec.BOOL.optionalFieldOf("trackingPosition", (Object)true).forGetter(mapItemSavedData -> mapItemSavedData.n), (App)Codec.BOOL.optionalFieldOf("unlimitedTracking", (Object)false).forGetter(mapItemSavedData -> mapItemSavedData.o), (App)Codec.BOOL.optionalFieldOf("locked", (Object)false).forGetter(mapItemSavedData -> mapItemSavedData.i), (App)MapIconBanner.a.listOf().optionalFieldOf("banners", List.of()).forGetter(mapItemSavedData -> List.copyOf(mapItemSavedData.r.values())), (App)WorldMapFrame.a.listOf().optionalFieldOf("frames", List.of()).forGetter(mapItemSavedData -> List.copyOf(mapItemSavedData.t.values()))).apply((Applicative)instance, WorldMap::new));
    public int d;
    public int e;
    public ResourceKey<World> f;
    public boolean n;
    public boolean o;
    public byte g;
    public byte[] h = new byte[16384];
    public boolean i;
    private final RenderData vanillaRender = new RenderData();
    public final List<WorldMapHumanTracker> p = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> q = Maps.newHashMap();
    private final Map<String, MapIconBanner> r = Maps.newHashMap();
    public final Map<String, MapIcon> s = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> t = Maps.newHashMap();
    private int u;
    public final CraftMapView mapView;
    private final CraftServer server;
    public UUID uniqueId;
    public MapId id;

    public static SavedDataType<WorldMap> a(MapId mapId) {
        return new SavedDataType<WorldMap>(mapId.a(), () -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, c, DataFixTypes.k);
    }

    private WorldMap(int centerX, int centerZ, byte scale, boolean trackingPosition, boolean unlimitedTracking, boolean locked, ResourceKey<World> dimension) {
        this.g = scale;
        this.d = centerX;
        this.e = centerZ;
        this.f = dimension;
        this.n = trackingPosition;
        this.o = unlimitedTracking;
        this.i = locked;
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
        this.vanillaRender.buffer = this.h;
    }

    private WorldMap(UUIDBackedDimension dimension, int x2, int z2, byte scale, ByteBuffer colors, boolean trackingPosition, boolean unlimitedTracking, boolean locked, List<MapIconBanner> banners, List<WorldMapFrame> frames) {
        this(dimension.resolveOrThrow(), x2, z2, scale, colors, trackingPosition, unlimitedTracking, locked, banners, frames);
    }

    private WorldMap(ResourceKey<World> dimension, int centerX, int centerZ, byte scale, ByteBuffer colors, boolean trackingPosition, boolean unlimitedTracking, boolean locked, List<MapIconBanner> banners, List<WorldMapFrame> frames) {
        this(centerX, centerZ, (byte)MathHelper.a((int)scale, 0, 4), trackingPosition, unlimitedTracking, locked, dimension);
        if (colors.array().length == 16384) {
            this.h = colors.array();
        }
        for (MapIconBanner mapBanner : banners) {
            this.r.put(mapBanner.b(), mapBanner);
            this.a(mapBanner.a(), null, mapBanner.b(), mapBanner.c().u(), mapBanner.c().w(), 180.0, mapBanner.e().orElse(null));
        }
        for (WorldMapFrame mapFrame : frames) {
            this.t.put(mapFrame.a(), mapFrame);
            this.a(MapDecorationTypes.b, null, WorldMap.b(mapFrame.d()), mapFrame.b().u(), mapFrame.b().w(), mapFrame.c(), null);
        }
        this.vanillaRender.buffer = colors.array();
    }

    public static WorldMap a(double x2, double z2, byte scale, boolean trackingPosition, boolean unlimitedTracking, ResourceKey<World> dimension) {
        int i2 = 128 * (1 << scale);
        int floor = MathHelper.c((x2 + 64.0) / (double)i2);
        int floor1 = MathHelper.c((z2 + 64.0) / (double)i2);
        int i1 = floor * i2 + i2 / 2 - 64;
        int i22 = floor1 * i2 + i2 / 2 - 64;
        return new WorldMap(i1, i22, scale, trackingPosition, unlimitedTracking, false, dimension);
    }

    public static WorldMap a(byte scale, boolean locked, ResourceKey<World> dimension) {
        return new WorldMap(0, 0, scale, false, false, locked, dimension);
    }

    public WorldMap b() {
        WorldMap mapItemSavedData = new WorldMap(this.d, this.e, this.g, this.n, this.o, true, this.f);
        mapItemSavedData.r.putAll(this.r);
        mapItemSavedData.s.putAll(this.s);
        mapItemSavedData.u = this.u;
        System.arraycopy(this.h, 0, mapItemSavedData.h, 0, this.h.length);
        return mapItemSavedData;
    }

    public WorldMap c() {
        return WorldMap.a(this.d, this.e, (byte)MathHelper.a(this.g + 1, 0, 4), this.n, this.o, this.f);
    }

    private static Predicate<ItemStack> a(ItemStack stack) {
        MapId mapId = stack.a(DataComponents.T);
        return itemStack -> itemStack == stack || itemStack.a(stack.h()) && Objects.equals(mapId, itemStack.a(DataComponents.T));
    }

    public void a(EntityHuman player, ItemStack mapStack) {
        if (!this.q.containsKey(player)) {
            WorldMapHumanTracker holdingPlayer = new WorldMapHumanTracker(player);
            this.q.put(player, holdingPlayer);
            this.p.add(holdingPlayer);
        }
        Predicate<ItemStack> predicate = WorldMap.a(mapStack);
        if (!player.gK().b(predicate)) {
            this.a(player.aq());
        }
        for (int i2 = 0; i2 < this.p.size(); ++i2) {
            WorldMapHumanTracker holdingPlayer1 = this.p.get(i2);
            EntityHuman player1 = holdingPlayer1.a;
            String plainTextName = player1.aq();
            if (!player1.eh() && (player1.gK().b(predicate) || mapStack.H())) {
                if (!mapStack.H() && player1.ao().aq() == this.f && this.n) {
                    this.a(MapDecorationTypes.a, player1.ao(), plainTextName, player1.dP(), player1.dV(), player1.ec(), null);
                }
            } else {
                this.q.remove(player1);
                this.p.remove(holdingPlayer1);
                this.a(plainTextName);
            }
            if (player1.equals(player) || !WorldMap.b(player1)) continue;
            this.a(plainTextName);
        }
        if (mapStack.H() && this.n) {
            EntityItemFrame frame = mapStack.I();
            BlockPosition pos = frame.i();
            WorldMapFrame mapFrame = this.t.get(WorldMapFrame.a(pos));
            if (mapFrame != null && frame.aA() != mapFrame.d() && this.t.containsKey(mapFrame.a())) {
                this.a(WorldMap.b(mapFrame.d()));
            }
            WorldMapFrame mapFrame1 = new WorldMapFrame(pos, frame.dg().e() * 90, frame.aA());
            if (this.s.size() < player.ao().paperConfig().maps.itemFrameCursorLimit) {
                this.a(MapDecorationTypes.b, player.ao(), WorldMap.b(frame.aA()), pos.u(), pos.w(), frame.dg().e() * 90, null);
                WorldMapFrame mapFrame2 = this.t.put(mapFrame1.a(), mapFrame1);
                if (!mapFrame1.equals(mapFrame2)) {
                    this.u();
                }
            }
        }
        MapDecorations mapDecorations = mapStack.a(DataComponents.U, MapDecorations.a);
        if (!this.s.keySet().containsAll(mapDecorations.a().keySet())) {
            mapDecorations.a().forEach((string, entry) -> {
                if (!this.s.containsKey(string)) {
                    this.a(entry.a(), player.ao(), (String)string, entry.b(), entry.c(), entry.d(), null);
                }
            });
        }
    }

    private static boolean b(EntityHuman player) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            if (equipmentSlot == EnumItemSlot.a || equipmentSlot == EnumItemSlot.b || !player.a(equipmentSlot).a(TagsItem.cO)) continue;
            return true;
        }
        return false;
    }

    private void a(String identifier) {
        MapIcon mapDecoration = this.s.remove(identifier);
        if (mapDecoration != null && mapDecoration.c().a().f()) {
            --this.u;
        }
        if (mapDecoration != null) {
            this.g();
        }
    }

    public static void a(ItemStack stack, BlockPosition pos, String type, Holder<MapDecorationType> mapDecorationType) {
        MapDecorations.a entry = new MapDecorations.a(mapDecorationType, pos.u(), pos.w(), 180.0f);
        stack.a(DataComponents.U, MapDecorations.a, mapDecorations -> mapDecorations.a(type, entry));
        if (mapDecorationType.a().a()) {
            stack.b(DataComponents.S, new MapItemColor(mapDecorationType.a().d()));
        }
    }

    private void a(Holder<MapDecorationType> decorationType, @Nullable GeneratorAccess level, String id, double x2, double z2, double yRot, @Nullable IChatBaseComponent displayName) {
        int i2 = 1 << this.g;
        float f2 = (float)(x2 - (double)this.d) / (float)i2;
        float f1 = (float)(z2 - (double)this.e) / (float)i2;
        b mapDecorationLocation = this.a(decorationType, level, yRot, f2, f1);
        if (mapDecorationLocation == null) {
            this.a(id);
        } else {
            MapIcon mapDecoration1;
            MapIcon mapDecoration = new MapIcon(mapDecorationLocation.a(), mapDecorationLocation.b(), mapDecorationLocation.c(), mapDecorationLocation.d(), Optional.ofNullable(displayName));
            if (!mapDecoration.equals(mapDecoration1 = this.s.put(id, mapDecoration))) {
                if (mapDecoration1 != null && mapDecoration1.c().a().f()) {
                    --this.u;
                }
                if (mapDecorationLocation.a().a().f()) {
                    ++this.u;
                }
                this.g();
            }
        }
    }

    private @Nullable b a(Holder<MapDecorationType> decorationType, @Nullable GeneratorAccess level, double yRot, float x2, float z2) {
        byte b2 = WorldMap.a(x2);
        byte b1 = WorldMap.a(z2);
        if (decorationType.a(MapDecorationTypes.a)) {
            Pair<Holder<MapDecorationType>, Byte> pair = this.b(decorationType, level, yRot, x2, z2);
            return pair == null ? null : new b((Holder)pair.getFirst(), b2, b1, (Byte)pair.getSecond());
        }
        return !WorldMap.a(x2, z2) && !this.o ? null : new b(decorationType, b2, b1, this.a(level, yRot));
    }

    private @Nullable Pair<Holder<MapDecorationType>, Byte> b(Holder<MapDecorationType> decorationType, @Nullable GeneratorAccess level, double yRot, float x2, float z2) {
        if (WorldMap.a(x2, z2)) {
            return Pair.of(decorationType, (Object)this.a(level, yRot));
        }
        Holder<MapDecorationType> holder = this.b(x2, z2);
        return holder == null ? null : Pair.of(holder, (Object)0);
    }

    private byte a(@Nullable GeneratorAccess level, double yRot) {
        if (this.f == World.i && level != null) {
            int i2 = (int)(level.au() / 10L);
            return (byte)(i2 * i2 * 34187121 + i2 * 121 >> 15 & 0xF);
        }
        double d2 = yRot < 0.0 ? yRot - 8.0 : yRot + 8.0;
        return (byte)(d2 * 16.0 / 360.0);
    }

    private static boolean a(float x2, float z2) {
        int i2 = 63;
        return x2 >= -63.0f && z2 >= -63.0f && x2 <= 63.0f && z2 <= 63.0f;
    }

    private @Nullable Holder<MapDecorationType> b(float x2, float z2) {
        boolean flag;
        int i2 = 320;
        boolean bl = flag = Math.abs(x2) < 320.0f && Math.abs(z2) < 320.0f;
        if (flag) {
            return MapDecorationTypes.g;
        }
        return this.o ? MapDecorationTypes.h : null;
    }

    private static byte a(float coord) {
        int i2 = 63;
        if (coord <= -63.0f) {
            return -128;
        }
        return coord >= 63.0f ? (byte)127 : (byte)((double)(coord * 2.0f) + 0.5);
    }

    public @Nullable Packet<?> a(MapId mapId, EntityHuman player) {
        WorldMapHumanTracker holdingPlayer = this.q.get(player);
        return holdingPlayer == null ? null : holdingPlayer.a(mapId);
    }

    public void a(int x2, int z2) {
        this.setColorsDirty(x2, z2, true);
    }

    public void setColorsDirty(int x2, int z2, boolean markFileDirty) {
        if (markFileDirty) {
            this.u();
        }
        for (WorldMapHumanTracker holdingPlayer : this.p) {
            holdingPlayer.a(x2, z2);
        }
    }

    public void g() {
        this.p.forEach(WorldMapHumanTracker::b);
    }

    public WorldMapHumanTracker a(EntityHuman player) {
        WorldMapHumanTracker holdingPlayer = this.q.get(player);
        if (holdingPlayer == null) {
            holdingPlayer = new WorldMapHumanTracker(player);
            this.q.put(player, holdingPlayer);
            this.p.add(holdingPlayer);
        }
        return holdingPlayer;
    }

    public boolean a(GeneratorAccess level, BlockPosition pos) {
        double d2 = (double)pos.u() + 0.5;
        double d1 = (double)pos.w() + 0.5;
        int i2 = 1 << this.g;
        double d22 = (d2 - (double)this.d) / (double)i2;
        double d3 = (d1 - (double)this.e) / (double)i2;
        int i1 = 63;
        if (d22 >= -63.0 && d3 >= -63.0 && d22 <= 63.0 && d3 <= 63.0) {
            MapIconBanner mapBanner = MapIconBanner.a(level, pos);
            if (mapBanner == null) {
                return false;
            }
            if (this.r.remove(mapBanner.b(), mapBanner)) {
                this.a(mapBanner.b());
                this.u();
                return true;
            }
            if (!this.a(((World)level).paperConfig().maps.itemFrameCursorLimit)) {
                this.r.put(mapBanner.b(), mapBanner);
                this.a(mapBanner.a(), level, mapBanner.b(), d2, d1, 180.0, mapBanner.e().orElse(null));
                this.u();
                return true;
            }
        }
        return false;
    }

    public void a(IBlockAccess level, int x2, int z2) {
        Iterator<MapIconBanner> iterator = this.r.values().iterator();
        while (iterator.hasNext()) {
            MapIconBanner mapBanner1;
            MapIconBanner mapBanner = iterator.next();
            if (mapBanner.c().u() != x2 || mapBanner.c().w() != z2 || mapBanner.equals(mapBanner1 = MapIconBanner.a(level, mapBanner.c()))) continue;
            iterator.remove();
            this.a(mapBanner.b());
            this.u();
        }
    }

    public Collection<MapIconBanner> d() {
        return this.r.values();
    }

    public void a(BlockPosition pos, int entityId) {
        this.a(WorldMap.b(entityId));
        this.t.remove(WorldMapFrame.a(pos));
        this.u();
    }

    public boolean a(int x2, int z2, byte color) {
        byte b2 = this.h[x2 + z2 * 128];
        if (b2 != color) {
            this.b(x2, z2, color);
            return true;
        }
        return false;
    }

    public void b(int x2, int z2, byte color) {
        this.h[x2 + z2 * 128] = color;
        this.a(x2, z2);
    }

    public boolean e() {
        for (MapIcon mapDecoration : this.s.values()) {
            if (!mapDecoration.c().a().e()) continue;
            return true;
        }
        return false;
    }

    public void a(List<MapIcon> decorations) {
        this.s.clear();
        this.u = 0;
        for (int i2 = 0; i2 < decorations.size(); ++i2) {
            MapIcon mapDecoration = decorations.get(i2);
            this.s.put("icon-" + i2, mapDecoration);
            if (!mapDecoration.c().a().f()) continue;
            ++this.u;
        }
    }

    public Iterable<MapIcon> f() {
        return this.s.values();
    }

    public boolean a(int trackedCount) {
        return this.u >= trackedCount;
    }

    private static String b(int entityId) {
        return m + entityId;
    }

    private UUIDBackedDimension packUUIDBackedDimension() {
        WorldServer mappedLevel = MinecraftServer.getServer().a(this.f);
        return new UUIDBackedDimension(this.f, mappedLevel == null ? null : new UUIDAndError(mappedLevel.uuid, ""));
    }

    private static MapCodec<UUIDBackedDimension> createUUIDBackedDimensionKeyCodec() {
        return new MapCodec<UUIDBackedDimension>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of("dimension", "UUIDLeast", "UUIDMost").map(arg_0 -> ops.createString(arg_0));
            }

            public <T> DataResult<UUIDBackedDimension> decode(DynamicOps<T> ops, MapLike<T> input) {
                DataResult foundDimension = World.g.decode(ops, input.get("dimension")).map(Pair::getFirst).map(UUIDBackedDimension::new);
                if (foundDimension.isSuccess()) {
                    return foundDimension;
                }
                DataResult fromUUID = Codec.LONG.decode(ops, input.get("UUIDMost")).map(Pair::getFirst).apply2(UUID::new, Codec.LONG.decode(ops, input.get("UUIDLeast")).map(Pair::getFirst)).map(uuid -> new UUIDBackedDimension(null, new UUIDAndError((UUID)uuid, String.valueOf(input.get("dimension")))));
                if (fromUUID.isSuccess()) {
                    return fromUUID;
                }
                return foundDimension;
            }

            public <T> RecordBuilder<T> encode(UUIDBackedDimension input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                prefix.add("dimension", input.resourceKey(), World.g);
                if (input.uuid != null) {
                    prefix.add("UUIDMost", (Object)input.uuid.uuid().getMostSignificantBits(), (Encoder)Codec.LONG);
                    prefix.add("UUIDLeast", (Object)input.uuid.uuid().getLeastSignificantBits(), (Encoder)Codec.LONG);
                }
                return prefix;
            }
        };
    }

    record UUIDBackedDimension(@Nullable ResourceKey<World> resourceKey, @Nullable UUIDAndError uuid) {
        public UUIDBackedDimension(@NotNull ResourceKey<World> resourceKey) {
            this(resourceKey, null);
        }

        public UUIDBackedDimension(@Nullable ResourceKey<World> resourceKey, @Nullable UUIDAndError uuid) {
            Preconditions.checkArgument((resourceKey != null || uuid != null ? 1 : 0) != 0, (Object)"Created uuid backed dimension with null level and uuid. This is a bug");
        }

        @NotNull
        public ResourceKey<World> resolveOrThrow() {
            if (this.resourceKey != null) {
                return this.resourceKey;
            }
            org.bukkit.World worldByUUID = Bukkit.getWorld((UUID)this.uuid.uuid());
            if (worldByUUID != null) {
                return ((CraftWorld)worldByUUID).getHandle().aq();
            }
            throw new IllegalArgumentException("Invalid dimension " + this.uuid.faultyDimension() + " and unknown world uuid " + String.valueOf(this.uuid.uuid));
        }
    }

    public class WorldMapHumanTracker {
        public final EntityHuman a;
        private boolean d = true;
        private int e;
        private int f;
        private int g = 127;
        private int h = 127;
        private boolean i = true;
        private int j;
        public int b;

        WorldMapHumanTracker(EntityHuman player) {
            this.a = player;
        }

        private c createPatch(byte[] buffer) {
            int i2 = this.e;
            int i1 = this.f;
            int i22 = this.g + 1 - this.e;
            int i3 = this.h + 1 - this.f;
            byte[] bytes = new byte[i22 * i3];
            for (int i4 = 0; i4 < i22; ++i4) {
                for (int i5 = 0; i5 < i3; ++i5) {
                    bytes[i4 + i5 * i22] = buffer[i2 + i4 + (i1 + i5) * 128];
                }
            }
            return new c(i2, i1, i22, i3, bytes);
        }

        @Nullable Packet<?> a(MapId mapId) {
            ArrayList<MapIcon> collection;
            c mapPatch;
            RenderData render;
            if (!this.d && this.j % 5 != 0) {
                ++this.j;
                return null;
            }
            boolean vanillaMaps = this.shouldUseVanillaMap();
            RenderData renderData = render = !vanillaMaps ? WorldMap.this.mapView.render((CraftPlayer)this.a.getBukkitEntity()) : WorldMap.this.vanillaRender;
            if (this.d) {
                this.d = false;
                mapPatch = this.createPatch(render.buffer);
            } else {
                mapPatch = null;
            }
            if ((!vanillaMaps || this.i) && this.j++ % 5 == 0) {
                this.i = false;
                ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
                if (vanillaMaps) {
                    this.addSeenPlayers(icons);
                }
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapIcon(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), Optional.ofNullable(PaperAdventure.asVanilla(cursor.caption()))));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && mapPatch == null ? null : new PacketPlayOutMap(mapId, WorldMap.this.g, WorldMap.this.i, collection, mapPatch);
        }

        void a(int x2, int z2) {
            if (this.d) {
                this.e = Math.min(this.e, x2);
                this.f = Math.min(this.f, z2);
                this.g = Math.max(this.g, x2);
                this.h = Math.max(this.h, z2);
            } else {
                this.d = true;
                this.e = x2;
                this.f = z2;
                this.g = x2;
                this.h = z2;
            }
        }

        private void b() {
            this.i = true;
        }

        private void addSeenPlayers(Collection<MapIcon> icons) {
            Player player = (Player)this.a.getBukkitEntity();
            WorldMap.this.s.forEach((name, mapIcon) -> {
                Player other = Bukkit.getPlayerExact((String)name);
                if (other == null || player.canSee(other)) {
                    icons.add((MapIcon)mapIcon);
                }
            });
        }

        private boolean shouldUseVanillaMap() {
            return WorldMap.this.mapView.getRenderers().size() == 1 && WorldMap.this.mapView.getRenderers().getFirst().getClass() == CraftMapRenderer.class;
        }
    }

    record b(Holder<MapDecorationType> a, byte b, byte c, byte d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this, o2);
        }
    }

    record UUIDAndError(UUID uuid, String faultyDimension) {
    }

    public static final class c
    extends Record {
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final byte[] f;
        public static final StreamCodec<ByteBuf, Optional<c>> a = StreamCodec.a(c::a, c::a);

        public c(int startX, int startY, int width, int height, byte[] mapColors) {
            this.b = startX;
            this.c = startY;
            this.d = width;
            this.e = height;
            this.f = mapColors;
        }

        private static void a(ByteBuf buffer, Optional<c> mapPatch) {
            if (mapPatch.isPresent()) {
                c mapPatch1 = mapPatch.get();
                buffer.writeByte(mapPatch1.d);
                buffer.writeByte(mapPatch1.e);
                buffer.writeByte(mapPatch1.b);
                buffer.writeByte(mapPatch1.c);
                PacketDataSerializer.a(buffer, mapPatch1.f);
            } else {
                buffer.writeByte(0);
            }
        }

        private static Optional<c> a(ByteBuf buffer) {
            short unsignedByte = buffer.readUnsignedByte();
            if (unsignedByte > 0) {
                short unsignedByte1 = buffer.readUnsignedByte();
                short unsignedByte2 = buffer.readUnsignedByte();
                short unsignedByte3 = buffer.readUnsignedByte();
                byte[] byteArray = PacketDataSerializer.a(buffer);
                return Optional.of(new c(unsignedByte2, unsignedByte3, unsignedByte, unsignedByte1, byteArray));
            }
            return Optional.empty();
        }

        public void a(WorldMap savedData) {
            for (int i2 = 0; i2 < this.d; ++i2) {
                for (int i1 = 0; i1 < this.e; ++i1) {
                    savedData.b(this.b + i2, this.c + i1, this.f[i2 + i1 * this.d]);
                }
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }

        public byte[] e() {
            return this.f;
        }
    }
}

