/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.MathHelper;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jspecify.annotations.Nullable;

public class IntRange {
    private static final Codec<IntRange> b = RecordCodecBuilder.create(instance -> instance.group((App)NumberProviders.a.optionalFieldOf("min").forGetter(intRange -> Optional.ofNullable(intRange.c)), (App)NumberProviders.a.optionalFieldOf("max").forGetter(intRange -> Optional.ofNullable(intRange.d))).apply((Applicative)instance, IntRange::new));
    public static final Codec<IntRange> a = Codec.either((Codec)Codec.INT, b).xmap(either -> either.map(IntRange::a, Function.identity()), intRange -> {
        OptionalInt optionalInt = intRange.b();
        return optionalInt.isPresent() ? Either.left(optionalInt.getAsInt()) : Either.right(intRange);
    });
    private final @Nullable NumberProvider c;
    private final @Nullable NumberProvider d;
    private final b e;
    private final a f;

    public Set<ContextKey<?>> a() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.c != null) {
            builder.addAll(this.c.b());
        }
        if (this.d != null) {
            builder.addAll(this.d.b());
        }
        return builder.build();
    }

    private IntRange(Optional<NumberProvider> min, Optional<NumberProvider> max) {
        this((NumberProvider)min.orElse(null), (NumberProvider)max.orElse(null));
    }

    private IntRange(@Nullable NumberProvider min, @Nullable NumberProvider max) {
        this.c = min;
        this.d = max;
        if (min == null) {
            if (max == null) {
                this.e = (lootContext, value) -> value;
                this.f = (lootContext, value) -> true;
            } else {
                this.e = (lootContext, value) -> Math.min(max.a(lootContext), value);
                this.f = (lootContext, value) -> value <= max.a(lootContext);
            }
        } else if (max == null) {
            this.e = (lootContext, value) -> Math.max(min.a(lootContext), value);
            this.f = (lootContext, value) -> value >= min.a(lootContext);
        } else {
            this.e = (lootContext, value) -> MathHelper.a(value, min.a(lootContext), max.a(lootContext));
            this.f = (lootContext, value) -> value >= min.a(lootContext) && value <= max.a(lootContext);
        }
    }

    public static IntRange a(int exactValue) {
        ConstantValue constantValue = ConstantValue.a(exactValue);
        return new IntRange(Optional.of(constantValue), Optional.of(constantValue));
    }

    public static IntRange a(int min, int max) {
        return new IntRange(Optional.of(ConstantValue.a(min)), Optional.of(ConstantValue.a(max)));
    }

    public static IntRange b(int min) {
        return new IntRange(Optional.of(ConstantValue.a(min)), Optional.empty());
    }

    public static IntRange c(int max) {
        return new IntRange(Optional.empty(), Optional.of(ConstantValue.a(max)));
    }

    public int a(LootTableInfo lootContext, int value) {
        return this.e.apply(lootContext, value);
    }

    public boolean b(LootTableInfo lootContext, int value) {
        return this.f.test(lootContext, value);
    }

    private OptionalInt b() {
        ConstantValue constantValue;
        NumberProvider numberProvider;
        return Objects.equals(this.c, this.d) && (numberProvider = this.c) instanceof ConstantValue && Math.floor((constantValue = (ConstantValue)numberProvider).c()) == (double)constantValue.c() ? OptionalInt.of((int)constantValue.c()) : OptionalInt.empty();
    }

    @FunctionalInterface
    static interface b {
        public int apply(LootTableInfo var1, int var2);
    }

    @FunctionalInterface
    static interface a {
        public boolean test(LootTableInfo var1, int var2);
    }
}

