/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootContextArg;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jspecify.annotations.Nullable;

public class LootTableInfo {
    private final LootParams a;
    private final RandomSource b;
    private final HolderGetter.a c;
    private final Set<e<?>> d = Sets.newLinkedHashSet();

    LootTableInfo(LootParams params, RandomSource random, HolderGetter.a lootDataResolver) {
        this.a = params;
        this.b = random;
        this.c = lootDataResolver;
    }

    public boolean a(ContextKey<?> parameter) {
        return this.a.b().a(parameter);
    }

    public <T> T b(ContextKey<T> parameter) {
        return this.a.b().b(parameter);
    }

    public <T> @Nullable T c(ContextKey<T> parameter) {
        return this.a.b().c(parameter);
    }

    public void a(MinecraftKey name, Consumer<ItemStack> consumer) {
        this.a.a(name, consumer);
    }

    public boolean a(e<?> element) {
        return this.d.contains(element);
    }

    public boolean b(e<?> element) {
        return this.d.add(element);
    }

    public void c(e<?> element) {
        this.d.remove(element);
    }

    public HolderGetter.a a() {
        return this.c;
    }

    public RandomSource b() {
        return this.b;
    }

    public float c() {
        return this.a.c();
    }

    public WorldServer d() {
        return this.a.a();
    }

    public static e<LootTable> a(LootTable lootTable) {
        return new e<LootTable>(LootDataType.c, lootTable);
    }

    public static e<LootItemCondition> a(LootItemCondition predicate) {
        return new e<LootItemCondition>(LootDataType.a, predicate);
    }

    public static e<LootItemFunction> a(LootItemFunction modifier) {
        return new e<LootItemFunction>(LootDataType.b, modifier);
    }

    public record e<T>(LootDataType<T> a, T b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "type;value", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "type;value", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "type;value", "a", "b"}, this, o2);
        }
    }

    public static final class d
    extends Enum<d>
    implements INamable,
    LootContextArg.c<ItemStack> {
        public static final /* enum */ d a = new d("tool", LootContextParameters.k);
        private final String b;
        private final ContextKey<? extends ItemStack> c;
        private static final /* synthetic */ d[] d;

        public static d[] values() {
            return (d[])d.clone();
        }

        public static d valueOf(String name) {
            return Enum.valueOf(d.class, name);
        }

        private d(String name, ContextKey<? extends ItemStack> param) {
            this.b = name;
            this.c = param;
        }

        @Override
        public ContextKey<? extends ItemStack> a() {
            return this.c;
        }

        @Override
        public String c() {
            return this.b;
        }

        private static /* synthetic */ d[] b() {
            return new d[]{a};
        }

        static {
            d = net.minecraft.world.level.storage.loot.LootTableInfo$d.b();
        }
    }

    public static final class EntityTarget
    extends Enum<EntityTarget>
    implements INamable,
    LootContextArg.c<Entity> {
        public static final /* enum */ EntityTarget a = new EntityTarget("this", LootContextParameters.a);
        public static final /* enum */ EntityTarget b = new EntityTarget("attacker", LootContextParameters.f);
        public static final /* enum */ EntityTarget c = new EntityTarget("direct_attacker", LootContextParameters.g);
        public static final /* enum */ EntityTarget d = new EntityTarget("attacking_player", LootContextParameters.d);
        public static final /* enum */ EntityTarget e = new EntityTarget("target_entity", LootContextParameters.c);
        public static final /* enum */ EntityTarget f = new EntityTarget("interacting_entity", LootContextParameters.b);
        public static final INamable.a<EntityTarget> g;
        private final String i;
        private final ContextKey<? extends Entity> j;
        private static final /* synthetic */ EntityTarget[] k;

        public static EntityTarget[] values() {
            return (EntityTarget[])k.clone();
        }

        public static EntityTarget valueOf(String name) {
            return Enum.valueOf(EntityTarget.class, name);
        }

        private EntityTarget(String name, ContextKey<? extends Entity> param) {
            this.i = name;
            this.j = param;
        }

        @Override
        public ContextKey<? extends Entity> a() {
            return this.j;
        }

        public static EntityTarget a(String name) {
            EntityTarget entityTarget = g.a(name);
            if (entityTarget != null) {
                return entityTarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + name);
        }

        @Override
        public String c() {
            return this.i;
        }

        private static /* synthetic */ EntityTarget[] b() {
            return new EntityTarget[]{a, b, c, d, e, f};
        }

        static {
            k = EntityTarget.b();
            g = INamable.a(EntityTarget::values);
        }
    }

    public static class Builder {
        private final LootParams a;
        private @Nullable RandomSource b;

        public Builder(LootParams params) {
            this.a = params;
        }

        public Builder a(long seed) {
            if (seed != 0L) {
                this.b = RandomSource.a(seed);
            }
            return this;
        }

        public Builder a(RandomSource random) {
            this.b = random;
            return this;
        }

        public WorldServer a() {
            return this.a.a();
        }

        public LootTableInfo a(Optional<MinecraftKey> sequence) {
            WorldServer level = this.a();
            MinecraftServer server = level.s();
            RandomSource randomSource = Optional.ofNullable(this.b).or(() -> sequence.map(level::a)).orElseGet(level::G_);
            return new LootTableInfo(this.a, randomSource, server.be().a());
        }
    }

    public static final class a
    extends Enum<a>
    implements INamable,
    LootContextArg.c<TileEntity> {
        public static final /* enum */ a a = new a("block_entity", LootContextParameters.j);
        private final String b;
        private final ContextKey<? extends TileEntity> c;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(String name, ContextKey<? extends TileEntity> param) {
            this.b = name;
            this.c = param;
        }

        @Override
        public ContextKey<? extends TileEntity> a() {
            return this.c;
        }

        @Override
        public String c() {
            return this.b;
        }

        private static /* synthetic */ a[] b() {
            return new a[]{a};
        }

        static {
            d = net.minecraft.world.level.storage.loot.LootTableInfo$a.b();
        }
    }
}

