/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class LootSelectorEntry
extends LootEntryAbstract {
    public static final int b = 1;
    public static final int e = 0;
    protected final int f;
    protected final int h;
    protected final List<LootItemFunction> i;
    final BiFunction<ItemStack, LootTableInfo, ItemStack> a;
    private final LootEntry j = new c(){

        @Override
        public void a(Consumer<ItemStack> stackConsumer, LootTableInfo lootContext) {
            LootSelectorEntry.this.a(LootItemFunction.a(LootSelectorEntry.this.a, stackConsumer, lootContext), lootContext);
        }
    };
    private Float lastLuck;
    private int lastWeight;

    protected LootSelectorEntry(int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(conditions);
        this.f = weight;
        this.h = quality;
        this.i = functions;
        this.a = LootItemFunctions.a(functions);
    }

    protected static <T extends LootSelectorEntry> Products.P4<RecordCodecBuilder.Mu<T>, Integer, Integer, List<LootItemCondition>, List<LootItemFunction>> b(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(container -> container.f), (App)Codec.INT.optionalFieldOf("quality", (Object)0).forGetter(lootPoolSingletonContainer -> lootPoolSingletonContainer.h)).and(LootSelectorEntry.a(instance).t1()).and((App)LootItemFunctions.c.listOf().optionalFieldOf("functions", List.of()).forGetter(container -> container.i));
    }

    @Override
    public void a(LootCollector validationContext) {
        super.a(validationContext);
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            this.i.get(i2).a(validationContext.a(new ProblemReporter.d("functions", i2)));
        }
    }

    protected abstract void a(Consumer<ItemStack> var1, LootTableInfo var2);

    @Override
    public boolean expand(LootTableInfo lootContext, Consumer<LootEntry> entryConsumer) {
        if (this.a(lootContext)) {
            entryConsumer.accept(this.j);
            return true;
        }
        return false;
    }

    public static a<?> a(d entryBuilder) {
        return new b(entryBuilder);
    }

    static class b
    extends a<b> {
        private final d c;

        public b(d constructor) {
            this.c = constructor;
        }

        protected b g() {
            return this;
        }

        @Override
        public LootEntryAbstract b() {
            return this.c.build(this.a, this.b, this.f(), this.a());
        }
    }

    @FunctionalInterface
    protected static interface d {
        public LootSelectorEntry build(int var1, int var2, List<LootItemCondition> var3, List<LootItemFunction> var4);
    }

    protected abstract class c
    implements LootEntry {
        protected c() {
        }

        @Override
        public int a(float luck) {
            if (LootSelectorEntry.this.lastLuck != null && LootSelectorEntry.this.lastLuck.floatValue() == luck) {
                return LootSelectorEntry.this.lastWeight;
            }
            float qualityModifer = (float)LootSelectorEntry.this.h * luck;
            double baseWeight = (float)LootSelectorEntry.this.f + qualityModifer;
            if (GlobalConfiguration.get().misc.useAlternativeLuckFormula) {
                int weightBoost = 100;
                double impacted = (baseWeight *= 100.0) * ((baseWeight - 100.0) / 100.0 / 100.0);
                float luckModifier = Math.min(100.0f, luck * 10.0f) / 100.0f;
                baseWeight = Math.ceil(baseWeight - impacted * (double)luckModifier);
            }
            LootSelectorEntry.this.lastLuck = Float.valueOf(luck);
            LootSelectorEntry.this.lastWeight = (int)Math.max(Math.floor(baseWeight), 0.0);
            return LootSelectorEntry.this.lastWeight;
        }
    }

    public static abstract class a<T extends a<T>>
    extends LootEntryAbstract.a<T>
    implements LootItemFunctionUser<T> {
        protected int a = 1;
        protected int b = 0;
        private final ImmutableList.Builder<LootItemFunction> c = ImmutableList.builder();

        public T a(LootItemFunction.a functionBuilder) {
            this.c.add((Object)functionBuilder.b());
            return (T)((a)this.aH_());
        }

        protected List<LootItemFunction> a() {
            return this.c.build();
        }

        public T a(int weight) {
            this.a = weight;
            return (T)((a)this.aH_());
        }

        public T b(int quality) {
            this.b = quality;
            return (T)((a)this.aH_());
        }
    }
}

