/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionApplyBonus
extends LootItemFunctionConditional {
    private static final Map<MinecraftKey, c> b = Stream.of(net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus$a.a, net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus$d.c, net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus$e.b).collect(Collectors.toMap(c::a, Function.identity()));
    private static final Codec<c> c = MinecraftKey.a.comapFlatMap(identifier -> {
        c formulaType = b.get(identifier);
        return formulaType != null ? DataResult.success((Object)formulaType) : DataResult.error(() -> "No formula type with id: '" + String.valueOf(identifier) + "'");
    }, c::a);
    private static final MapCodec<b> d = ExtraCodecs.a("formula", "parameters", c, b::a, c::b);
    public static final MapCodec<LootItemFunctionApplyBonus> a = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionApplyBonus.a(instance).and(instance.group((App)Enchantment.c.fieldOf("enchantment").forGetter(applyBonusCount -> applyBonusCount.e), (App)d.forGetter(applyBonusCount -> applyBonusCount.f))).apply((Applicative)instance, LootItemFunctionApplyBonus::new));
    private final Holder<Enchantment> e;
    private final b f;

    private LootItemFunctionApplyBonus(List<LootItemCondition> predicates, Holder<Enchantment> enchantment, b formula) {
        super(predicates);
        this.e = enchantment;
        this.f = formula;
    }

    public LootItemFunctionType<LootItemFunctionApplyBonus> a() {
        return LootItemFunctions.x;
    }

    @Override
    public Set<ContextKey<?>> b() {
        return Set.of(LootContextParameters.k);
    }

    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        ItemStack itemStack = context.c(LootContextParameters.k);
        if (itemStack != null) {
            int itemEnchantmentLevel = EnchantmentManager.a(this.e, itemStack);
            int i2 = this.f.a(context.b(), stack.N(), itemEnchantmentLevel);
            stack.e(i2);
        }
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(Holder<Enchantment> enchantment, float probability, int extraRounds) {
        return LootItemFunctionApplyBonus.a((List<LootItemCondition> list) -> new LootItemFunctionApplyBonus((List<LootItemCondition>)list, enchantment, new a(extraRounds, probability)));
    }

    public static LootItemFunctionConditional.a<?> a(Holder<Enchantment> enchantment) {
        return LootItemFunctionApplyBonus.a((List<LootItemCondition> list) -> new LootItemFunctionApplyBonus((List<LootItemCondition>)list, enchantment, net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus$d.a));
    }

    public static LootItemFunctionConditional.a<?> b(Holder<Enchantment> enchantment) {
        return LootItemFunctionApplyBonus.a((List<LootItemCondition> list) -> new LootItemFunctionApplyBonus((List<LootItemCondition>)list, enchantment, new e(1)));
    }

    public static LootItemFunctionConditional.a<?> a(Holder<Enchantment> enchantment, int bonusMultiplier) {
        return LootItemFunctionApplyBonus.a((List<LootItemCondition> list) -> new LootItemFunctionApplyBonus((List<LootItemCondition>)list, enchantment, new e(bonusMultiplier)));
    }

    static interface b {
        public int a(RandomSource var1, int var2, int var3);

        public c a();
    }

    static final class e
    extends Record
    implements b {
        private final int c;
        public static final Codec<e> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("bonusMultiplier").forGetter(e::b)).apply((Applicative)instance, e::new));
        public static final c b = new c(MinecraftKey.b("uniform_bonus_count"), a);

        e(int bonusMultiplier) {
            this.c = bonusMultiplier;
        }

        @Override
        public int a(RandomSource random, int originalCount, int enchantmentLevel) {
            return originalCount + random.a(this.c * enchantmentLevel + 1);
        }

        @Override
        public c a() {
            return b;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "bonusMultiplier", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "bonusMultiplier", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "bonusMultiplier", "c"}, this, o2);
        }

        public int b() {
            return this.c;
        }
    }

    record d() implements b
    {
        public static final d a = new d();
        public static final Codec<d> b = MapCodec.unitCodec((Object)a);
        public static final c c = new c(MinecraftKey.b("ore_drops"), b);

        @Override
        public int a(RandomSource random, int originalCount, int enchantmentLevel) {
            if (enchantmentLevel > 0) {
                int i2 = random.a(enchantmentLevel + 2) - 1;
                if (i2 < 0) {
                    i2 = 0;
                }
                return originalCount * (i2 + 1);
            }
            return originalCount;
        }

        @Override
        public c a() {
            return c;
        }
    }

    record a(int b, float c) implements b
    {
        private static final Codec<a> d = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("extra").forGetter(a::b), (App)Codec.FLOAT.fieldOf("probability").forGetter(a::c)).apply((Applicative)instance, a::new));
        public static final c a = new c(MinecraftKey.b("binomial_with_bonus_count"), d);

        @Override
        public int a(RandomSource random, int originalCount, int enchantmentLevel) {
            for (int i2 = 0; i2 < enchantmentLevel + this.b; ++i2) {
                if (!(random.i() < this.c)) continue;
                ++originalCount;
            }
            return originalCount;
        }

        @Override
        public c a() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "extraRounds;probability", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "extraRounds;probability", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "extraRounds;probability", "b", "c"}, this, o2);
        }
    }

    record c(MinecraftKey a, Codec<? extends b> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "id;codec", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "id;codec", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "id;codec", "a", "b"}, this, o2);
        }
    }
}

