/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.util.INamable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class LootItemFunctionSetName
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final MapCodec<LootItemFunctionSetName> a = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionSetName.a(instance).and(instance.group((App)ComponentSerialization.a.optionalFieldOf("name").forGetter(setNameFunction -> setNameFunction.c), (App)LootTableInfo.EntityTarget.g.optionalFieldOf("entity").forGetter(setNameFunction -> setNameFunction.d), (App)net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName$a.c.optionalFieldOf("target", (Object)net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName$a.a).forGetter(setNameFunction -> setNameFunction.e))).apply((Applicative)instance, LootItemFunctionSetName::new));
    private final Optional<IChatBaseComponent> c;
    private final Optional<LootTableInfo.EntityTarget> d;
    private final a e;

    private LootItemFunctionSetName(List<LootItemCondition> predicates, Optional<IChatBaseComponent> name, Optional<LootTableInfo.EntityTarget> resolutionContext, a target) {
        super(predicates);
        this.c = name;
        this.d = resolutionContext;
        this.e = target;
    }

    public LootItemFunctionType<LootItemFunctionSetName> a() {
        return LootItemFunctions.p;
    }

    @Override
    public Set<ContextKey<?>> b() {
        return this.d.map(entityTarget -> Set.of(entityTarget.a())).orElse(Set.of());
    }

    public static UnaryOperator<IChatBaseComponent> a(LootTableInfo lootContext, @Nullable LootTableInfo.EntityTarget resolutionContext) {
        Entity entity;
        if (resolutionContext != null && (entity = lootContext.c(resolutionContext.a())) != null) {
            CommandListenerWrapper commandSourceStack = entity.d(lootContext.d()).a(LevelBasedPermissionSet.c);
            return component -> {
                try {
                    return ChatComponentUtils.a(commandSourceStack, component, entity, 0);
                }
                catch (CommandSyntaxException var4) {
                    b.warn("Failed to resolve text component", (Throwable)var4);
                    return component;
                }
            };
        }
        return component -> component;
    }

    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        this.c.ifPresent(component -> stack.b(this.e.a(), (IChatBaseComponent)LootItemFunctionSetName.a(context, this.d.orElse(null)).apply((IChatBaseComponent)component)));
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(IChatBaseComponent name, a target) {
        return LootItemFunctionSetName.a((List<LootItemCondition> list) -> new LootItemFunctionSetName((List<LootItemCondition>)list, Optional.of(name), Optional.empty(), target));
    }

    public static LootItemFunctionConditional.a<?> a(IChatBaseComponent name, a target, LootTableInfo.EntityTarget resolutionContext) {
        return LootItemFunctionSetName.a((List<LootItemCondition> list) -> new LootItemFunctionSetName((List<LootItemCondition>)list, Optional.of(name), Optional.of(resolutionContext), target));
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a a = new a("custom_name");
        public static final /* enum */ a b = new a("item_name");
        public static final Codec<a> c;
        private final String d;
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(String name) {
            this.d = name;
        }

        @Override
        public String c() {
            return this.d;
        }

        public DataComponentType<IChatBaseComponent> a() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> DataComponents.h;
                case 1 -> DataComponents.k;
            };
        }

        private static /* synthetic */ a[] b() {
            return new a[]{a, b};
        }

        static {
            e = net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName$a.b();
            c = INamable.a(a::values);
        }
    }
}

