/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;

public record LootItemConditionEntityScore(Map<String, IntRange> b, LootTableInfo.EntityTarget c) implements LootItemCondition
{
    private final Map<String, IntRange> b;
    private final LootTableInfo.EntityTarget c;
    public static final MapCodec<LootItemConditionEntityScore> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, IntRange.a).fieldOf("scores").forGetter(LootItemConditionEntityScore::c), (App)LootTableInfo.EntityTarget.g.fieldOf("entity").forGetter(LootItemConditionEntityScore::d)).apply((Applicative)instance, LootItemConditionEntityScore::new));

    @Override
    public LootItemConditionType a() {
        return LootItemConditions.h;
    }

    @Override
    public Set<ContextKey<?>> b() {
        return (Set)Stream.concat(Stream.of(this.c.a()), this.b.values().stream().flatMap(intRange -> intRange.a().stream())).collect(ImmutableSet.toImmutableSet());
    }

    public boolean a(LootTableInfo context) {
        Entity entity = context.c(this.c.a());
        if (entity == null) {
            return false;
        }
        ScoreboardServer scoreboard = context.d().i();
        for (Map.Entry<String, IntRange> entry : this.b.entrySet()) {
            if (this.a(context, entity, scoreboard, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean a(LootTableInfo lootContext, Entity targetEntity, Scoreboard scoreboard, String objectiveName, IntRange scoreRange) {
        ScoreboardObjective objective = scoreboard.a(objectiveName);
        if (objective == null) {
            return false;
        }
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.d(targetEntity, objective);
        return playerScoreInfo != null && scoreRange.b(lootContext, playerScoreInfo.a());
    }

    public static a a(LootTableInfo.EntityTarget entityTarget) {
        return new a(entityTarget);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LootItemConditionEntityScore.class, "scores;entityTarget", "b", "c"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LootItemConditionEntityScore.class, "scores;entityTarget", "b", "c"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LootItemConditionEntityScore.class, "scores;entityTarget", "b", "c"}, this, o2);
    }

    public Map<String, IntRange> c() {
        return this.b;
    }

    public LootTableInfo.EntityTarget d() {
        return this.c;
    }

    public static class a
    implements LootItemCondition.a {
        private final ImmutableMap.Builder<String, IntRange> a = ImmutableMap.builder();
        private final LootTableInfo.EntityTarget b;

        public a(LootTableInfo.EntityTarget entityTarget) {
            this.b = entityTarget;
        }

        public a a(String objectiveName, IntRange scoreRange) {
            this.a.put((Object)objectiveName, (Object)scoreRange);
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new LootItemConditionEntityScore((Map<String, IntRange>)this.a.build(), this.b);
        }
    }
}

