/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.validation;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class PathAllowList
implements PathMatcher {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "#";
    private final List<a> c;
    private final Map<String, PathMatcher> d = new ConcurrentHashMap<String, PathMatcher>();

    public PathAllowList(List<a> entries) {
        this.c = entries;
    }

    public PathMatcher a(FileSystem fileSystem) {
        return this.d.computeIfAbsent(fileSystem.provider().getScheme(), key -> {
            List<PathMatcher> list;
            try {
                list = this.c.stream().map(configEntry -> configEntry.a(fileSystem)).toList();
            }
            catch (Exception var5) {
                a.error("Failed to compile file pattern list", (Throwable)var5);
                return path -> false;
            }
            return switch (list.size()) {
                case 0 -> path -> false;
                case 1 -> list.get(0);
                default -> path -> {
                    for (PathMatcher pathMatcher : list) {
                        if (!pathMatcher.matches(path)) continue;
                        return true;
                    }
                    return false;
                };
            };
        });
    }

    @Override
    public boolean matches(Path path) {
        return this.a(path.getFileSystem()).matches(path);
    }

    public static PathAllowList a(BufferedReader reader) {
        return new PathAllowList(reader.lines().flatMap(line -> net.minecraft.world.level.validation.PathAllowList$a.a(line).stream()).toList());
    }

    public record a(b a, String b) {
        public PathMatcher a(FileSystem fileSystem) {
            return this.a().compile(fileSystem, this.b);
        }

        static Optional<a> a(String string) {
            if (string.isBlank() || string.startsWith(PathAllowList.b)) {
                return Optional.empty();
            }
            if (!string.startsWith("[")) {
                return Optional.of(new a(net.minecraft.world.level.validation.PathAllowList$b.b, string));
            }
            int index = string.indexOf(93, 1);
            if (index == -1) {
                throw new IllegalArgumentException("Unterminated type in line '" + string + "'");
            }
            String sub = string.substring(1, index);
            String sub1 = string.substring(index + 1);
            return switch (sub) {
                case "glob", "regex" -> Optional.of(new a(net.minecraft.world.level.validation.PathAllowList$b.a, sub + ":" + sub1));
                case "prefix" -> Optional.of(new a(net.minecraft.world.level.validation.PathAllowList$b.b, sub1));
                default -> throw new IllegalArgumentException("Unsupported definition type in line '" + string + "'");
            };
        }

        static a b(String glob) {
            return new a(net.minecraft.world.level.validation.PathAllowList$b.a, "glob:" + glob);
        }

        static a c(String regex) {
            return new a(net.minecraft.world.level.validation.PathAllowList$b.a, "regex:" + regex);
        }

        static a d(String prefix) {
            return new a(net.minecraft.world.level.validation.PathAllowList$b.b, prefix);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;pattern", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;pattern", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;pattern", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface b {
        public static final b a = FileSystem::getPathMatcher;
        public static final b b = (fileSystem, pattern) -> path -> path.toString().startsWith(pattern);

        public PathMatcher compile(FileSystem var1, String var2);
    }
}

