/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class AxisAlignedBB {
    private static final double g = 1.0E-7;
    public final double a;
    public final double b;
    public final double c;
    public final double d;
    public final double e;
    public final double f;

    public AxisAlignedBB(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.a = Math.min(x1, x2);
        this.b = Math.min(y1, y2);
        this.c = Math.min(z1, z2);
        this.d = Math.max(x1, x2);
        this.e = Math.max(y1, y2);
        this.f = Math.max(z1, z2);
    }

    public AxisAlignedBB(BlockPosition pos) {
        this(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1);
    }

    public AxisAlignedBB(Vec3D start, Vec3D end) {
        this(start.g, start.h, start.i, end.g, end.h, end.i);
    }

    public static AxisAlignedBB a(StructureBoundingBox mutableBox) {
        return new AxisAlignedBB(mutableBox.h(), mutableBox.i(), mutableBox.j(), mutableBox.k() + 1, mutableBox.l() + 1, mutableBox.m() + 1);
    }

    public static AxisAlignedBB a(Vec3D vector) {
        return new AxisAlignedBB(vector.g, vector.h, vector.i, vector.g + 1.0, vector.h + 1.0, vector.i + 1.0);
    }

    public static AxisAlignedBB a(BlockPosition startPos, BlockPosition endPos) {
        return new AxisAlignedBB(Math.min(startPos.u(), endPos.u()), Math.min(startPos.v(), endPos.v()), Math.min(startPos.w(), endPos.w()), Math.max(startPos.u(), endPos.u()) + 1, Math.max(startPos.v(), endPos.v()) + 1, Math.max(startPos.w(), endPos.w()) + 1);
    }

    public AxisAlignedBB a(double minX) {
        return new AxisAlignedBB(minX, this.b, this.c, this.d, this.e, this.f);
    }

    public AxisAlignedBB b(double minY) {
        return new AxisAlignedBB(this.a, minY, this.c, this.d, this.e, this.f);
    }

    public AxisAlignedBB c(double minZ) {
        return new AxisAlignedBB(this.a, this.b, minZ, this.d, this.e, this.f);
    }

    public AxisAlignedBB d(double maxX) {
        return new AxisAlignedBB(this.a, this.b, this.c, maxX, this.e, this.f);
    }

    public AxisAlignedBB e(double maxY) {
        return new AxisAlignedBB(this.a, this.b, this.c, this.d, maxY, this.f);
    }

    public AxisAlignedBB f(double maxZ) {
        return new AxisAlignedBB(this.a, this.b, this.c, this.d, this.e, maxZ);
    }

    public double a(EnumDirection.EnumAxis axis) {
        return axis.a(this.a, this.b, this.c);
    }

    public double b(EnumDirection.EnumAxis axis) {
        return axis.a(this.d, this.e, this.f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof AxisAlignedBB)) return false;
        AxisAlignedBB aabb = (AxisAlignedBB)other;
        if (Double.compare(aabb.a, this.a) != 0) return false;
        if (Double.compare(aabb.b, this.b) != 0) return false;
        if (Double.compare(aabb.c, this.c) != 0) return false;
        if (Double.compare(aabb.d, this.d) != 0) return false;
        if (Double.compare(aabb.e, this.e) != 0) return false;
        if (Double.compare(aabb.f, this.f) != 0) return false;
        return true;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.a);
        int i2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.b);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.c);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.d);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.e);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.f);
        return 31 * i2 + (int)(l2 ^ l2 >>> 32);
    }

    public AxisAlignedBB a(double x2, double y2, double z2) {
        double d2 = this.a;
        double d1 = this.b;
        double d22 = this.c;
        double d3 = this.d;
        double d4 = this.e;
        double d5 = this.f;
        if (x2 < 0.0) {
            d2 -= x2;
        } else if (x2 > 0.0) {
            d3 -= x2;
        }
        if (y2 < 0.0) {
            d1 -= y2;
        } else if (y2 > 0.0) {
            d4 -= y2;
        }
        if (z2 < 0.0) {
            d22 -= z2;
        } else if (z2 > 0.0) {
            d5 -= z2;
        }
        return new AxisAlignedBB(d2, d1, d22, d3, d4, d5);
    }

    public AxisAlignedBB b(Vec3D vector) {
        return this.b(vector.g, vector.h, vector.i);
    }

    public AxisAlignedBB b(double x2, double y2, double z2) {
        double d2 = this.a;
        double d1 = this.b;
        double d22 = this.c;
        double d3 = this.d;
        double d4 = this.e;
        double d5 = this.f;
        if (x2 < 0.0) {
            d2 += x2;
        } else if (x2 > 0.0) {
            d3 += x2;
        }
        if (y2 < 0.0) {
            d1 += y2;
        } else if (y2 > 0.0) {
            d4 += y2;
        }
        if (z2 < 0.0) {
            d22 += z2;
        } else if (z2 > 0.0) {
            d5 += z2;
        }
        return new AxisAlignedBB(d2, d1, d22, d3, d4, d5);
    }

    public AxisAlignedBB c(double x2, double y2, double z2) {
        double d2 = this.a - x2;
        double d1 = this.b - y2;
        double d22 = this.c - z2;
        double d3 = this.d + x2;
        double d4 = this.e + y2;
        double d5 = this.f + z2;
        return new AxisAlignedBB(d2, d1, d22, d3, d4, d5);
    }

    public AxisAlignedBB g(double value) {
        return this.c(value, value, value);
    }

    public AxisAlignedBB a(AxisAlignedBB other) {
        double max = Math.max(this.a, other.a);
        double max1 = Math.max(this.b, other.b);
        double max2 = Math.max(this.c, other.c);
        double min = Math.min(this.d, other.d);
        double min1 = Math.min(this.e, other.e);
        double min2 = Math.min(this.f, other.f);
        return new AxisAlignedBB(max, max1, max2, min, min1, min2);
    }

    public AxisAlignedBB b(AxisAlignedBB other) {
        double min = Math.min(this.a, other.a);
        double min1 = Math.min(this.b, other.b);
        double min2 = Math.min(this.c, other.c);
        double max = Math.max(this.d, other.d);
        double max1 = Math.max(this.e, other.e);
        double max2 = Math.max(this.f, other.f);
        return new AxisAlignedBB(min, min1, min2, max, max1, max2);
    }

    public AxisAlignedBB d(double x2, double y2, double z2) {
        return new AxisAlignedBB(this.a + x2, this.b + y2, this.c + z2, this.d + x2, this.e + y2, this.f + z2);
    }

    public AxisAlignedBB a(BlockPosition pos) {
        return new AxisAlignedBB(this.a + (double)pos.u(), this.b + (double)pos.v(), this.c + (double)pos.w(), this.d + (double)pos.u(), this.e + (double)pos.v(), this.f + (double)pos.w());
    }

    public AxisAlignedBB c(Vec3D vec) {
        return this.d(vec.g, vec.h, vec.i);
    }

    public AxisAlignedBB a(Vector3f vec) {
        return this.d(vec.x, vec.y, vec.z);
    }

    public boolean c(AxisAlignedBB other) {
        return this.a(other.a, other.b, other.c, other.d, other.e, other.f);
    }

    public boolean a(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.a < x2 && this.d > x1 && this.b < y2 && this.e > y1 && this.c < z2 && this.f > z1;
    }

    public boolean a(Vec3D min, Vec3D max) {
        return this.a(Math.min(min.g, max.g), Math.min(min.h, max.h), Math.min(min.i, max.i), Math.max(min.g, max.g), Math.max(min.h, max.h), Math.max(min.i, max.i));
    }

    public boolean b(BlockPosition pos) {
        return this.a(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1);
    }

    public boolean d(Vec3D vec) {
        return this.e(vec.g, vec.h, vec.i);
    }

    public boolean e(double x2, double y2, double z2) {
        return x2 >= this.a && x2 < this.d && y2 >= this.b && y2 < this.e && z2 >= this.c && z2 < this.f;
    }

    public double a() {
        double xsize = this.b();
        double ysize = this.c();
        double zsize = this.d();
        return (xsize + ysize + zsize) / 3.0;
    }

    public double b() {
        return this.d - this.a;
    }

    public double c() {
        return this.e - this.b;
    }

    public double d() {
        return this.f - this.c;
    }

    public AxisAlignedBB f(double x2, double y2, double z2) {
        return this.c(-x2, -y2, -z2);
    }

    public AxisAlignedBB h(double value) {
        return this.g(-value);
    }

    public Optional<Vec3D> b(Vec3D from, Vec3D to) {
        return AxisAlignedBB.a(this.a, this.b, this.c, this.d, this.e, this.f, from, to);
    }

    public static Optional<Vec3D> a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vec3D from, Vec3D to) {
        double[] doubles = new double[]{1.0};
        double d2 = to.g - from.g;
        double d1 = to.h - from.h;
        double d22 = to.i - from.i;
        EnumDirection direction = AxisAlignedBB.a(minX, minY, minZ, maxX, maxY, maxZ, from, doubles, null, d2, d1, d22);
        if (direction == null) {
            return Optional.empty();
        }
        double d3 = doubles[0];
        return Optional.of(from.b(d3 * d2, d3 * d1, d3 * d22));
    }

    public static @Nullable MovingObjectPositionBlock a(Iterable<AxisAlignedBB> boxes, Vec3D start, Vec3D end, BlockPosition pos) {
        double[] doubles = new double[]{1.0};
        EnumDirection direction = null;
        double d2 = end.g - start.g;
        double d1 = end.h - start.h;
        double d22 = end.i - start.i;
        for (AxisAlignedBB aabb : boxes) {
            direction = AxisAlignedBB.a(aabb.a(pos), start, doubles, direction, d2, d1, d22);
        }
        if (direction == null) {
            return null;
        }
        double d3 = doubles[0];
        return new MovingObjectPositionBlock(start.b(d3 * d2, d3 * d1, d3 * d22), direction, pos, false);
    }

    public static @Nullable EnumDirection a(AxisAlignedBB aabb, Vec3D start, double[] minDistance, @Nullable EnumDirection facing, double deltaX, double deltaY, double deltaZ) {
        return AxisAlignedBB.a(aabb.a, aabb.b, aabb.c, aabb.d, aabb.e, aabb.f, start, minDistance, facing, deltaX, deltaY, deltaZ);
    }

    private static @Nullable EnumDirection a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vec3D start, double[] minDistance, @Nullable EnumDirection facing, double deltaX, double deltaY, double deltaZ) {
        if (deltaX > 1.0E-7) {
            facing = AxisAlignedBB.a(minDistance, facing, deltaX, deltaY, deltaZ, minX, minY, maxY, minZ, maxZ, EnumDirection.e, start.g, start.h, start.i);
        } else if (deltaX < -1.0E-7) {
            facing = AxisAlignedBB.a(minDistance, facing, deltaX, deltaY, deltaZ, maxX, minY, maxY, minZ, maxZ, EnumDirection.f, start.g, start.h, start.i);
        }
        if (deltaY > 1.0E-7) {
            facing = AxisAlignedBB.a(minDistance, facing, deltaY, deltaZ, deltaX, minY, minZ, maxZ, minX, maxX, EnumDirection.a, start.h, start.i, start.g);
        } else if (deltaY < -1.0E-7) {
            facing = AxisAlignedBB.a(minDistance, facing, deltaY, deltaZ, deltaX, maxY, minZ, maxZ, minX, maxX, EnumDirection.b, start.h, start.i, start.g);
        }
        if (deltaZ > 1.0E-7) {
            facing = AxisAlignedBB.a(minDistance, facing, deltaZ, deltaX, deltaY, minZ, minX, maxX, minY, maxY, EnumDirection.c, start.i, start.g, start.h);
        } else if (deltaZ < -1.0E-7) {
            facing = AxisAlignedBB.a(minDistance, facing, deltaZ, deltaX, deltaY, maxZ, minX, maxX, minY, maxY, EnumDirection.d, start.i, start.g, start.h);
        }
        return facing;
    }

    private static @Nullable EnumDirection a(double[] minDistance, @Nullable EnumDirection prevDirection, double distanceSide, double distanceOtherA, double distanceOtherB, double minSide, double minOtherA, double maxOtherA, double minOtherB, double maxOtherB, EnumDirection hitSide, double startSide, double startOtherA, double startOtherB) {
        double d2 = (minSide - startSide) / distanceSide;
        double d1 = startOtherA + d2 * distanceOtherA;
        double d22 = startOtherB + d2 * distanceOtherB;
        if (0.0 < d2 && d2 < minDistance[0] && minOtherA - 1.0E-7 < d1 && d1 < maxOtherA + 1.0E-7 && minOtherB - 1.0E-7 < d22 && d22 < maxOtherB + 1.0E-7) {
            minDistance[0] = d2;
            return hitSide;
        }
        return prevDirection;
    }

    public boolean a(Vec3D vector, List<AxisAlignedBB> boxes) {
        Vec3D center = this.f();
        Vec3D vec3 = center.e(vector);
        for (AxisAlignedBB aabb : boxes) {
            AxisAlignedBB aabb1 = aabb.c(this.b() * 0.5 - 1.0E-7, this.c() * 0.5 - 1.0E-7, this.d() * 0.5 - 1.0E-7);
            if (aabb1.d(vec3) || aabb1.d(center)) {
                return true;
            }
            if (!aabb1.b(center, vec3).isPresent()) continue;
            return true;
        }
        return false;
    }

    public double e(Vec3D vec) {
        double max = Math.max(Math.max(this.a - vec.g, vec.g - this.d), 0.0);
        double max1 = Math.max(Math.max(this.b - vec.h, vec.h - this.e), 0.0);
        double max2 = Math.max(Math.max(this.c - vec.i, vec.i - this.f), 0.0);
        return MathHelper.f(max, max1, max2);
    }

    public double d(AxisAlignedBB box) {
        double max = Math.max(Math.max(this.a - box.d, box.a - this.d), 0.0);
        double max1 = Math.max(Math.max(this.b - box.e, box.b - this.e), 0.0);
        double max2 = Math.max(Math.max(this.c - box.f, box.c - this.f), 0.0);
        return MathHelper.f(max, max1, max2);
    }

    public String toString() {
        return "AABB[" + this.a + ", " + this.b + ", " + this.c + "] -> [" + this.d + ", " + this.e + ", " + this.f + "]";
    }

    public boolean e() {
        return Double.isNaN(this.a) || Double.isNaN(this.b) || Double.isNaN(this.c) || Double.isNaN(this.d) || Double.isNaN(this.e) || Double.isNaN(this.f);
    }

    public Vec3D f() {
        return new Vec3D(MathHelper.d(0.5, this.a, this.d), MathHelper.d(0.5, this.b, this.e), MathHelper.d(0.5, this.c, this.f));
    }

    public Vec3D g() {
        return new Vec3D(MathHelper.d(0.5, this.a, this.d), this.b, MathHelper.d(0.5, this.c, this.f));
    }

    public Vec3D h() {
        return new Vec3D(this.a, this.b, this.c);
    }

    public Vec3D i() {
        return new Vec3D(this.d, this.e, this.f);
    }

    public static AxisAlignedBB a(Vec3D center, double xSize, double ySize, double zSize) {
        return new AxisAlignedBB(center.g - xSize / 2.0, center.h - ySize / 2.0, center.i - zSize / 2.0, center.g + xSize / 2.0, center.h + ySize / 2.0, center.i + zSize / 2.0);
    }

    public static class a {
        private float a = Float.POSITIVE_INFINITY;
        private float b = Float.POSITIVE_INFINITY;
        private float c = Float.POSITIVE_INFINITY;
        private float d = Float.NEGATIVE_INFINITY;
        private float e = Float.NEGATIVE_INFINITY;
        private float f = Float.NEGATIVE_INFINITY;

        public void a(Vector3fc pos) {
            this.a = Math.min(this.a, pos.x());
            this.b = Math.min(this.b, pos.y());
            this.c = Math.min(this.c, pos.z());
            this.d = Math.max(this.d, pos.x());
            this.e = Math.max(this.e, pos.y());
            this.f = Math.max(this.f, pos.z());
        }

        public AxisAlignedBB a() {
            return new AxisAlignedBB(this.a, this.b, this.c, this.d, this.e, this.f);
        }
    }
}

