/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.phys.Vec2F;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vec3D
implements IPosition {
    public static final Codec<Vec3D> a = Codec.DOUBLE.listOf().comapFlatMap(list -> SystemUtils.a(list, 3).map(list1 -> new Vec3D((Double)list1.get(0), (Double)list1.get(1), (Double)list1.get(2))), vec3 -> List.of(Double.valueOf(vec3.a()), Double.valueOf(vec3.b()), Double.valueOf(vec3.c())));
    public static final StreamCodec<ByteBuf, Vec3D> b = new StreamCodec<ByteBuf, Vec3D>(){

        public Vec3D a(ByteBuf buffer) {
            return PacketDataSerializer.g(buffer);
        }

        public void a(ByteBuf buffer, Vec3D value) {
            PacketDataSerializer.a(buffer, value);
        }
    };
    public static final Vec3D c = new Vec3D(0.0, 0.0, 0.0);
    public static final Vec3D d = new Vec3D(1.0, 0.0, 0.0);
    public static final Vec3D e = new Vec3D(0.0, 1.0, 0.0);
    public static final Vec3D f = new Vec3D(0.0, 0.0, 1.0);
    public final double g;
    public final double h;
    public final double i;

    public static Vec3D a(BaseBlockPosition toCopy) {
        return new Vec3D(toCopy.u(), toCopy.v(), toCopy.w());
    }

    public static Vec3D a(BaseBlockPosition toCopy, double offsetX, double offsetY, double offsetZ) {
        return new Vec3D((double)toCopy.u() + offsetX, (double)toCopy.v() + offsetY, (double)toCopy.w() + offsetZ);
    }

    public static Vec3D b(BaseBlockPosition toCopy) {
        return Vec3D.a(toCopy, 0.5, 0.5, 0.5);
    }

    public static Vec3D c(BaseBlockPosition toCopy) {
        return Vec3D.a(toCopy, 0.5, 0.0, 0.5);
    }

    public static Vec3D a(BaseBlockPosition toCopy, double verticalOffset) {
        return Vec3D.a(toCopy, 0.5, verticalOffset, 0.5);
    }

    public Vec3D(double x2, double y2, double z2) {
        this.g = x2;
        this.h = y2;
        this.i = z2;
    }

    public Vec3D(Vector3fc vector) {
        this(vector.x(), vector.y(), vector.z());
    }

    public Vec3D(BaseBlockPosition vector) {
        this(vector.u(), vector.v(), vector.w());
    }

    public Vec3D a(Vec3D vec) {
        return new Vec3D(vec.g - this.g, vec.h - this.h, vec.i - this.i);
    }

    public Vec3D d() {
        double squareRoot = Math.sqrt(this.g * this.g + this.h * this.h + this.i * this.i);
        return squareRoot < (double)1.0E-5f ? c : new Vec3D(this.g / squareRoot, this.h / squareRoot, this.i / squareRoot);
    }

    public double b(Vec3D vec) {
        return this.g * vec.g + this.h * vec.h + this.i * vec.i;
    }

    public Vec3D c(Vec3D vec) {
        return new Vec3D(this.h * vec.i - this.i * vec.h, this.i * vec.g - this.g * vec.i, this.g * vec.h - this.h * vec.g);
    }

    public Vec3D d(Vec3D vec) {
        return this.a(vec.g, vec.h, vec.i);
    }

    public Vec3D a(double amount) {
        return this.a(amount, amount, amount);
    }

    public Vec3D a(double x2, double y2, double z2) {
        return this.b(-x2, -y2, -z2);
    }

    public Vec3D b(double amount) {
        return this.b(amount, amount, amount);
    }

    public Vec3D e(Vec3D vec) {
        return this.b(vec.g, vec.h, vec.i);
    }

    public Vec3D b(double x2, double y2, double z2) {
        return new Vec3D(this.g + x2, this.h + y2, this.i + z2);
    }

    public boolean a(IPosition pos, double distance) {
        return this.c(pos.a(), pos.b(), pos.c()) < distance * distance;
    }

    public double f(Vec3D vec) {
        double d2 = vec.g - this.g;
        double d1 = vec.h - this.h;
        double d22 = vec.i - this.i;
        return Math.sqrt(d2 * d2 + d1 * d1 + d22 * d22);
    }

    public double g(Vec3D vec) {
        double d2 = vec.g - this.g;
        double d1 = vec.h - this.h;
        double d22 = vec.i - this.i;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public double c(double x2, double y2, double z2) {
        double d2 = x2 - this.g;
        double d1 = y2 - this.h;
        double d22 = z2 - this.i;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public boolean a(Vec3D pos, double horizontalDistance, double verticalDistance) {
        double d2 = pos.a() - this.g;
        double d1 = pos.b() - this.h;
        double d22 = pos.c() - this.i;
        return MathHelper.e(d2, d22) < MathHelper.n(horizontalDistance) && Math.abs(d1) < verticalDistance;
    }

    public Vec3D c(double factor) {
        return this.d(factor, factor, factor);
    }

    public Vec3D e() {
        return this.c(-1.0);
    }

    public Vec3D h(Vec3D vec) {
        return this.d(vec.g, vec.h, vec.i);
    }

    public Vec3D d(double factorX, double factorY, double factorZ) {
        return new Vec3D(this.g * factorX, this.h * factorY, this.i * factorZ);
    }

    public Vec3D f() {
        return new Vec3D(this.g, 0.0, this.i);
    }

    public Vec3D a(RandomSource random, float factor) {
        return this.b((random.i() - 0.5f) * factor, (random.i() - 0.5f) * factor, (random.i() - 0.5f) * factor);
    }

    public Vec3D b(RandomSource random, float factor) {
        return this.b((random.i() - 0.5f) * factor, 0.0, (random.i() - 0.5f) * factor);
    }

    public double g() {
        return Math.sqrt(this.g * this.g + this.h * this.h + this.i * this.i);
    }

    public double h() {
        return this.g * this.g + this.h * this.h + this.i * this.i;
    }

    public double i() {
        return Math.sqrt(this.g * this.g + this.i * this.i);
    }

    public double j() {
        return this.g * this.g + this.i * this.i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof Vec3D)) return false;
        Vec3D vec3 = (Vec3D)other;
        if (Double.compare(vec3.g, this.g) != 0) return false;
        if (Double.compare(vec3.h, this.h) != 0) return false;
        if (Double.compare(vec3.i, this.i) != 0) return false;
        return true;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.g);
        int i2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.h);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.i);
        return 31 * i2 + (int)(l2 ^ l2 >>> 32);
    }

    public String toString() {
        return "(" + this.g + ", " + this.h + ", " + this.i + ")";
    }

    public Vec3D a(Vec3D to, double delta) {
        return new Vec3D(MathHelper.d(delta, this.g, to.g), MathHelper.d(delta, this.h, to.h), MathHelper.d(delta, this.i, to.i));
    }

    public Vec3D a(float pitch) {
        float cos = MathHelper.b((double)pitch);
        float sin = MathHelper.a((double)pitch);
        double d2 = this.g;
        double d1 = this.h * (double)cos + this.i * (double)sin;
        double d22 = this.i * (double)cos - this.h * (double)sin;
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D b(float yaw) {
        float cos = MathHelper.b((double)yaw);
        float sin = MathHelper.a((double)yaw);
        double d2 = this.g * (double)cos + this.i * (double)sin;
        double d1 = this.h;
        double d22 = this.i * (double)cos - this.g * (double)sin;
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D c(float roll) {
        float cos = MathHelper.b((double)roll);
        float sin = MathHelper.a((double)roll);
        double d2 = this.g * (double)cos + this.h * (double)sin;
        double d1 = this.h * (double)cos - this.g * (double)sin;
        double d22 = this.i;
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D k() {
        return new Vec3D(-this.i, this.h, this.g);
    }

    public static Vec3D a(Vec2F rot) {
        return Vec3D.a(rot.j, rot.k);
    }

    public static Vec3D a(float pitch, float yaw) {
        float cos = MathHelper.b((double)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sin = MathHelper.a((double)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.b((double)(-pitch * ((float)Math.PI / 180)));
        float sin1 = MathHelper.a((double)(-pitch * ((float)Math.PI / 180)));
        return new Vec3D(sin * f2, sin1, cos * f2);
    }

    public Vec2F l() {
        float f2 = (float)Math.atan2(-this.g, this.i) * 57.295776f;
        float f1 = (float)Math.asin(-this.h / Math.sqrt(this.g * this.g + this.h * this.h + this.i * this.i)) * 57.295776f;
        return new Vec2F(f1, f2);
    }

    public Vec3D a(EnumSet<EnumDirection.EnumAxis> axes) {
        double d2 = axes.contains(EnumDirection.EnumAxis.a) ? (double)MathHelper.c(this.g) : this.g;
        double d1 = axes.contains(EnumDirection.EnumAxis.b) ? (double)MathHelper.c(this.h) : this.h;
        double d22 = axes.contains(EnumDirection.EnumAxis.c) ? (double)MathHelper.c(this.i) : this.i;
        return new Vec3D(d2, d1, d22);
    }

    public double a(EnumDirection.EnumAxis axis) {
        return axis.a(this.g, this.h, this.i);
    }

    public Vec3D a(EnumDirection.EnumAxis axis, double length) {
        double d2 = axis == EnumDirection.EnumAxis.a ? length : this.g;
        double d1 = axis == EnumDirection.EnumAxis.b ? length : this.h;
        double d22 = axis == EnumDirection.EnumAxis.c ? length : this.i;
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D a(EnumDirection direction, double length) {
        BaseBlockPosition unitVec3i = direction.q();
        return new Vec3D(this.g + length * (double)unitVec3i.u(), this.h + length * (double)unitVec3i.v(), this.i + length * (double)unitVec3i.w());
    }

    @Override
    public final double a() {
        return this.g;
    }

    @Override
    public final double b() {
        return this.h;
    }

    @Override
    public final double c() {
        return this.i;
    }

    public Vector3f m() {
        return new Vector3f((float)this.g, (float)this.h, (float)this.i);
    }

    public Vec3D i(Vec3D vector) {
        return vector.h() == 0.0 ? vector : vector.c(this.b(vector)).c(1.0 / vector.h());
    }

    public static Vec3D a(Vec2F rotation, Vec3D pos) {
        float cos = MathHelper.b((double)((rotation.k + 90.0f) * ((float)Math.PI / 180)));
        float sin = MathHelper.a((double)((rotation.k + 90.0f) * ((float)Math.PI / 180)));
        float cos1 = MathHelper.b((double)(-rotation.j * ((float)Math.PI / 180)));
        float sin1 = MathHelper.a((double)(-rotation.j * ((float)Math.PI / 180)));
        float cos2 = MathHelper.b((double)((-rotation.j + 90.0f) * ((float)Math.PI / 180)));
        float sin2 = MathHelper.a((double)((-rotation.j + 90.0f) * ((float)Math.PI / 180)));
        Vec3D vec3 = new Vec3D(cos * cos1, sin1, sin * cos1);
        Vec3D vec31 = new Vec3D(cos * cos2, sin2, sin * cos2);
        Vec3D vec32 = vec3.c(vec31).c(-1.0);
        double d2 = vec3.g * pos.i + vec31.g * pos.h + vec32.g * pos.g;
        double d1 = vec3.h * pos.i + vec31.h * pos.h + vec32.h * pos.g;
        double d22 = vec3.i * pos.i + vec31.i * pos.h + vec32.i * pos.g;
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D j(Vec3D pos) {
        return Vec3D.a(this.l(), pos);
    }

    public boolean n() {
        return Double.isFinite(this.g) && Double.isFinite(this.h) && Double.isFinite(this.i);
    }
}

