/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickList;

public class TickListServer<T>
implements LevelTickAccess<T> {
    private static final Comparator<LevelChunkTicks<?>> a = (levelChunkTicks, levelChunkTicks1) -> NextTickListEntry.b.compare(levelChunkTicks.b(), levelChunkTicks1.b());
    private final LongPredicate b;
    private final Long2ObjectMap<LevelChunkTicks<T>> c = new Long2ObjectOpenHashMap();
    private final Long2LongMap d = (Long2LongMap)SystemUtils.a(new Long2LongOpenHashMap(), (? super T map) -> map.defaultReturnValue(Long.MAX_VALUE));
    private final Queue<LevelChunkTicks<T>> e = new PriorityQueue(a);
    private final Queue<NextTickListEntry<T>> f = new ArrayDeque<NextTickListEntry<T>>();
    private final List<NextTickListEntry<T>> g = new ArrayList<NextTickListEntry<T>>();
    private final Set<NextTickListEntry<?>> h = new ObjectOpenCustomHashSet(NextTickListEntry.c);
    private final BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> i = (levelChunkTicks, scheduledTick) -> {
        if (scheduledTick.equals(levelChunkTicks.b())) {
            this.b((NextTickListEntry<T>)scheduledTick);
        }
    };

    public TickListServer(LongPredicate tickCheck) {
        this.b = tickCheck;
    }

    public void a(ChunkCoordIntPair chunkPos, LevelChunkTicks<T> chunkTicks) {
        long packedChunkPos = chunkPos.b();
        this.c.put(packedChunkPos, chunkTicks);
        NextTickListEntry<T> scheduledTick = chunkTicks.b();
        if (scheduledTick != null) {
            this.d.put(packedChunkPos, scheduledTick.c());
        }
        chunkTicks.a(this.i);
    }

    public void a(ChunkCoordIntPair chunkPos) {
        long packedChunkPos = chunkPos.b();
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.c.remove(packedChunkPos);
        this.d.remove(packedChunkPos);
        if (levelChunkTicks != null) {
            levelChunkTicks.a(null);
        }
    }

    @Override
    public void a(NextTickListEntry<T> tick) {
        long packedChunkPos = ChunkCoordIntPair.a(tick.b());
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.c.get(packedChunkPos);
        if (levelChunkTicks == null) {
            SystemUtils.b("Trying to schedule tick in not loaded position " + String.valueOf(tick.b()));
        } else {
            levelChunkTicks.a(tick);
        }
    }

    public void a(long gameTime, int maxAllowedTicks, BiConsumer<BlockPosition, T> ticker) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("collect");
        this.a(gameTime, maxAllowedTicks, profilerFiller);
        profilerFiller.b("run");
        profilerFiller.a("ticksToRun", this.f.size());
        this.a(ticker);
        profilerFiller.b("cleanup");
        this.c();
        profilerFiller.c();
    }

    private void a(long gameTime, int maxAllowedTicks, GameProfilerFiller profiler) {
        this.a(gameTime);
        profiler.a("containersToTick", this.e.size());
        this.a(gameTime, maxAllowedTicks);
        this.b();
    }

    private void a(long gameTime) {
        ObjectIterator objectIterator = Long2LongMaps.fastIterator((Long2LongMap)this.d);
        while (objectIterator.hasNext()) {
            Long2LongMap.Entry entry = (Long2LongMap.Entry)objectIterator.next();
            long longKey = entry.getLongKey();
            long longValue = entry.getLongValue();
            if (longValue > gameTime) continue;
            LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.c.get(longKey);
            if (levelChunkTicks == null) {
                objectIterator.remove();
                continue;
            }
            NextTickListEntry scheduledTick = levelChunkTicks.b();
            if (scheduledTick == null) {
                objectIterator.remove();
                continue;
            }
            if (scheduledTick.c() > gameTime) {
                entry.setValue(scheduledTick.c());
                continue;
            }
            if (!this.b.test(longKey)) continue;
            objectIterator.remove();
            this.e.add(levelChunkTicks);
        }
    }

    private void a(long gameTime, int maxAllowedTicks) {
        LevelChunkTicks<T> levelChunkTicks;
        while (this.a(maxAllowedTicks) && (levelChunkTicks = this.e.poll()) != null) {
            NextTickListEntry<T> scheduledTick = levelChunkTicks.c();
            this.c(scheduledTick);
            this.a(this.e, levelChunkTicks, gameTime, maxAllowedTicks);
            NextTickListEntry<T> scheduledTick1 = levelChunkTicks.b();
            if (scheduledTick1 == null) continue;
            if (scheduledTick1.c() <= gameTime && this.a(maxAllowedTicks)) {
                this.e.add(levelChunkTicks);
                continue;
            }
            this.b(scheduledTick1);
        }
    }

    private void b() {
        for (LevelChunkTicks levelChunkTicks : this.e) {
            this.b(levelChunkTicks.b());
        }
    }

    private void b(NextTickListEntry<T> tick) {
        this.d.put(ChunkCoordIntPair.a(tick.b()), tick.c());
    }

    private void a(Queue<LevelChunkTicks<T>> containersToTick, LevelChunkTicks<T> levelChunkTicks, long gameTime, int maxAllowedTicks) {
        if (this.a(maxAllowedTicks)) {
            NextTickListEntry<T> scheduledTick1;
            NextTickListEntry<T> scheduledTick;
            LevelChunkTicks<T> levelChunkTicks1 = containersToTick.peek();
            NextTickListEntry<T> nextTickListEntry = scheduledTick = levelChunkTicks1 != null ? levelChunkTicks1.b() : null;
            while (this.a(maxAllowedTicks) && (scheduledTick1 = levelChunkTicks.b()) != null && scheduledTick1.c() <= gameTime && (scheduledTick == null || NextTickListEntry.b.compare(scheduledTick1, scheduledTick) <= 0)) {
                levelChunkTicks.c();
                this.c(scheduledTick1);
            }
        }
    }

    private void c(NextTickListEntry<T> tick) {
        this.f.add(tick);
    }

    private boolean a(int maxAllowedTicks) {
        return this.f.size() < maxAllowedTicks;
    }

    private void a(BiConsumer<BlockPosition, T> ticker) {
        while (!this.f.isEmpty()) {
            NextTickListEntry<T> scheduledTick = this.f.poll();
            if (!this.h.isEmpty()) {
                this.h.remove(scheduledTick);
            }
            this.g.add(scheduledTick);
            ticker.accept(scheduledTick.b(), (BlockPosition)scheduledTick.a());
        }
    }

    private void c() {
        this.f.clear();
        this.e.clear();
        this.g.clear();
        this.h.clear();
    }

    @Override
    public boolean a(BlockPosition pos, T type) {
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.c.get(ChunkCoordIntPair.a(pos));
        return levelChunkTicks != null && levelChunkTicks.a(pos, type);
    }

    @Override
    public boolean b(BlockPosition pos, T type) {
        this.d();
        return this.h.contains(NextTickListEntry.a(type, pos));
    }

    private void d() {
        if (this.h.isEmpty() && !this.f.isEmpty()) {
            this.h.addAll(this.f);
        }
    }

    private void a(StructureBoundingBox area, a<T> action) {
        int sectionPosMinX = SectionPosition.a((double)area.h());
        int sectionPosMinZ = SectionPosition.a((double)area.j());
        int sectionPosMaxX = SectionPosition.a((double)area.k());
        int sectionPosMaxZ = SectionPosition.a((double)area.m());
        for (int i2 = sectionPosMinX; i2 <= sectionPosMaxX; ++i2) {
            for (int i1 = sectionPosMinZ; i1 <= sectionPosMaxZ; ++i1) {
                long packedChunkPos = ChunkCoordIntPair.d(i2, i1);
                LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.c.get(packedChunkPos);
                if (levelChunkTicks == null) continue;
                action.accept(packedChunkPos, levelChunkTicks);
            }
        }
    }

    public void a(StructureBoundingBox area) {
        Predicate<NextTickListEntry> predicate = scheduledTick -> area.b(scheduledTick.b());
        this.a(area, (long pos, LevelChunkTicks<T> container) -> {
            NextTickListEntry scheduledTick = container.b();
            container.a(predicate);
            NextTickListEntry scheduledTick1 = container.b();
            if (scheduledTick1 != scheduledTick) {
                if (scheduledTick1 != null) {
                    this.b(scheduledTick1);
                } else {
                    this.d.remove(pos);
                }
            }
        });
        this.g.removeIf(predicate);
        this.f.removeIf(predicate);
    }

    public void a(StructureBoundingBox area, BaseBlockPosition offset) {
        this.a(this, area, offset);
    }

    public void a(TickListServer<T> levelTicks, StructureBoundingBox area, BaseBlockPosition offset) {
        ArrayList list = new ArrayList();
        Predicate<NextTickListEntry> predicate = scheduledTick -> area.b(scheduledTick.b());
        levelTicks.g.stream().filter(predicate).forEach(list::add);
        levelTicks.f.stream().filter(predicate).forEach(list::add);
        levelTicks.a(area, (long pos, LevelChunkTicks<T> container) -> container.d().filter(predicate).forEach(list::add));
        LongSummaryStatistics longSummaryStatistics = list.stream().mapToLong(NextTickListEntry::e).summaryStatistics();
        long min = longSummaryStatistics.getMin();
        long max = longSummaryStatistics.getMax();
        list.forEach(scheduledTick -> this.a(new NextTickListEntry(scheduledTick.a(), scheduledTick.b().a(offset), scheduledTick.c(), scheduledTick.d(), scheduledTick.e() - min + max + 1L)));
    }

    @Override
    public int a() {
        return this.c.values().stream().mapToInt(TickList::a).sum();
    }

    @FunctionalInterface
    static interface a<T> {
        public void accept(long var1, LevelChunkTicks<T> var3);
    }
}

