/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.timeline;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyframeTrack;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.level.World;
import net.minecraft.world.timeline.AttributeTrack;
import net.minecraft.world.timeline.AttributeTrackSampler;

public class Timeline {
    public static final Codec<Holder<Timeline>> a = RegistryFixedCodec.a(Registries.bw);
    private static final Codec<Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>>> d = Codec.dispatchedMap(EnvironmentAttributes.T, SystemUtils.b(AttributeTrack::a));
    public static final Codec<Timeline> b = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.r.optionalFieldOf("period_ticks").forGetter(timeline -> timeline.e), (App)d.optionalFieldOf("tracks", Map.of()).forGetter(timeline -> timeline.f)).apply((Applicative)instance, Timeline::new)).validate(Timeline::b);
    public static final Codec<Timeline> c = b.xmap(Timeline::a, Timeline::a);
    private final Optional<Integer> e;
    private final Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> f;

    private static Timeline a(Timeline timeline) {
        Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> map = Map.copyOf(Maps.filterKeys(timeline.f, EnvironmentAttribute::d));
        return new Timeline(timeline.e, map);
    }

    Timeline(Optional<Integer> periodTicks, Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> tracks) {
        this.e = periodTicks;
        this.f = tracks;
    }

    private static DataResult<Timeline> b(Timeline timeline) {
        if (timeline.e.isEmpty()) {
            return DataResult.success((Object)timeline);
        }
        int i2 = timeline.e.get();
        DataResult dataResult = DataResult.success((Object)timeline);
        for (AttributeTrack<?, ?> attributeTrack : timeline.f.values()) {
            dataResult = dataResult.apply2stable((timeline1, attributeTrack1) -> timeline1, AttributeTrack.a(attributeTrack, i2));
        }
        return dataResult;
    }

    public static a a() {
        return new a();
    }

    public long a(World level) {
        long totalTicks = this.b(level);
        return this.e.isEmpty() ? totalTicks : totalTicks % (long)this.e.get().intValue();
    }

    public long b(World level) {
        return level.al();
    }

    public Optional<Integer> b() {
        return this.e;
    }

    public Set<EnvironmentAttribute<?>> c() {
        return this.f.keySet();
    }

    public <Value> AttributeTrackSampler<Value, ?> a(EnvironmentAttribute<Value> attribute, LongSupplier dayTimeGetter) {
        AttributeTrack<?, ?> attributeTrack = this.f.get(attribute);
        if (attributeTrack == null) {
            throw new IllegalStateException("Timeline has no track for " + String.valueOf(attribute));
        }
        return attributeTrack.a(attribute, this.e, dayTimeGetter);
    }

    public static class a {
        private Optional<Integer> a = Optional.empty();
        private final ImmutableMap.Builder<EnvironmentAttribute<?>, AttributeTrack<?, ?>> b = ImmutableMap.builder();

        a() {
        }

        public a a(int periodTicks) {
            this.a = Optional.of(periodTicks);
            return this;
        }

        public <Value, Argument> a a(EnvironmentAttribute<Value> attribute, AttributeModifier<Value, Argument> modifier, Consumer<KeyframeTrack.a<Argument>> builder) {
            attribute.a().a(modifier);
            KeyframeTrack.a builder1 = new KeyframeTrack.a();
            builder.accept(builder1);
            this.b.put(attribute, new AttributeTrack<Value, Argument>(modifier, builder1.a()));
            return this;
        }

        public <Value> a a(EnvironmentAttribute<Value> attribute, Consumer<KeyframeTrack.a<Value>> builder) {
            return this.a(attribute, AttributeModifier.a(), builder);
        }

        public Timeline a() {
            return new Timeline(this.a, (Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>>)this.b.build());
        }
    }
}

