/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import io.papermc.paper.PaperBootstrap;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;

public class Main {
    public static final Instant BOOT_TIME = Instant.now();
    public static boolean useJline = true;
    public static boolean useConsole = true;

    public static void main(String[] args) {
        if (System.getProperty("jdk.nio.maxCachedBufferSize") == null) {
            System.setProperty("jdk.nio.maxCachedBufferSize", "262144");
        }
        OptionParser parser = new OptionParser(){
            {
                this.acceptsAll(Arrays.asList("?", "help"), "Show the help");
                this.acceptsAll(Arrays.asList("c", "config"), "Properties file to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("server.properties"), (Object[])new File[0]).describedAs("Properties file");
                this.acceptsAll(Arrays.asList("P", "plugins"), "Plugin directory to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("plugins"), (Object[])new File[0]).describedAs("Plugin directory");
                this.acceptsAll(Arrays.asList("h", "host", "server-ip"), "Host to listen on").withRequiredArg().ofType(String.class).describedAs("Hostname or IP");
                this.acceptsAll(Arrays.asList("W", "world-dir", "universe", "world-container"), "World container").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]).describedAs("Directory containing worlds");
                this.acceptsAll(Arrays.asList("w", "world", "level-name"), "World name").withRequiredArg().ofType(String.class).describedAs("World name");
                this.acceptsAll(Arrays.asList("p", "port", "server-port"), "Port to listen on").withRequiredArg().ofType(Integer.class).describedAs("Port");
                this.accepts("serverId", "Server ID").withRequiredArg();
                this.accepts("jfrProfile", "Enable JFR profiling");
                this.accepts("pidFile", "pid File").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
                this.acceptsAll(Arrays.asList("o", "online-mode"), "Whether to use online authentication").withRequiredArg().ofType(Boolean.class).describedAs("Authentication");
                this.acceptsAll(Arrays.asList("s", "size", "max-players"), "Maximum amount of players").withRequiredArg().ofType(Integer.class).describedAs("Server size");
                this.acceptsAll(Arrays.asList("d", "date-format"), "Format of the date to display in the console (for log entries)").withRequiredArg().ofType(SimpleDateFormat.class).describedAs("Log date format");
                this.accepts("log-pattern", "Specifies the log filename pattern").withRequiredArg().ofType(String.class).defaultsTo((Object)"server.log", (Object[])new String[0]).describedAs("Log filename");
                this.accepts("log-limit", "Limits the maximum size of the log file (0 = unlimited)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]).describedAs("Max log size");
                this.accepts("log-count", "Specified how many log files to cycle through").withRequiredArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Log count");
                this.accepts("log-append", "Whether to append to the log file").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]).describedAs("Log append");
                this.accepts("log-strip-color", "Strips color codes from log file");
                this.acceptsAll(Arrays.asList("b", "bukkit-settings"), "File for bukkit settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("bukkit.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Arrays.asList("C", "commands-settings"), "File for command settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("commands.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.accepts("forceUpgrade", "Whether to force a world upgrade");
                this.accepts("eraseCache", "Whether to force cache erase during world upgrade");
                this.accepts("recreateRegionFiles", "Whether to recreate region files during world upgrade");
                this.accepts("safeMode", "Loads level with vanilla datapack only");
                this.accepts("nogui", "Disables the graphical console");
                this.accepts("nojline", "Disables jline and emulates the vanilla console");
                this.accepts("noconsole", "Disables the console");
                this.acceptsAll(Arrays.asList("v", "version"), "Show the CraftBukkit Version");
                this.accepts("demo", "Demo mode");
                this.accepts("initSettings", "Only create configuration files and then exit");
                this.acceptsAll(Arrays.asList("S", "spigot-settings"), "File for spigot settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("spigot.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Arrays.asList("paper-dir", "paper-settings-directory"), "Directory for Paper settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("config"), (Object[])new File[0]).describedAs("Config directory");
                this.acceptsAll(Arrays.asList("paper", "paper-settings"), "File for Paper settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("paper.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Arrays.asList("add-plugin", "add-extra-plugin-jar"), "Specify paths to extra plugin jars to be loaded in addition to those in the plugins folder. This argument can be specified multiple times, once for each extra plugin jar path.").withRequiredArg().ofType(File.class).defaultsTo((Object[])new File[0]).describedAs("Jar file");
                this.acceptsAll(Arrays.asList("add-plugin-dir", "add-extra-plugin-dir"), "Specify paths to extra plugin directories to be loaded in addition to the plugins folder. This argument can be specified multiple times, once for each extra plugin dir path.").withRequiredArg().ofType(File.class).defaultsTo((Object[])new File[0]).describedAs("Plugin directory");
                this.accepts("server-name", "Name of the server").withRequiredArg().ofType(String.class).defaultsTo((Object)"Unknown Server", (Object[])new String[0]).describedAs("Name");
            }
        };
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
        }
        if (options == null || options.has("?")) {
            try {
                parser.printHelpOn((OutputStream)System.out);
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (options.has("v")) {
            System.out.println(CraftServer.class.getPackage().getImplementationVersion());
        } else {
            String path = new File(".").getAbsolutePath();
            if (path.contains("!") || path.contains("+")) {
                System.err.println("Cannot run server in a directory with ! or + in the pathname. Please rename the affected folders and try again.");
                return;
            }
            boolean skip = Boolean.getBoolean("Paper.IgnoreJavaVersion");
            String javaVersionName = System.getProperty("java.version");
            boolean isPreRelease = javaVersionName.contains("-");
            if (isPreRelease) {
                if (!skip) {
                    System.err.println("Unsupported Java detected (" + javaVersionName + "). You are running an unsupported, non official, version. Only general availability versions of Java are supported. Please update your Java version. See https://docs.papermc.io/paper/faq#unsupported-java-detected-what-do-i-do for more information.");
                    return;
                }
                System.err.println("Unsupported Java detected (" + javaVersionName + "), but the check was skipped. Proceed with caution! ");
            }
            try {
                if (options.has("nojline")) {
                    System.setProperty("terminal.jline", "false");
                    useJline = false;
                }
                if (options.has("noconsole")) {
                    useConsole = false;
                    useJline = false;
                    System.setProperty("terminal.jline", "false");
                }
                System.setProperty("library.jansi.version", "Paper");
                System.setProperty("jdk.console", "java.base");
                PaperBootstrap.boot(options);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    static {
        System.setProperty("java.util.logging.manager", "io.papermc.paper.log.CustomLogManager");
    }
}

