/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.Raid;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R7.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Raider;
import org.bukkit.persistence.PersistentDataContainer;

public final class CraftRaid
implements Raid {
    private final net.minecraft.world.entity.raid.Raid handle;
    private final World level;

    public CraftRaid(net.minecraft.world.entity.raid.Raid handle, World level) {
        this.handle = handle;
        this.level = level;
    }

    public boolean isStarted() {
        return this.handle.i();
    }

    public long getActiveTicks() {
        return this.handle.B;
    }

    public int getBadOmenLevel() {
        return this.handle.F;
    }

    public void setBadOmenLevel(int badOmenLevel) {
        int max = this.handle.k();
        Preconditions.checkArgument((0 <= badOmenLevel && badOmenLevel <= max ? 1 : 0) != 0, (String)"Bad Omen level must be between 0 and %s", (int)max);
        this.handle.F = badOmenLevel;
    }

    public Location getLocation() {
        BlockPosition pos = this.handle.q();
        return CraftLocation.toBukkit((BaseBlockPosition)pos, this.level);
    }

    public Raid.RaidStatus getStatus() {
        if (this.handle.d()) {
            return Raid.RaidStatus.STOPPED;
        }
        if (this.handle.e()) {
            return Raid.RaidStatus.VICTORY;
        }
        if (this.handle.f()) {
            return Raid.RaidStatus.LOSS;
        }
        return Raid.RaidStatus.ONGOING;
    }

    public int getSpawnedGroups() {
        return this.handle.j();
    }

    public int getTotalGroups() {
        return this.handle.M + (this.handle.F > 1 ? 1 : 0);
    }

    public int getTotalWaves() {
        return this.handle.M;
    }

    public void setTotalWaves(int waves) {
        Preconditions.checkArgument((waves > 0 ? 1 : 0) != 0, (Object)"Total waves must be greater than 0");
        Preconditions.checkArgument((waves <= 7 ? 1 : 0) != 0, (Object)"Total waves must not be greater than 7");
        Preconditions.checkArgument((waves >= this.getSpawnedGroups() ? 1 : 0) != 0, (String)"Total waves must be greater than or equal to the current spawned groups (%s)", (int)this.getSpawnedGroups());
        this.handle.M = waves;
    }

    public float getTotalHealth() {
        return this.handle.o();
    }

    public Set<UUID> getHeroes() {
        return Collections.unmodifiableSet(this.handle.A);
    }

    public List<Raider> getRaiders() {
        return (List)this.handle.getRaiders().stream().map(entityRaider -> (Raider)entityRaider.getBukkitEntity()).collect(ImmutableList.toImmutableList());
    }

    public net.minecraft.world.entity.raid.Raid getHandle() {
        return this.handle;
    }

    public int getId() {
        return this.handle.idOrNegativeOne;
    }

    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.I);
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.handle.persistentDataContainer;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CraftRaid craftRaid = (CraftRaid)o2;
        return this.handle.equals(craftRaid.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

