/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemType;

public enum CraftStatistic {
    ANIMALS_BRED(StatisticList.R),
    AVIATE_ONE_CM(StatisticList.C),
    BELL_RING(StatisticList.aB),
    BOAT_ONE_CM(StatisticList.y),
    ARMOR_CLEANED(StatisticList.Z),
    BANNER_CLEANED(StatisticList.aa),
    CLEAN_SHULKER_BOX(StatisticList.ab),
    CLIMB_ONE_CM(StatisticList.u),
    CROUCH_ONE_CM(StatisticList.q),
    DAMAGE_ABSORBED(StatisticList.N),
    DAMAGE_BLOCKED_BY_SHIELD(StatisticList.M),
    DAMAGE_DEALT(StatisticList.I),
    DAMAGE_DEALT_ABSORBED(StatisticList.J),
    DAMAGE_DEALT_RESISTED(StatisticList.K),
    DAMAGE_RESISTED(StatisticList.O),
    DAMAGE_TAKEN(StatisticList.L),
    DEATHS(StatisticList.P),
    DROP_COUNT(StatisticList.H),
    CAKE_SLICES_EATEN(StatisticList.W),
    ITEM_ENCHANTED(StatisticList.am),
    FALL_ONE_CM(StatisticList.t),
    CAULDRON_FILLED(StatisticList.X),
    FISH_CAUGHT(StatisticList.T),
    FLY_ONE_CM(StatisticList.v),
    HAPPY_GHAST_ONE_CM(StatisticList.A),
    HORSE_ONE_CM(StatisticList.B),
    DISPENSER_INSPECTED(StatisticList.ag),
    DROPPER_INSPECTED(StatisticList.ae),
    HOPPER_INSPECTED(StatisticList.af),
    INTERACT_WITH_ANVIL(StatisticList.aE),
    BEACON_INTERACTION(StatisticList.ad),
    INTERACT_WITH_BLAST_FURNACE(StatisticList.au),
    BREWINGSTAND_INTERACTION(StatisticList.ac),
    INTERACT_WITH_CAMPFIRE(StatisticList.ax),
    INTERACT_WITH_CARTOGRAPHY_TABLE(StatisticList.ay),
    CRAFTING_TABLE_INTERACTION(StatisticList.ap),
    FURNACE_INTERACTION(StatisticList.ao),
    INTERACT_WITH_GRINDSTONE(StatisticList.aF),
    INTERACT_WITH_LECTERN(StatisticList.aw),
    INTERACT_WITH_LOOM(StatisticList.az),
    INTERACT_WITH_SMITHING_TABLE(StatisticList.aH),
    INTERACT_WITH_SMOKER(StatisticList.av),
    INTERACT_WITH_STONECUTTER(StatisticList.aA),
    JUMP(StatisticList.G),
    LEAVE_GAME(StatisticList.j),
    MINECART_ONE_CM(StatisticList.x),
    MOB_KILLS(StatisticList.Q),
    NAUTILUS_ONE_CM(StatisticList.F),
    OPEN_BARREL(StatisticList.at),
    CHEST_OPENED(StatisticList.aq),
    ENDERCHEST_OPENED(StatisticList.al),
    SHULKER_BOX_OPENED(StatisticList.as),
    PIG_ONE_CM(StatisticList.z),
    NOTEBLOCK_PLAYED(StatisticList.ah),
    RECORD_PLAYED(StatisticList.an),
    PLAY_ONE_MINUTE(StatisticList.k),
    PLAYER_KILLS(StatisticList.S),
    FLOWER_POTTED(StatisticList.aj),
    RAID_TRIGGER(StatisticList.aC),
    RAID_WIN(StatisticList.aD),
    SLEEP_IN_BED(StatisticList.ar),
    SNEAK_TIME(StatisticList.o),
    SPRINT_ONE_CM(StatisticList.r),
    STRIDER_ONE_CM(StatisticList.E),
    SWIM_ONE_CM(StatisticList.D),
    TALKED_TO_VILLAGER(StatisticList.U),
    TARGET_HIT(StatisticList.aG),
    TIME_SINCE_DEATH(StatisticList.m),
    TIME_SINCE_REST(StatisticList.n),
    TOTAL_WORLD_TIME(StatisticList.l),
    TRADED_WITH_VILLAGER(StatisticList.V),
    TRAPPED_CHEST_TRIGGERED(StatisticList.ak),
    NOTEBLOCK_TUNED(StatisticList.ai),
    CAULDRON_USED(StatisticList.Y),
    WALK_ON_WATER_ONE_CM(StatisticList.s),
    WALK_ONE_CM(StatisticList.p),
    WALK_UNDER_WATER_ONE_CM(StatisticList.w),
    BREAK_ITEM(MinecraftKey.b("broken")),
    CRAFT_ITEM(MinecraftKey.b("crafted")),
    DROP(MinecraftKey.b("dropped")),
    KILL_ENTITY(MinecraftKey.b("killed")),
    ENTITY_KILLED_BY(MinecraftKey.b("killed_by")),
    MINE_BLOCK(MinecraftKey.b("mined")),
    PICKUP(MinecraftKey.b("picked_up")),
    USE_ITEM(MinecraftKey.b("used"));

    private final MinecraftKey minecraftKey;
    private final Statistic bukkit;
    private static final BiMap<MinecraftKey, Statistic> statistics;

    private CraftStatistic(MinecraftKey minecraftKey) {
        this.minecraftKey = minecraftKey;
        this.bukkit = Statistic.valueOf((String)this.name());
        Preconditions.checkState((this.bukkit != null ? 1 : 0) != 0, (String)"Bukkit statistic %s does not exist", (Object)this.name());
    }

    public static Statistic getBukkitStatistic(net.minecraft.stats.Statistic<?> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        IRegistry<?> statRegistry = statistic.a().b();
        MinecraftKey nmsKey = BuiltInRegistries.w.b(statistic.a());
        if (statRegistry == BuiltInRegistries.l) {
            nmsKey = (MinecraftKey)statistic.b();
        }
        return (Statistic)statistics.get((Object)nmsKey);
    }

    public static net.minecraft.stats.Statistic getNMSStatistic(Statistic bukkit) {
        Preconditions.checkArgument((bukkit.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"This method only accepts untyped statistics");
        net.minecraft.stats.Statistic<MinecraftKey> nms = StatisticList.i.b((MinecraftKey)statistics.inverse().get((Object)bukkit));
        Preconditions.checkArgument((nms != null ? 1 : 0) != 0, (String)"NMS Statistic %s does not exist", (Object)bukkit);
        return nms;
    }

    private static net.minecraft.stats.Statistic getBlockTypeStatistic(Statistic stat, BlockType blockType) {
        Preconditions.checkArgument((blockType != null ? 1 : 0) != 0, (Object)"BlockType cannot be null");
        try {
            if (stat == Statistic.MINE_BLOCK) {
                return StatisticList.a.b(CraftBlockType.bukkitToMinecraftNew(blockType));
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return null;
        }
        return null;
    }

    private static net.minecraft.stats.Statistic getItemTypeStatistic(Statistic stat, ItemType itemType) {
        Preconditions.checkArgument((itemType != null ? 1 : 0) != 0, (Object)"ItemType cannot be null");
        try {
            if (stat == Statistic.CRAFT_ITEM) {
                return StatisticList.b.b(CraftItemType.bukkitToMinecraftNew(itemType));
            }
            if (stat == Statistic.USE_ITEM) {
                return StatisticList.c.b(CraftItemType.bukkitToMinecraftNew(itemType));
            }
            if (stat == Statistic.BREAK_ITEM) {
                return StatisticList.d.b(CraftItemType.bukkitToMinecraftNew(itemType));
            }
            if (stat == Statistic.PICKUP) {
                return StatisticList.e.b(CraftItemType.bukkitToMinecraftNew(itemType));
            }
            if (stat == Statistic.DROP) {
                return StatisticList.f.b(CraftItemType.bukkitToMinecraftNew(itemType));
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return null;
        }
        return null;
    }

    public static net.minecraft.stats.Statistic getEntityStatistic(Statistic stat, EntityType entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        if (entity.getName() != null) {
            EntityTypes<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entity);
            if (stat == Statistic.KILL_ENTITY) {
                return StatisticList.g.b(nmsEntity);
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return StatisticList.h.b(nmsEntity);
            }
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(net.minecraft.stats.Statistic<EntityTypes<?>> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        return CraftEntityType.minecraftToBukkit(statistic.b());
    }

    public static Material getMaterialFromStatistic(net.minecraft.stats.Statistic<?> statistic) {
        Object obj = statistic.b();
        if (obj instanceof Item) {
            Item statisticItemValue = (Item)obj;
            return CraftItemType.minecraftToBukkit(statisticItemValue);
        }
        obj = statistic.b();
        if (obj instanceof Block) {
            Block statisticBlockValue = (Block)obj;
            return CraftBlockType.minecraftToBukkit(statisticBlockValue);
        }
        return null;
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        return manager.a(CraftStatistic.getNMSStatistic(statistic));
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, int newValue, EntityPlayer player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, material, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, material, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic, Material material) {
        net.minecraft.stats.Statistic nmsStatistic;
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        if (statistic.getType() == Statistic.Type.BLOCK) {
            Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material %s must be a block", (Object)material);
            BlockType blockType = material.asBlockType();
            nmsStatistic = CraftStatistic.getBlockTypeStatistic(statistic, blockType);
        } else if (statistic.getType() == Statistic.Type.ITEM) {
            Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s must be an item", (Object)material);
            ItemType itemType = material.asItemType();
            nmsStatistic = CraftStatistic.getItemTypeStatistic(statistic, itemType);
        } else {
            throw new IllegalArgumentException("This statistic does not take a Material parameter");
        }
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int newValue, EntityPlayer player) {
        net.minecraft.stats.Statistic nmsStatistic;
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        if (statistic.getType() == Statistic.Type.BLOCK) {
            Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material %s must be a block", (Object)material);
            BlockType blockType = material.asBlockType();
            nmsStatistic = CraftStatistic.getBlockTypeStatistic(statistic, blockType);
        } else if (statistic.getType() == Statistic.Type.ITEM) {
            Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s must be an item", (Object)material);
            ItemType itemType = material.asItemType();
            nmsStatistic = CraftStatistic.getItemTypeStatistic(statistic, itemType);
        } else {
            throw new IllegalArgumentException("This statistic does not take a Material parameter");
        }
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int newValue, EntityPlayer player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        for (CraftStatistic statistic : CraftStatistic.values()) {
            statisticBuilder.put((Object)statistic.minecraftKey, (Object)statistic.bukkit);
        }
        statistics = statisticBuilder.build();
    }
}

