/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.border.WorldBorder;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;

public class CraftWorldBorder
implements WorldBorder {
    private final World world;
    private final net.minecraft.world.level.border.WorldBorder handle;

    public CraftWorldBorder(CraftWorld world) {
        this.world = world;
        this.handle = world.getHandle().w();
    }

    public CraftWorldBorder(net.minecraft.world.level.border.WorldBorder handle) {
        this.world = null;
        this.handle = handle;
    }

    public World getWorld() {
        return this.world;
    }

    public void reset() {
        this.getHandle().applySettings(WorldBorder.c.a);
    }

    public double getSize() {
        return this.handle.j();
    }

    public void setSize(double newSize) {
        Preconditions.checkArgument((newSize >= 1.0 && newSize <= this.getMaxSize() ? 1 : 0) != 0, (String)"newSize must be between 1.0D and %s", (Object)this.getMaxSize());
        this.handle.a(newSize);
    }

    public void changeSize(double newSize, long ticks) {
        Preconditions.checkArgument((ticks >= 0L && ticks <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"ticks must be between 0-%s", (int)Integer.MAX_VALUE);
        Preconditions.checkArgument((newSize >= 1.0 && newSize <= this.getMaxSize() ? 1 : 0) != 0, (String)"newSize must be between 1.0D and %s", (Object)this.getMaxSize());
        if (ticks > 0L) {
            long startTime = this.getWorld() != null ? this.getWorld().getGameTime() : 0L;
            this.handle.a(this.handle.j(), newSize, ticks, startTime);
        } else {
            this.handle.a(newSize);
        }
    }

    public Location getCenter() {
        double x2 = this.handle.h();
        double z2 = this.handle.i();
        return new Location(this.world, x2, 0.0, z2);
    }

    public void setCenter(double x2, double z2) {
        Preconditions.checkArgument((Math.abs(x2) <= this.getMaxCenterCoordinate() ? 1 : 0) != 0, (String)"x coordinate cannot be outside +- %s", (Object)this.getMaxCenterCoordinate());
        Preconditions.checkArgument((Math.abs(z2) <= this.getMaxCenterCoordinate() ? 1 : 0) != 0, (String)"z coordinate cannot be outside +- %s", (Object)this.getMaxCenterCoordinate());
        this.handle.c(x2, z2);
    }

    public void setCenter(Location location) {
        this.setCenter(location.getX(), location.getZ());
    }

    public double getDamageBuffer() {
        return this.handle.o();
    }

    public void setDamageBuffer(double blocks) {
        this.handle.b(blocks);
    }

    public double getDamageAmount() {
        return this.handle.p();
    }

    public void setDamageAmount(double damage) {
        this.handle.c(damage);
    }

    public int getWarningTimeTicks() {
        return this.handle.r();
    }

    public void setWarningTimeTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be lower than 0");
        this.handle.b(ticks);
    }

    public int getWarningDistance() {
        return this.handle.s();
    }

    public void setWarningDistance(int distance) {
        this.handle.c(distance);
    }

    public boolean isInside(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        return (this.world == null || location.getWorld().equals((Object)this.world)) && this.handle.a(BlockPosition.a(location.getX(), location.getY(), location.getZ()));
    }

    public double getMaxSize() {
        return 5.9999968E7;
    }

    public double getMaxCenterCoordinate() {
        return 2.9999984E7;
    }

    public net.minecraft.world.level.border.WorldBorder getHandle() {
        return this.handle;
    }

    public boolean isVirtual() {
        return this.world == null;
    }
}

