/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.attribute;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttributeInstance;

public class CraftAttributeMap
implements Attributable {
    private final AttributeMapBase handle;
    private static final ImmutableMap<String, String> LEGACY_ATTRIBUTE_MAP = ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"generic.max_health").put((Object)"Max Health", (Object)"generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"horse.jump_strength").put((Object)"Jump Strength", (Object)"horse.jump_strength").put((Object)"generic.followRange", (Object)"generic.follow_range").put((Object)"Follow Range", (Object)"generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"generic.movement_speed").put((Object)"Movement Speed", (Object)"generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"generic.flying_speed").put((Object)"Flying Speed", (Object)"generic.flying_speed").put((Object)"generic.attackDamage", (Object)"generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"generic.attack_speed").put((Object)"generic.armorToughness", (Object)"generic.armor_toughness").buildOrThrow();

    public static String convertIfNeeded(String nms) {
        if (!(nms = (String)LEGACY_ATTRIBUTE_MAP.getOrDefault((Object)nms, (Object)nms)).toLowerCase(Locale.ROOT).equals(nms) || nms.indexOf(32) != -1) {
            return null;
        }
        return nms;
    }

    public CraftAttributeMap(AttributeMapBase handle) {
        this.handle = handle;
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"attribute");
        AttributeModifiable nms = this.handle.a(CraftAttribute.bukkitToMinecraftHolder(attribute));
        return nms == null ? null : new CraftAttributeInstance(nms, attribute);
    }

    public void registerAttribute(Attribute attribute) {
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"attribute");
        this.handle.registerAttribute(CraftAttribute.bukkitToMinecraftHolder(attribute));
    }
}

