/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.mojang.logging.LogUtils;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class CraftBlockEntityState<T extends TileEntity>
extends CraftBlockState
implements TileState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final T blockEntity;
    private final T snapshot;
    public boolean snapshotDisabled;
    public static boolean DISABLE_SNAPSHOT = false;

    public CraftBlockEntityState(World world, T blockEntity) {
        super(world, ((TileEntity)blockEntity).aD_(), ((TileEntity)blockEntity).o());
        this.blockEntity = blockEntity;
        try {
            this.snapshotDisabled = DISABLE_SNAPSHOT;
            this.snapshot = DISABLE_SNAPSHOT ? this.blockEntity : this.createSnapshot(blockEntity);
            if (this.snapshot != null) {
                this.load(this.snapshot);
            }
        }
        catch (Throwable thr) {
            if (thr instanceof ThreadDeath) {
                throw (ThreadDeath)thr;
            }
            throw new RuntimeException((String)(world == null ? "Failed to read non-placed BlockState" : "Failed to read BlockState at: world: " + world.getName() + " location: (" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")"), thr);
        }
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.blockEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.blockEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public IRegistryCustom getRegistryAccess() {
        GeneratorAccess worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.J_() : CraftRegistry.getMinecraftRegistry();
    }

    private T createSnapshot(T from) {
        if (from == null) {
            return null;
        }
        NBTTagCompound tag = ((TileEntity)from).b(this.getRegistryAccess());
        return (T)TileEntity.a(this.getPosition(), this.getHandle(), tag, this.getRegistryAccess());
    }

    public Set<DataComponentType<?>> applyComponents(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        Set<DataComponentType<?>> result = ((TileEntity)this.snapshot).applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public DataComponentMap collectComponents() {
        return ((TileEntity)this.snapshot).t();
    }

    public void loadData(NBTTagCompound tag) {
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "CraftBlockEntityState@" + this.getPosition().y(), LOGGER);){
            ((TileEntity)this.snapshot).b(TagValueInput.a((ProblemReporter)problemReporter, (HolderLookup.a)this.getRegistryAccess(), tag));
        }
        this.load(this.snapshot);
    }

    private void copyData(T from, T to) {
        NBTTagCompound tag = ((TileEntity)from).b(this.getRegistryAccess());
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "CraftBlockEntityState@" + this.getPosition().y(), LOGGER);){
            ((TileEntity)to).b(TagValueInput.a((ProblemReporter)problemReporter, (HolderLookup.a)this.getRegistryAccess(), tag));
        }
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected TileEntity getBlockEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().c_(this.getPosition());
    }

    public NBTTagCompound getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return ((TileEntity)this.snapshot).b(this.getRegistryAccess());
    }

    public NBTTagCompound getUpdateNBT() {
        this.applyTo(this.snapshot);
        return ((TileEntity)this.snapshot).a(this.getRegistryAccess());
    }

    public NBTTagCompound getSnapshotCustomNbtOnly() {
        this.applyTo(this.snapshot);
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "CraftBlockEntityState@" + this.getPosition().y(), LOGGER);){
            TagValueOutput output = TagValueOutput.createWrappingWithContext(problemReporter, this.getRegistryAccess(), ((TileEntity)this.snapshot).d(this.getRegistryAccess()));
            ((TileEntity)this.snapshot).b(output);
            if (!output.a()) {
                ((TileEntity)this.snapshot).g(output);
            }
            NBTTagCompound nBTTagCompound = output.b();
            return nBTTagCompound;
        }
    }

    protected void load(T blockEntity) {
        if (blockEntity != null && blockEntity != this.snapshot) {
            this.copyData(blockEntity, this.snapshot);
        }
    }

    protected void applyTo(T blockEntity) {
        if (blockEntity != null && blockEntity != this.snapshot) {
            this.copyData(this.snapshot, blockEntity);
        }
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced()) {
            this.getWorldHandle().a(this.getPosition(), ((TileEntity)this.blockEntity).s()).ifPresent(blockEntity -> {
                this.applyTo(blockEntity);
                blockEntity.e();
            });
        }
        return result;
    }

    @Override
    public boolean place(@Block.b int flags) {
        boolean result = super.place(flags);
        this.getWorldHandle().a(this.getPosition(), ((TileEntity)this.blockEntity).s()).ifPresent(blockEntity -> {
            this.applyTo(blockEntity);
            blockEntity.e();
        });
        return result;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((TileEntity)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> getUpdatePacket(@NotNull Location location) {
        return new PacketPlayOutTileEntityData(CraftLocation.toBlockPosition(location), ((TileEntity)this.snapshot).s(), this.getUpdateNBT());
    }

    @Override
    public abstract CraftBlockEntityState<T> copy();

    @Override
    public abstract CraftBlockEntityState<T> copy(Location var1);

    public boolean isSnapshot() {
        return !this.snapshotDisabled;
    }
}

