/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBanner;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBarrel;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBed;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBeehive;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBell;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCampfire;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftChest;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftChiseledBookshelf;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftComparator;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftConduit;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCrafter;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCreakingHeart;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftDropper;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftEndPortal;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftEnderChest;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftFurnaceFurnace;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftHangingSign;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftHopper;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftJigsaw;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftLectern;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftMovingPiston;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftShelf;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftSmoker;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftStructureBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftTestBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftTestInstanceBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftTrialSpawner;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftVault;

public final class CraftBlockStates {
    private static final Map<Material, BlockStateFactory<?>> FACTORIES = new HashMap();
    private static final BlockStateFactory<?> DEFAULT_FACTORY = new BlockStateFactory<CraftBlockState>(CraftBlockState.class){

        @Override
        public CraftBlockState createBlockState(World world, BlockPosition pos, IBlockData state, TileEntity blockEntity) {
            Preconditions.checkState((blockEntity == null ? 1 : 0) != 0, (String)"Unexpected BlockState for %s", (Object)CraftBlockType.minecraftToBukkit(state.b()));
            return new CraftBlockState(world, pos, state);
        }
    };
    private static final Map<TileEntityTypes<?>, BlockStateFactory<?>> FACTORIES_BY_BLOCK_ENTITY_TYPE = new HashMap();

    private static void register(TileEntityTypes<?> type, BlockStateFactory<?> factory) {
        FACTORIES_BY_BLOCK_ENTITY_TYPE.put(type, factory);
    }

    private static void register(Material blockType, BlockStateFactory<?> factory) {
        FACTORIES.put(blockType, factory);
    }

    private static <T extends TileEntity, B extends CraftBlockEntityState<T>> void register(TileEntityTypes<? extends T> blockEntityType, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor) {
        BlockEntityStateFactory<? extends T, B> factory = new BlockEntityStateFactory<T, B>(blockStateType, blockStateConstructor, blockEntityType);
        for (Block block : blockEntityType.aa) {
            CraftBlockStates.register(CraftBlockType.minecraftToBukkit(block), factory);
        }
        CraftBlockStates.register(blockEntityType, factory);
    }

    private static BlockStateFactory<?> getFactory(Material material) {
        return FACTORIES.getOrDefault(material, DEFAULT_FACTORY);
    }

    private static BlockStateFactory<?> getFactory(Material material, TileEntityTypes<?> type) {
        if (type != null) {
            return FACTORIES_BY_BLOCK_ENTITY_TYPE.getOrDefault(type, CraftBlockStates.getFactory(material));
        }
        return CraftBlockStates.getFactory(material);
    }

    public static Class<? extends CraftBlockState> getBlockStateType(Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        return CraftBlockStates.getFactory((Material)material).blockStateType;
    }

    public static TileEntity createNewBlockEntity(Material material) {
        BlockStateFactory<?> factory = CraftBlockStates.getFactory(material);
        if (factory instanceof BlockEntityStateFactory) {
            return ((BlockEntityStateFactory)factory).createBlockEntity(BlockPosition.c, CraftBlockType.bukkitToMinecraft(material).m());
        }
        return null;
    }

    public static Class<? extends CraftBlockState> getBlockStateType(TileEntityTypes<?> blockEntityType) {
        Preconditions.checkNotNull(blockEntityType, (Object)"blockEntityType is null");
        return CraftBlockStates.getFactory(null, blockEntityType).blockStateType;
    }

    public static BlockState getBlockState(org.bukkit.block.Block block) {
        return CraftBlockStates.getBlockState(block, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockState getBlockState(org.bukkit.block.Block block, boolean useSnapshot) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        BlockPosition pos = craftBlock.getPosition();
        IBlockData state = craftBlock.getNMS();
        TileEntity blockEntity = craftBlock.getHandle().c_(pos);
        boolean prev = CraftBlockEntityState.DISABLE_SNAPSHOT;
        CraftBlockEntityState.DISABLE_SNAPSHOT = !useSnapshot;
        try {
            CraftBlockState blockState = CraftBlockStates.getBlockState(world, pos, state, blockEntity);
            blockState.setWorldHandle(craftBlock.getHandle());
            CraftBlockState craftBlockState = blockState;
            return craftBlockState;
        }
        finally {
            CraftBlockEntityState.DISABLE_SNAPSHOT = prev;
        }
    }

    @Deprecated
    public static BlockState getBlockState(BlockPosition pos, Material material, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(CraftRegistry.getMinecraftRegistry(), pos, material, blockEntityTag);
    }

    public static BlockState getBlockState(IWorldReader world, BlockPosition pos, Material material, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(world.J_(), pos, material, blockEntityTag);
    }

    public static BlockState getBlockState(IRegistryCustom registry, BlockPosition pos, Material material, @Nullable NBTTagCompound blockEntityTag) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        IBlockData blockData = CraftBlockType.bukkitToMinecraft(material).m();
        return CraftBlockStates.getBlockState(registry, pos, blockData, blockEntityTag);
    }

    @Deprecated
    public static BlockState getBlockState(IBlockData state, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(CraftRegistry.getMinecraftRegistry(), BlockPosition.c, state, blockEntityTag);
    }

    public static BlockState getBlockState(IWorldReader level, BlockPosition blockPosition, IBlockData state, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(level.J_(), blockPosition, state, blockEntityTag);
    }

    public static BlockState getBlockState(IRegistryCustom registry, BlockPosition pos, IBlockData state, @Nullable NBTTagCompound blockEntityTag) {
        Preconditions.checkNotNull((Object)pos, (Object)"pos is null");
        Preconditions.checkNotNull((Object)state, (Object)"state is null");
        TileEntity blockEntity = blockEntityTag == null ? null : TileEntity.a(pos, state, blockEntityTag, registry);
        return CraftBlockStates.getBlockState(null, pos, state, blockEntity);
    }

    public static CraftBlockState getBlockState(World world, BlockPosition pos, IBlockData state, TileEntity blockEntity) {
        Material material = CraftBlockType.minecraftToBukkit(state.b());
        BlockStateFactory<?> factory = world != null && blockEntity == null && CraftBlockStates.isBlockEntityOptional(material) ? DEFAULT_FACTORY : CraftBlockStates.getFactory(material, blockEntity != null ? blockEntity.s() : null);
        return factory.createBlockState(world, pos, state, blockEntity);
    }

    public static boolean isBlockEntityOptional(Material material) {
        return material == Material.MOVING_PISTON;
    }

    public static CraftBlockState getBlockState(GeneratorAccess world, BlockPosition pos) {
        return new CraftBlockState(CraftBlock.at(world, pos));
    }

    @Nullable
    public static TileEntityTypes<?> getBlockEntityType(Material material) {
        TileEntityTypes tileEntityTypes;
        BlockStateFactory<?> factory = FACTORIES.get(material);
        if (factory instanceof BlockEntityStateFactory) {
            BlockEntityStateFactory blockEntityStateFactory = (BlockEntityStateFactory)factory;
            tileEntityTypes = blockEntityStateFactory.blockEntityType;
        } else {
            tileEntityTypes = null;
        }
        return tileEntityTypes;
    }

    private CraftBlockStates() {
    }

    static {
        CraftBlockStates.register(TileEntityTypes.u, CraftBanner.class, CraftBanner::new);
        CraftBlockStates.register(TileEntityTypes.B, CraftBarrel.class, CraftBarrel::new);
        CraftBlockStates.register(TileEntityTypes.p, CraftBeacon.class, CraftBeacon::new);
        CraftBlockStates.register(TileEntityTypes.z, CraftBed.class, CraftBed::new);
        CraftBlockStates.register(TileEntityTypes.I, CraftBeehive.class, CraftBeehive::new);
        CraftBlockStates.register(TileEntityTypes.F, CraftBell.class, CraftBell::new);
        CraftBlockStates.register(TileEntityTypes.D, CraftBlastFurnace.class, CraftBlastFurnace::new);
        CraftBlockStates.register(TileEntityTypes.m, CraftBrewingStand.class, CraftBrewingStand::new);
        CraftBlockStates.register(TileEntityTypes.P, CraftBrushableBlock.class, CraftBrushableBlock::new);
        CraftBlockStates.register(TileEntityTypes.K, CraftCalibratedSculkSensor.class, CraftCalibratedSculkSensor::new);
        CraftBlockStates.register(TileEntityTypes.H, CraftCampfire.class, CraftCampfire::new);
        CraftBlockStates.register(TileEntityTypes.b, CraftChest.class, CraftChest::new);
        CraftBlockStates.register(TileEntityTypes.N, CraftChiseledBookshelf.class, CraftChiseledBookshelf::new);
        CraftBlockStates.register(TileEntityTypes.x, CraftCommandBlock.class, CraftCommandBlock::new);
        CraftBlockStates.register(TileEntityTypes.t, CraftComparator.class, CraftComparator::new);
        CraftBlockStates.register(TileEntityTypes.A, CraftConduit.class, CraftConduit::new);
        CraftBlockStates.register(TileEntityTypes.W, CraftCopperGolemStatue.class, CraftCopperGolemStatue::new);
        CraftBlockStates.register(TileEntityTypes.R, CraftCrafter.class, CraftCrafter::new);
        CraftBlockStates.register(TileEntityTypes.k, CraftCreakingHeart.class, CraftCreakingHeart::new);
        CraftBlockStates.register(TileEntityTypes.r, CraftDaylightDetector.class, CraftDaylightDetector::new);
        CraftBlockStates.register(TileEntityTypes.Q, CraftDecoratedPot.class, CraftDecoratedPot::new);
        CraftBlockStates.register(TileEntityTypes.f, CraftDispenser.class, CraftDispenser::new);
        CraftBlockStates.register(TileEntityTypes.g, CraftDropper.class, CraftDropper::new);
        CraftBlockStates.register(TileEntityTypes.n, CraftEnchantingTable.class, CraftEnchantingTable::new);
        CraftBlockStates.register(TileEntityTypes.w, CraftEndGateway.class, CraftEndGateway::new);
        CraftBlockStates.register(TileEntityTypes.o, CraftEndPortal.class, CraftEndPortal::new);
        CraftBlockStates.register(TileEntityTypes.d, CraftEnderChest.class, CraftEnderChest::new);
        CraftBlockStates.register(TileEntityTypes.a, CraftFurnaceFurnace.class, CraftFurnaceFurnace::new);
        CraftBlockStates.register(TileEntityTypes.i, CraftHangingSign.class, CraftHangingSign::new);
        CraftBlockStates.register(TileEntityTypes.s, CraftHopper.class, CraftHopper::new);
        CraftBlockStates.register(TileEntityTypes.G, CraftJigsaw.class, CraftJigsaw::new);
        CraftBlockStates.register(TileEntityTypes.e, CraftJukebox.class, CraftJukebox::new);
        CraftBlockStates.register(TileEntityTypes.E, CraftLectern.class, CraftLectern::new);
        CraftBlockStates.register(TileEntityTypes.j, CraftCreatureSpawner.class, CraftCreatureSpawner::new);
        CraftBlockStates.register(TileEntityTypes.l, CraftMovingPiston.class, CraftMovingPiston::new);
        CraftBlockStates.register(TileEntityTypes.L, CraftSculkCatalyst.class, CraftSculkCatalyst::new);
        CraftBlockStates.register(TileEntityTypes.J, CraftSculkSensor.class, CraftSculkSensor::new);
        CraftBlockStates.register(TileEntityTypes.M, CraftSculkShrieker.class, CraftSculkShrieker::new);
        CraftBlockStates.register(TileEntityTypes.O, CraftShelf.class, CraftShelf::new);
        CraftBlockStates.register(TileEntityTypes.y, CraftShulkerBox.class, CraftShulkerBox::new);
        CraftBlockStates.register(TileEntityTypes.h, CraftSign.class, CraftSign::new);
        CraftBlockStates.register(TileEntityTypes.q, CraftSkull.class, CraftSkull::new);
        CraftBlockStates.register(TileEntityTypes.C, CraftSmoker.class, CraftSmoker::new);
        CraftBlockStates.register(TileEntityTypes.v, CraftStructureBlock.class, CraftStructureBlock::new);
        CraftBlockStates.register(TileEntityTypes.U, CraftTestBlock.class, CraftTestBlock::new);
        CraftBlockStates.register(TileEntityTypes.V, CraftTestInstanceBlock.class, CraftTestInstanceBlock::new);
        CraftBlockStates.register(TileEntityTypes.c, CraftChest.class, CraftChest::new);
        CraftBlockStates.register(TileEntityTypes.S, CraftTrialSpawner.class, CraftTrialSpawner::new);
        CraftBlockStates.register(TileEntityTypes.T, CraftVault.class, CraftVault::new);
    }

    private static class BlockEntityStateFactory<T extends TileEntity, B extends CraftBlockEntityState<T>>
    extends BlockStateFactory<B> {
        private final BiFunction<World, T, B> blockStateConstructor;
        private final TileEntityTypes<? extends T> blockEntityType;

        protected BlockEntityStateFactory(Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, TileEntityTypes<? extends T> blockEntityType) {
            super(blockStateType);
            this.blockStateConstructor = blockStateConstructor;
            this.blockEntityType = blockEntityType;
        }

        @Override
        public final B createBlockState(World world, BlockPosition pos, IBlockData state, TileEntity blockEntity) {
            if (world != null) {
                Preconditions.checkState((blockEntity != null ? 1 : 0) != 0, (String)"Block entity is null, asynchronous access? %s", (Object)CraftBlock.at(((CraftWorld)world).getHandle(), pos));
            } else if (blockEntity == null) {
                blockEntity = this.createBlockEntity(pos, state);
            }
            return this.createBlockState(world, blockEntity);
        }

        private T createBlockEntity(BlockPosition pos, IBlockData state) {
            return this.blockEntityType.a(pos, state);
        }

        private B createBlockState(World world, T blockEntity) {
            return (B)((CraftBlockEntityState)this.blockStateConstructor.apply(world, (World)blockEntity));
        }
    }

    private static abstract class BlockStateFactory<B extends CraftBlockState> {
        public final Class<B> blockStateType;

        public BlockStateFactory(Class<B> blockStateType) {
            this.blockStateType = blockStateType;
        }

        public abstract B createBlockState(World var1, BlockPosition var2, IBlockData var3, TileEntity var4);
    }
}

