/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.spawner.PaperSharedSpawnerLogic;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;

public class CraftCreatureSpawner
extends CraftBlockEntityState<TileEntityMobSpawner>
implements CreatureSpawner,
PaperSharedSpawnerLogic {
    public CraftCreatureSpawner(World world, TileEntityMobSpawner blockEntity) {
        super(world, blockEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    public EntityType getSpawnedType() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(() -> "spawner@" + String.valueOf(this.getLocation()), LOGGER);){
            ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)this.getRegistryAccess(), spawnData.d());
            Optional<EntityTypes<?>> type = EntityTypes.a(valueInput);
            EntityType entityType = type.map(CraftEntityType::minecraftToBukkit).orElse(null);
            return entityType;
        }
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((TileEntityMobSpawner)this.getSnapshot()).c().l = WeightedList.a();
            ((TileEntityMobSpawner)this.getSnapshot()).c().m = new MobSpawnerData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.isPlaced() ? this.getWorldHandle().G_() : RandomSource.a();
        ((TileEntityMobSpawner)this.getSnapshot()).a(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    public EntitySnapshot getSpawnedEntity() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(((TileEntityMobSpawner)this.getSnapshot()).c(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(((TileEntityMobSpawner)this.getSnapshot()).c(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public static void setSpawnedEntity(MobSpawnerAbstract spawner, EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        spawner.l = WeightedList.a();
        if (snapshot == null) {
            spawner.m = new MobSpawnerData();
            return;
        }
        NBTTagCompound compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        spawner.m = new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(((TileEntityMobSpawner)this.getSnapshot()).c(), snapshot, weight, spawnRule, null);
    }

    public static void addPotentialSpawn(MobSpawnerAbstract spawner, EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        NBTTagCompound compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        WeightedList.a<MobSpawnerData> builder = WeightedList.b();
        spawner.l.d().forEach(entry -> builder.a((MobSpawnerData)entry.a(), entry.b()));
        builder.a(new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        spawner.l = builder.a();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(((TileEntityMobSpawner)this.getSnapshot()).c(), entries);
    }

    public static void setPotentialSpawns(MobSpawnerAbstract spawner, Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        WeightedList.a<MobSpawnerData> builder = WeightedList.b();
        for (SpawnerEntry spawnerEntry : entries) {
            NBTTagCompound compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.a(new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        spawner.l = builder.a();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(((TileEntityMobSpawner)this.getSnapshot()).c());
    }

    public static List<SpawnerEntry> getPotentialSpawns(MobSpawnerAbstract spawner) {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (Weighted<MobSpawnerData> entry : spawner.l.d()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(entry.a().a());
            if (snapshot == null) continue;
            SpawnRule rule = entry.a().e().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.b(), rule, CraftCreatureSpawner.getEquipment(entry.a().f())));
        }
        return entries;
    }

    public static MobSpawnerData.a toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new MobSpawnerData.a(new InclusiveRange<Integer>(rule.getMinBlockLight(), rule.getMaxBlockLight()), new InclusiveRange<Integer>(rule.getMinSkyLight(), rule.getMaxSkyLight()));
    }

    public static SpawnRule fromMinecraftRule(MobSpawnerData.a rule) {
        InclusiveRange<Integer> blockLight = rule.a();
        InclusiveRange<Integer> skyLight = rule.b();
        return new SpawnRule(blockLight.b().intValue(), blockLight.b().intValue(), skyLight.a().intValue(), skyLight.b().intValue());
    }

    public String getCreatureTypeName() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(() -> "spawner@" + String.valueOf(this.getLocation()), LOGGER);){
            ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)this.getRegistryAccess(), spawnData.a());
            Optional<EntityTypes<?>> type = EntityTypes.a(valueInput);
            String string = type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
            return string;
        }
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().k;
    }

    public void setDelay(int delay) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().k = delay;
    }

    public int getMinSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().p;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).c().p = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().q;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).c().q = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().t;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().t = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().r;
    }

    public void setSpawnCount(int count) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().r = count;
    }

    public int getRequiredPlayerRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().u;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().u = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().v;
    }

    public void setSpawnRange(int spawnRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().v = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    public static Optional<EquipmentTable> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new EquipmentTable(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((EquipmentSlot)entry.getKey()), Map.Entry::getValue))));
    }

    public static SpawnerEntry.Equipment getEquipment(Optional<EquipmentTable> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit(nms.a()), new HashMap<EquipmentSlot, Float>(nms.b().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((EnumItemSlot)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }

    @Override
    public boolean isActivated() {
        this.requirePlaced();
        return PaperSharedSpawnerLogic.super.isActivated();
    }

    @Override
    public void resetTimer() {
        this.requirePlaced();
        PaperSharedSpawnerLogic.super.resetTimer();
    }

    @Override
    public void setNextSpawnData(MobSpawnerData spawnData) {
        this.getSpawner().a(this.isPlaced() ? this.getInternalWorld() : null, this.getInternalPosition(), spawnData);
    }

    @Override
    public MobSpawnerAbstract getSpawner() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c();
    }

    @Override
    public BlockPosition getInternalPosition() {
        return this.getPosition();
    }

    @Override
    public net.minecraft.world.level.World getInternalWorld() {
        return this.world.getHandle();
    }
}

