/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TrialSpawner;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftTrialSpawnerConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.spawner.TrialSpawnerConfiguration;

public class CraftTrialSpawner
extends CraftBlockEntityState<TrialSpawnerBlockEntity>
implements TrialSpawner {
    private final CraftTrialSpawnerConfiguration normalConfig;
    private final CraftTrialSpawnerConfiguration ominousConfig;

    public CraftTrialSpawner(World world, TrialSpawnerBlockEntity blockEntity) {
        super(world, blockEntity);
        this.normalConfig = new CraftTrialSpawnerConfiguration(blockEntity.c().b(), (TrialSpawnerBlockEntity)this.getSnapshot());
        this.ominousConfig = new CraftTrialSpawnerConfiguration(blockEntity.c().c(), (TrialSpawnerBlockEntity)this.getSnapshot());
    }

    protected CraftTrialSpawner(CraftTrialSpawner state, Location location) {
        super(state, location);
        this.normalConfig = state.normalConfig;
        this.ominousConfig = state.ominousConfig;
    }

    public long getCooldownEnd() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).a.h().c;
    }

    public void setCooldownEnd(long ticks) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).a.h().c = ticks;
    }

    public long getNextSpawnAttempt() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).a.h().d;
    }

    public void setNextSpawnAttempt(long ticks) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).a.h().d = ticks;
    }

    public int getCooldownLength() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).a.e();
    }

    public void setCooldownLength(int ticks) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).a.i = ((TrialSpawnerBlockEntity)this.getSnapshot()).a.i.overrideTargetCooldownLength(ticks);
    }

    public int getRequiredPlayerRange() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).a.f();
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).a.i = ((TrialSpawnerBlockEntity)this.getSnapshot()).a.i.overrideRequiredPlayerRange(requiredPlayerRange);
    }

    public Collection<Player> getTrackedPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().a) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            players.add((Object)player);
        }
        return players.build();
    }

    public boolean isTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        return this.getTrialData().a.contains(player.getUniqueId());
    }

    public void startTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().a.add(player.getUniqueId());
    }

    public void stopTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().a.remove(player.getUniqueId());
    }

    public Collection<Entity> getTrackedEntities() {
        ImmutableSet.Builder entities = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().b) {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null) continue;
            entities.add((Object)entity);
        }
        return entities.build();
    }

    public boolean isTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getTrialData().b.contains(entity.getUniqueId());
    }

    public void startTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().b.add(entity.getUniqueId());
    }

    public void stopTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().b.remove(entity.getUniqueId());
    }

    public boolean isOminous() {
        return this.data.a(TrialSpawnerBlock.c, false);
    }

    public void setOminous(boolean ominous) {
        if (!this.data.b(TrialSpawnerBlock.c)) {
            return;
        }
        ((TrialSpawnerBlockEntity)this.getSnapshot()).a.n = ominous;
        if (ominous) {
            this.data = (IBlockData)this.data.b(TrialSpawnerBlock.c, true);
            return;
        }
        this.data = (IBlockData)this.data.b(TrialSpawnerBlock.c, false);
    }

    public TrialSpawnerConfiguration getNormalConfiguration() {
        return this.normalConfig;
    }

    public TrialSpawnerConfiguration getOminousConfiguration() {
        return this.ominousConfig;
    }

    @Override
    protected void applyTo(TrialSpawnerBlockEntity blockEntity) {
        super.applyTo(blockEntity);
        blockEntity.a.i = blockEntity.a.i.overrideConfigs(Holder.a(this.normalConfig.toMinecraft()), Holder.a(this.ominousConfig.toMinecraft()));
    }

    private TrialSpawnerData getTrialData() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).c().h();
    }

    @Override
    public CraftTrialSpawner copy() {
        return new CraftTrialSpawner(this, null);
    }

    @Override
    public CraftTrialSpawner copy(Location location) {
        return new CraftTrialSpawner(this, location);
    }
}

