/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.DecoratedPot;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftDecoratedPot
extends CraftBlockData
implements DecoratedPot {
    private static final BlockStateBoolean CRACKED = DecoratedPotBlock.d;
    private static final BlockStateEnum<EnumDirection> HORIZONTAL_FACING = DecoratedPotBlock.c;
    private static final BlockStateBoolean WATERLOGGED = DecoratedPotBlock.e;

    public CraftDecoratedPot(IBlockData state) {
        super(state);
    }

    public boolean isCracked() {
        return this.get(CRACKED);
    }

    public void setCracked(boolean cracked) {
        this.set(CRACKED, cracked);
    }

    public BlockFace getFacing() {
        return this.get(HORIZONTAL_FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(HORIZONTAL_FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(HORIZONTAL_FACING, BlockFace.class);
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

